/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import java.awt.Dimension;
import javax.media.Format;
import net.sf.fmj.codegen.FormatTraceUtils;
import net.sf.fmj.utility.FormatUtils;

public class VideoFormat
extends Format {
    protected Dimension size;
    protected int maxDataLength = -1;
    protected float frameRate = -1.0f;
    public static final String CINEPAK = "cvid";
    public static final String JPEG = "jpeg";
    public static final String JPEG_RTP = "jpeg/rtp";
    public static final String MPEG = "mpeg";
    public static final String MPEG_RTP = "mpeg/rtp";
    public static final String H261 = "h261";
    public static final String H261_RTP = "h261/rtp";
    public static final String H263 = "h263";
    public static final String H263_RTP = "h263/rtp";
    public static final String H263_1998_RTP = "h263-1998/rtp";
    public static final String RGB = "rgb";
    public static final String YUV = "yuv";
    public static final String IRGB = "irgb";
    public static final String SMC = "smc";
    public static final String RLE = "rle";
    public static final String RPZA = "rpza";
    public static final String MJPG = "mjpg";
    public static final String MJPEGA = "mjpa";
    public static final String MJPEGB = "mjpb";
    public static final String INDEO32 = "iv32";
    public static final String INDEO41 = "iv41";
    public static final String INDEO50 = "iv50";

    public VideoFormat(String encoding) {
        super(encoding);
    }

    public VideoFormat(String encoding, Dimension size, int maxDataLength, Class dataType, float frameRate) {
        super(encoding, dataType);
        this.size = FormatUtils.clone(size);
        this.maxDataLength = maxDataLength;
        this.frameRate = frameRate;
    }

    public Dimension getSize() {
        return this.size;
    }

    public int getMaxDataLength() {
        return this.maxDataLength;
    }

    public Object clone() {
        return new VideoFormat(this.encoding, FormatUtils.clone(this.size), this.maxDataLength, this.dataType, this.frameRate);
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    protected void copy(Format f) {
        super.copy(f);
        VideoFormat oCast = (VideoFormat)f;
        this.size = FormatUtils.clone(oCast.size);
        this.maxDataLength = oCast.maxDataLength;
        this.frameRate = oCast.frameRate;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        if (this.encoding == null) {
            b.append("N/A");
        } else {
            b.append(this.encoding.toUpperCase());
        }
        if (FormatUtils.specified(this.size)) {
            b.append(", ");
            b.append(this.size.width);
            b.append('x');
            b.append(this.size.height);
        }
        if (FormatUtils.specified(this.frameRate)) {
            b.append(", ");
            b.append("FrameRate=");
            b.append(FormatUtils.frameRateToString(this.frameRate));
        }
        if (FormatUtils.specified(this.maxDataLength)) {
            b.append(", ");
            b.append("Length=");
            b.append(this.maxDataLength);
        }
        return b.toString();
    }

    public boolean equals(Object format) {
        if (!super.equals(format)) {
            return false;
        }
        if (!(format instanceof VideoFormat)) {
            return false;
        }
        VideoFormat oCast = (VideoFormat)format;
        return (oCast.size == this.size || oCast.size != null && this.size != null && oCast.size.equals(this.size)) && oCast.maxDataLength == this.maxDataLength && oCast.frameRate == this.frameRate;
    }

    public boolean matches(Format format) {
        boolean result;
        if (!super.matches(format)) {
            if (this.getClass() == FormatUtils.videoFormatClass) {
                FormatTraceUtils.traceMatches(this, format, false);
            }
            return false;
        }
        if (!(format instanceof VideoFormat)) {
            boolean result2 = true;
            if (this.getClass() == FormatUtils.videoFormatClass) {
                FormatTraceUtils.traceMatches(this, format, true);
            }
            return true;
        }
        VideoFormat oCast = (VideoFormat)format;
        boolean bl = result = FormatUtils.matches(oCast.getFrameRate(), this.getFrameRate()) && FormatUtils.matches(oCast.getSize(), this.getSize());
        if (this.getClass() == FormatUtils.videoFormatClass) {
            FormatTraceUtils.traceMatches(this, format, result);
        }
        return result;
    }

    public Format intersects(Format other) {
        Format result = super.intersects(other);
        if (other instanceof VideoFormat) {
            VideoFormat resultCast = (VideoFormat)result;
            VideoFormat oCast = (VideoFormat)other;
            if (this.getClass().isAssignableFrom(other.getClass())) {
                resultCast.size = oCast.size;
                if (FormatUtils.specified(this.size)) {
                    resultCast.size = this.size;
                }
                if (FormatUtils.specified(this.maxDataLength)) {
                    resultCast.maxDataLength = this.maxDataLength;
                }
                if (FormatUtils.specified(this.frameRate)) {
                    resultCast.frameRate = this.frameRate;
                }
            } else if (other.getClass().isAssignableFrom(this.getClass())) {
                resultCast.size = this.size;
                if (!FormatUtils.specified(resultCast.size)) {
                    resultCast.size = oCast.size;
                }
                if (!FormatUtils.specified(resultCast.maxDataLength)) {
                    resultCast.maxDataLength = oCast.maxDataLength;
                }
                if (!FormatUtils.specified(resultCast.frameRate)) {
                    resultCast.frameRate = oCast.frameRate;
                }
            }
        }
        if (this.getClass() == FormatUtils.videoFormatClass) {
            FormatTraceUtils.traceIntersects(this, other, result);
        }
        return result;
    }

    public Format relax() {
        VideoFormat result = (VideoFormat)super.relax();
        result.size = null;
        result.maxDataLength = -1;
        result.frameRate = -1.0f;
        return result;
    }
}

