/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.media.codec.audio.ilbc;

import net.java.sip.communicator.impl.media.codec.audio.ilbc.bitstream;
import net.java.sip.communicator.impl.media.codec.audio.ilbc.ilbc_common;
import net.java.sip.communicator.impl.media.codec.audio.ilbc.ilbc_constants;
import net.java.sip.communicator.impl.media.codec.audio.ilbc.ilbc_ulp;

class ilbc_decoder {
    int consPLICount;
    int prevPLI;
    int prevLag;
    int last_lag;
    int prev_enh_pl;
    float per;
    float[] prevResidual;
    long seed;
    float[] prevLpc;
    ilbc_ulp ULP_inst = null;
    float[] syntMem;
    float[] lsfdeqold;
    float[] old_syntdenum;
    float[] hpomem;
    int use_enhancer;
    float[] enh_buf;
    float[] enh_period;

    void syntFilter(float[] Out, int Out_idx, float[] a, int a_idx, int len, float[] mem) {
        int j;
        int pa;
        int pi;
        int i;
        int po = Out_idx;
        for (i = 0; i < ilbc_constants.LPC_FILTERORDER; ++i) {
            pi = Out_idx + i - 1;
            pa = a_idx + 1;
            int pm = ilbc_constants.LPC_FILTERORDER - 1;
            for (j = 1; j <= i; ++j) {
                int n = po;
                Out[n] = Out[n] - a[pa] * Out[pi];
                ++pa;
                --pi;
            }
            for (j = i + 1; j < ilbc_constants.LPC_FILTERORDER + 1; ++j) {
                int n = po;
                Out[n] = Out[n] - a[pa] * mem[pm];
                ++pa;
                --pm;
            }
            ++po;
        }
        for (i = ilbc_constants.LPC_FILTERORDER; i < len; ++i) {
            pi = Out_idx + i - 1;
            pa = a_idx + 1;
            for (j = 1; j < ilbc_constants.LPC_FILTERORDER + 1; ++j) {
                int n = po;
                Out[n] = Out[n] - a[pa] * Out[pi];
                ++pa;
                --pi;
            }
            ++po;
        }
        System.arraycopy(Out, Out_idx + len - ilbc_constants.LPC_FILTERORDER, mem, 0, ilbc_constants.LPC_FILTERORDER);
    }

    public void LSFinterpolate2a_dec(float[] a, float[] lsf1, float[] lsf2, int lsf2_idx, float coef, int length) {
        float[] lsftmp = new float[ilbc_constants.LPC_FILTERORDER];
        ilbc_common.interpolate(lsftmp, lsf1, lsf2, lsf2_idx, coef, length);
        ilbc_common.lsf2a(a, lsftmp);
    }

    void SimplelsfDEQ(float[] lsfdeq, int[] index, int lpc_n) {
        int j;
        int i;
        int pos = 0;
        int cb_pos = 0;
        for (i = 0; i < ilbc_constants.LSF_NSPLIT; ++i) {
            for (j = 0; j < ilbc_constants.dim_lsfCbTbl[i]; ++j) {
                lsfdeq[pos + j] = ilbc_constants.lsfCbTbl[cb_pos + (int)((long)index[i] * (long)ilbc_constants.dim_lsfCbTbl[i] + (long)j)];
            }
            pos += ilbc_constants.dim_lsfCbTbl[i];
            cb_pos += ilbc_constants.size_lsfCbTbl[i] * ilbc_constants.dim_lsfCbTbl[i];
        }
        if (lpc_n > 1) {
            pos = 0;
            cb_pos = 0;
            for (i = 0; i < ilbc_constants.LSF_NSPLIT; ++i) {
                for (j = 0; j < ilbc_constants.dim_lsfCbTbl[i]; ++j) {
                    lsfdeq[ilbc_constants.LPC_FILTERORDER + pos + j] = ilbc_constants.lsfCbTbl[cb_pos + (int)((long)index[ilbc_constants.LSF_NSPLIT + i] * (long)ilbc_constants.dim_lsfCbTbl[i]) + j];
                }
                pos += ilbc_constants.dim_lsfCbTbl[i];
                cb_pos += ilbc_constants.size_lsfCbTbl[i] * ilbc_constants.dim_lsfCbTbl[i];
            }
        }
    }

    void DecoderInterpolateLSF(float[] syntdenum, float[] weightdenum, float[] lsfdeq, int length) {
        float[] lp = new float[ilbc_constants.LPC_FILTERORDER + 1];
        int lsfdeq2 = length;
        int lp_length = length + 1;
        if (this.ULP_inst.mode == 30) {
            this.LSFinterpolate2a_dec(lp, this.lsfdeqold, lsfdeq, 0, ilbc_constants.lsf_weightTbl_30ms[0], length);
            System.arraycopy(lp, 0, syntdenum, 0, lp_length);
            ilbc_common.bwexpand(weightdenum, 0, lp, ilbc_constants.LPC_CHIRP_WEIGHTDENUM, lp_length);
            int pos = lp_length;
            for (int i = 1; i < 6; ++i) {
                this.LSFinterpolate2a_dec(lp, lsfdeq, lsfdeq, lsfdeq2, ilbc_constants.lsf_weightTbl_30ms[i], length);
                System.arraycopy(lp, 0, syntdenum, pos, lp_length);
                ilbc_common.bwexpand(weightdenum, pos, lp, ilbc_constants.LPC_CHIRP_WEIGHTDENUM, lp_length);
                pos += lp_length;
            }
        } else {
            int pos = 0;
            for (int i = 0; i < this.ULP_inst.nsub; ++i) {
                this.LSFinterpolate2a_dec(lp, this.lsfdeqold, lsfdeq, 0, ilbc_constants.lsf_weightTbl_20ms[i], length);
                System.arraycopy(lp, 0, syntdenum, pos, lp_length);
                ilbc_common.bwexpand(weightdenum, pos, lp, ilbc_constants.LPC_CHIRP_WEIGHTDENUM, lp_length);
                pos += lp_length;
            }
        }
        if (this.ULP_inst.mode == 30) {
            System.arraycopy(lsfdeq, lsfdeq2, this.lsfdeqold, 0, length);
        } else {
            System.arraycopy(lsfdeq, 0, this.lsfdeqold, 0, length);
        }
    }

    public void index_conv_dec(int[] index) {
        for (int k = 1; k < ilbc_constants.CB_NSTAGES; ++k) {
            if (index[k] >= 44 && index[k] < 108) {
                int n = k;
                index[n] = index[n] + 64;
                continue;
            }
            if (index[k] < 108 || index[k] >= 128) continue;
            int n = k;
            index[n] = index[n] + 128;
        }
    }

    public void hpOutput(float[] In, int len, float[] Out, float[] mem) {
        int i;
        int pi = 0;
        int po = 0;
        for (i = 0; i < len; ++i) {
            Out[po] = ilbc_constants.hpo_zero_coefsTbl[0] * In[pi];
            int n = po;
            Out[n] = Out[n] + ilbc_constants.hpo_zero_coefsTbl[1] * mem[0];
            int n2 = po++;
            Out[n2] = Out[n2] + ilbc_constants.hpo_zero_coefsTbl[2] * mem[1];
            mem[1] = mem[0];
            mem[0] = In[pi];
            ++pi;
        }
        po = 0;
        for (i = 0; i < len; ++i) {
            int n = po;
            Out[n] = Out[n] - ilbc_constants.hpo_pole_coefsTbl[1] * mem[2];
            int n3 = po;
            Out[n3] = Out[n3] - ilbc_constants.hpo_pole_coefsTbl[2] * mem[3];
            mem[3] = mem[2];
            mem[2] = Out[po];
            ++po;
        }
    }

    void DownSample(float[] In, int in_idx, float[] Coef, int lengthIn, float[] state, float[] Out) {
        int j;
        float o;
        int i;
        int out_ptr = 0;
        int coef_ptr = 0;
        int in_ptr = in_idx;
        int state_ptr = 0;
        for (i = ilbc_constants.DELAY_DS; i < lengthIn; i += ilbc_constants.FACTOR_DS) {
            coef_ptr = 0;
            in_ptr = in_idx + i;
            state_ptr = ilbc_constants.FILTERORDER_DS - 2;
            o = 0.0f;
            int stop = i < ilbc_constants.FILTERORDER_DS ? i + 1 : ilbc_constants.FILTERORDER_DS;
            for (j = 0; j < stop; ++j) {
                o += Coef[coef_ptr] * In[in_ptr];
                ++coef_ptr;
                --in_ptr;
            }
            for (j = i + 1; j < ilbc_constants.FILTERORDER_DS; ++j) {
                o += Coef[coef_ptr] * state[state_ptr];
                ++coef_ptr;
                --state_ptr;
            }
            Out[out_ptr] = o;
            ++out_ptr;
        }
        for (i = lengthIn + ilbc_constants.FACTOR_DS; i < lengthIn + ilbc_constants.DELAY_DS; i += ilbc_constants.FACTOR_DS) {
            o = 0.0f;
            if (i < lengthIn) {
                coef_ptr = 0;
                in_ptr = in_idx + i;
                for (j = 0; j < ilbc_constants.FILTERORDER_DS; ++j) {
                    o += Coef[coef_ptr] * Out[out_ptr];
                    ++coef_ptr;
                    --out_ptr;
                }
            } else {
                coef_ptr = i - lengthIn;
                in_ptr = in_idx + lengthIn - 1;
                for (j = 0; j < ilbc_constants.FILTERORDER_DS - (i - lengthIn); ++j) {
                    o += Coef[coef_ptr] * In[in_ptr];
                    ++coef_ptr;
                    --in_ptr;
                }
            }
            Out[out_ptr] = o;
            ++out_ptr;
        }
    }

    public int NearestNeighbor(float[] array, float value, int arlength) {
        float crit = array[0] - value;
        float bestcrit = crit * crit;
        int index = 0;
        for (int i = 1; i < arlength; ++i) {
            crit = array[i] - value;
            if (!((crit *= crit) < bestcrit)) continue;
            bestcrit = crit;
            index = i;
        }
        return index;
    }

    public void mycorr1(float[] corr, int corr_idx, float[] seq1, int seq1_idx, int dim1, float[] seq2, int seq2_idx, int dim2) {
        for (int i = 0; i <= dim1 - dim2; ++i) {
            if (corr_idx + i < corr.length) {
                corr[corr_idx + i] = 0.0f;
            }
            for (int j = 0; j < dim2; ++j) {
                int n = corr_idx + i;
                corr[n] = corr[n] + seq1[seq1_idx + i + j] * seq2[seq2_idx + j];
            }
        }
    }

    public void enh_upsample(float[] useq1, float[] seq1, int dim1, int hfl) {
        int k;
        int ps;
        int pp;
        int i;
        int j;
        int[] polyp = new int[ilbc_constants.ENH_UPS0];
        int filterlength = 2 * hfl + 1;
        if (filterlength > dim1) {
            int hfl2 = dim1 / 2;
            for (j = 0; j < ilbc_constants.ENH_UPS0; ++j) {
                polyp[j] = j * filterlength + hfl - hfl2;
            }
            hfl = hfl2;
            filterlength = 2 * hfl + 1;
        } else {
            for (j = 0; j < ilbc_constants.ENH_UPS0; ++j) {
                polyp[j] = j * filterlength;
            }
        }
        int pu = 0;
        for (i = hfl; i < filterlength; ++i) {
            for (j = 0; j < ilbc_constants.ENH_UPS0; ++j) {
                useq1[pu] = 0.0f;
                pp = polyp[j];
                ps = i;
                for (k = 0; k <= i; ++k) {
                    int n = pu;
                    useq1[n] = useq1[n] + seq1[ps] * ilbc_constants.polyphaserTbl[pp];
                    --ps;
                    ++pp;
                }
                ++pu;
            }
        }
        for (i = filterlength; i < dim1; ++i) {
            for (j = 0; j < ilbc_constants.ENH_UPS0; ++j) {
                useq1[pu] = 0.0f;
                pp = polyp[j];
                ps = i;
                for (k = 0; k < filterlength; ++k) {
                    int n = pu;
                    useq1[n] = useq1[n] + seq1[ps] * ilbc_constants.polyphaserTbl[pp];
                    --ps;
                    ++pp;
                }
                ++pu;
            }
        }
        for (int q = 1; q <= hfl; ++q) {
            for (j = 0; j < ilbc_constants.ENH_UPS0; ++j) {
                useq1[pu] = 0.0f;
                pp = polyp[j] + q;
                ps = dim1 - 1;
                for (k = 0; k < filterlength - q; ++k) {
                    int n = pu;
                    useq1[n] = useq1[n] + seq1[ps] * ilbc_constants.polyphaserTbl[pp];
                    --ps;
                    ++pp;
                }
                ++pu;
            }
        }
    }

    public float refiner(float[] seg, int seg_idx, float[] idata, int idatal, int centerStartPos, float estSegPos, float period) {
        int st;
        int searchSegEndPos;
        float[] vect = new float[ilbc_constants.ENH_VECTL];
        float[] corrVec = new float[ilbc_constants.ENH_CORRDIM];
        float[] corrVecUps = new float[ilbc_constants.ENH_CORRDIM * ilbc_constants.ENH_UPS0];
        float updStartPos = 0.0f;
        int estSegPosRounded = (int)((double)estSegPos - 0.5);
        int searchSegStartPos = estSegPosRounded - ilbc_constants.ENH_SLOP;
        if (searchSegStartPos < 0) {
            searchSegStartPos = 0;
        }
        if ((searchSegEndPos = estSegPosRounded + ilbc_constants.ENH_SLOP) + ilbc_constants.ENH_BLOCKL >= idatal) {
            searchSegEndPos = idatal - ilbc_constants.ENH_BLOCKL - 1;
        }
        int corrdim = searchSegEndPos - searchSegStartPos + 1;
        this.mycorr1(corrVec, 0, idata, searchSegStartPos, corrdim + ilbc_constants.ENH_BLOCKL - 1, idata, centerStartPos, ilbc_constants.ENH_BLOCKL);
        this.enh_upsample(corrVecUps, corrVec, corrdim, ilbc_constants.ENH_FL0);
        int tloc = 0;
        float maxv = corrVecUps[0];
        for (int i = 1; i < ilbc_constants.ENH_UPS0 * corrdim; ++i) {
            if (!(corrVecUps[i] > maxv)) continue;
            tloc = i;
            maxv = corrVecUps[i];
        }
        updStartPos = (float)searchSegStartPos + (float)tloc / (float)ilbc_constants.ENH_UPS0 + 1.0f;
        int tloc2 = tloc / ilbc_constants.ENH_UPS0;
        if (tloc > tloc2 * ilbc_constants.ENH_UPS0) {
            ++tloc2;
        }
        if ((st = searchSegStartPos + tloc2 - ilbc_constants.ENH_FL0) < 0) {
            for (int li = 0; li < -st; ++li) {
                vect[li] = 0.0f;
            }
            System.arraycopy(idata, 0, vect, -st, ilbc_constants.ENH_VECTL + st);
        } else {
            int en = st + ilbc_constants.ENH_VECTL;
            if (en > idatal) {
                System.arraycopy(idata, st, vect, 0, ilbc_constants.ENH_VECTL - (en - idatal));
                for (int li = 0; li < en - idatal; ++li) {
                    vect[ilbc_constants.ENH_VECTL - (en - idatal) + li] = 0.0f;
                }
            } else {
                System.arraycopy(idata, st, vect, 0, ilbc_constants.ENH_VECTL);
            }
        }
        int fraction = tloc2 * ilbc_constants.ENH_UPS0 - tloc;
        this.mycorr1(seg, seg_idx, vect, 0, ilbc_constants.ENH_VECTL, ilbc_constants.polyphaserTbl, (2 * ilbc_constants.ENH_FL0 + 1) * fraction, 2 * ilbc_constants.ENH_FL0 + 1);
        return updStartPos;
    }

    public void smath(float[] odata, int odata_idx, float[] sseq, int hl, float alpha0) {
        int psseq;
        int k;
        int i;
        float[] surround = new float[ilbc_constants.BLOCKL_MAX];
        float[] wt = new float[2 * ilbc_constants.ENH_HL + 1];
        for (i = 1; i <= 2 * hl + 1; ++i) {
            wt[i - 1] = 0.5f * (1.0f - (float)Math.cos(2.0f * ilbc_constants.PI * (float)i / (float)(2 * hl + 2)));
        }
        wt[hl] = 0.0f;
        for (i = 0; i < ilbc_constants.ENH_BLOCKL; ++i) {
            surround[i] = sseq[i] * wt[0];
        }
        for (k = 1; k < hl; ++k) {
            psseq = k * ilbc_constants.ENH_BLOCKL;
            for (i = 0; i < ilbc_constants.ENH_BLOCKL; ++i) {
                int n = i;
                surround[n] = surround[n] + sseq[psseq + i] * wt[k];
            }
        }
        for (k = hl + 1; k <= 2 * hl; ++k) {
            psseq = k * ilbc_constants.ENH_BLOCKL;
            for (i = 0; i < ilbc_constants.ENH_BLOCKL; ++i) {
                int n = i;
                surround[n] = surround[n] + sseq[psseq + i] * wt[k];
            }
        }
        float w11 = 0.0f;
        float w10 = 0.0f;
        float w00 = 0.0f;
        psseq = hl * ilbc_constants.ENH_BLOCKL;
        for (i = 0; i < ilbc_constants.ENH_BLOCKL; ++i) {
            w00 += sseq[psseq + i] * sseq[psseq + i];
            w11 += surround[i] * surround[i];
            w10 += surround[i] * sseq[psseq + i];
        }
        if (Math.abs(w11) < 1.0f) {
            w11 = 1.0f;
        }
        float C = (float)Math.sqrt(w00 / w11);
        float errs = 0.0f;
        psseq = hl * ilbc_constants.ENH_BLOCKL;
        for (i = 0; i < ilbc_constants.ENH_BLOCKL; ++i) {
            odata[odata_idx + i] = C * surround[i];
            float err = sseq[psseq + i] - odata[odata_idx + i];
            errs += err * err;
        }
        if (errs > alpha0 * w00) {
            float B;
            float A;
            float denom;
            if (w00 < 1.0f) {
                w00 = 1.0f;
            }
            if ((denom = (w11 * w00 - w10 * w10) / (w00 * w00)) > 1.0E-4f) {
                A = (float)Math.sqrt((alpha0 - alpha0 * alpha0 / 4.0f) / denom);
                B = -alpha0 / 2.0f - A * w10 / w00;
                B += 1.0f;
            } else {
                A = 0.0f;
                B = 1.0f;
            }
            psseq = hl * ilbc_constants.ENH_BLOCKL;
            for (i = 0; i < ilbc_constants.ENH_BLOCKL; ++i) {
                odata[odata_idx + i] = A * surround[i] + B * sseq[psseq + i];
            }
        }
    }

    public void getsseq(float[] sseq, float[] idata, int idatal, int centerStartPos, float[] period, float[] plocs, int periodl, int hl) {
        int li;
        int q;
        float[] blockStartPos = new float[2 * ilbc_constants.ENH_HL + 1];
        int[] lagBlock = new int[2 * ilbc_constants.ENH_HL + 1];
        float[] plocs2 = new float[ilbc_constants.ENH_PLOCSL];
        int centerEndPos = centerStartPos + ilbc_constants.ENH_BLOCKL - 1;
        lagBlock[hl] = this.NearestNeighbor(plocs, 0.5f * (float)(centerStartPos + centerEndPos), periodl);
        blockStartPos[hl] = centerStartPos;
        int psseq = ilbc_constants.ENH_BLOCKL * hl;
        System.arraycopy(idata, centerStartPos, sseq, psseq, ilbc_constants.ENH_BLOCKL);
        for (q = hl - 1; q >= 0; --q) {
            blockStartPos[q] = blockStartPos[q + 1] - period[lagBlock[q + 1]];
            lagBlock[q] = this.NearestNeighbor(plocs, blockStartPos[q] + (float)ilbc_constants.ENH_BLOCKL_HALF - period[lagBlock[q + 1]], periodl);
            if (blockStartPos[q] - (float)ilbc_constants.ENH_OVERHANG >= 0.0f) {
                blockStartPos[q] = this.refiner(sseq, q * ilbc_constants.ENH_BLOCKL, idata, idatal, centerStartPos, blockStartPos[q], period[lagBlock[q + 1]]);
                continue;
            }
            psseq = q * ilbc_constants.ENH_BLOCKL;
            for (li = 0; li < ilbc_constants.ENH_BLOCKL; ++li) {
                sseq[psseq + li] = 0.0f;
            }
        }
        for (int i = 0; i < periodl; ++i) {
            plocs2[i] = plocs[i] - period[i];
        }
        for (q = hl + 1; q <= 2 * hl; ++q) {
            lagBlock[q] = this.NearestNeighbor(plocs2, blockStartPos[q - 1] + (float)ilbc_constants.ENH_BLOCKL_HALF, periodl);
            blockStartPos[q] = blockStartPos[q - 1] + period[lagBlock[q]];
            if (blockStartPos[q] + (float)ilbc_constants.ENH_BLOCKL + (float)ilbc_constants.ENH_OVERHANG < (float)idatal) {
                blockStartPos[q] = this.refiner(sseq, q * ilbc_constants.ENH_BLOCKL, idata, idatal, centerStartPos, blockStartPos[q], period[lagBlock[q]]);
                continue;
            }
            psseq = q * ilbc_constants.ENH_BLOCKL;
            for (li = 0; li < ilbc_constants.ENH_BLOCKL; ++li) {
                sseq[psseq + li] = 0.0f;
            }
        }
    }

    public void enhancer(float[] odata, int odata_idx, float[] idata, int idatal, int centerStartPos, float alpha0, float[] period, float[] plocs, int periodl) {
        float[] sseq = new float[(2 * ilbc_constants.ENH_HL + 1) * ilbc_constants.ENH_BLOCKL];
        this.getsseq(sseq, idata, idatal, centerStartPos, period, plocs, periodl, ilbc_constants.ENH_HL);
        this.smath(odata, odata_idx, sseq, ilbc_constants.ENH_HL, alpha0);
    }

    public float xCorrCoef(float[] target, int t_idx, float[] regressor, int r_idx, int subl) {
        float ftmp1 = 0.0f;
        float ftmp2 = 0.0f;
        for (int i = 0; i < subl; ++i) {
            ftmp1 += target[t_idx + i] * regressor[r_idx + i];
            ftmp2 += regressor[r_idx + i] * regressor[r_idx + i];
        }
        if (ftmp1 > 0.0f) {
            return ftmp1 * ftmp1 / ftmp2;
        }
        return 0.0f;
    }

    int enhancerInterface(float[] out, float[] in) {
        int lag;
        block15: {
            int iblock;
            block14: {
                float cc;
                int ilag;
                float maxcc;
                lag = 0;
                float[] plc_pred = new float[ilbc_constants.ENH_BLOCKL];
                float[] lpState = new float[6];
                float[] downsampled = new float[(ilbc_constants.ENH_NBLOCKS * ilbc_constants.ENH_BLOCKL + 120) / 2];
                int inLen = ilbc_constants.ENH_NBLOCKS * ilbc_constants.ENH_BLOCKL + 120;
                System.arraycopy(this.enh_buf, this.ULP_inst.blockl, this.enh_buf, 0, ilbc_constants.ENH_BUFL - this.ULP_inst.blockl);
                System.arraycopy(in, 0, this.enh_buf, ilbc_constants.ENH_BUFL - this.ULP_inst.blockl, this.ULP_inst.blockl);
                int plc_blockl = this.ULP_inst.mode == 30 ? ilbc_constants.ENH_BLOCKL : 40;
                int ioffset = 0;
                if (this.ULP_inst.mode == 20) {
                    ioffset = 1;
                }
                int i = 3 - ioffset;
                System.arraycopy(this.enh_period, i, this.enh_period, 0, ilbc_constants.ENH_NBLOCKS_TOT - i);
                System.arraycopy(this.enh_buf, (ilbc_constants.ENH_NBLOCKS_EXTRA + ioffset) * ilbc_constants.ENH_BLOCKL - 126, lpState, 0, 6);
                this.DownSample(this.enh_buf, (ilbc_constants.ENH_NBLOCKS_EXTRA + ioffset) * ilbc_constants.ENH_BLOCKL - 120, ilbc_constants.lpFilt_coefsTbl, inLen - ioffset * ilbc_constants.ENH_BLOCKL, lpState, downsampled);
                for (iblock = 0; iblock < ilbc_constants.ENH_NBLOCKS - ioffset; ++iblock) {
                    lag = 10;
                    maxcc = this.xCorrCoef(downsampled, 60 + iblock * ilbc_constants.ENH_BLOCKL_HALF, downsampled, 60 + iblock * ilbc_constants.ENH_BLOCKL_HALF - lag, ilbc_constants.ENH_BLOCKL_HALF);
                    for (ilag = 11; ilag < 60; ++ilag) {
                        cc = this.xCorrCoef(downsampled, 60 + iblock * ilbc_constants.ENH_BLOCKL_HALF, downsampled, 60 + iblock * ilbc_constants.ENH_BLOCKL_HALF - ilag, ilbc_constants.ENH_BLOCKL_HALF);
                        if (!(cc > maxcc)) continue;
                        maxcc = cc;
                        lag = ilag;
                    }
                    this.enh_period[iblock + ilbc_constants.ENH_NBLOCKS_EXTRA + ioffset] = (float)lag * 2.0f;
                }
                if (this.prev_enh_pl == 1) {
                    int isample;
                    int inlag = (int)this.enh_period[ilbc_constants.ENH_NBLOCKS_EXTRA + ioffset];
                    lag = inlag - 1;
                    maxcc = this.xCorrCoef(in, 0, in, lag, plc_blockl);
                    for (ilag = inlag; ilag <= inlag + 1; ++ilag) {
                        cc = this.xCorrCoef(in, 0, in, ilag, plc_blockl);
                        if (!(cc > maxcc)) continue;
                        maxcc = cc;
                        lag = ilag;
                    }
                    this.enh_period[ilbc_constants.ENH_NBLOCKS_EXTRA + ioffset - 1] = lag;
                    int inPtr = lag - 1;
                    int enh_bufPtr1 = plc_blockl - 1;
                    int start = lag > plc_blockl ? plc_blockl : lag;
                    for (isample = start; isample > 0; --isample) {
                        plc_pred[enh_bufPtr1] = in[inPtr];
                        --enh_bufPtr1;
                        --inPtr;
                    }
                    int enh_bufPtr2 = ilbc_constants.ENH_BUFL - 1 - this.ULP_inst.blockl;
                    for (isample = plc_blockl - 1 - lag; isample >= 0; --isample) {
                        plc_pred[enh_bufPtr1] = this.enh_buf[enh_bufPtr2];
                        --enh_bufPtr1;
                        --enh_bufPtr2;
                    }
                    float ftmp2 = 0.0f;
                    float ftmp1 = 0.0f;
                    for (i = 0; i < plc_blockl; ++i) {
                        ftmp2 += this.enh_buf[ilbc_constants.ENH_BUFL - 1 - this.ULP_inst.blockl - i] * this.enh_buf[ilbc_constants.ENH_BUFL - 1 - this.ULP_inst.blockl - i];
                        ftmp1 += plc_pred[i] * plc_pred[i];
                    }
                    if ((ftmp1 = (float)Math.sqrt(ftmp1 / (float)plc_blockl)) > 2.0f * (ftmp2 = (float)Math.sqrt(ftmp2 / (float)plc_blockl)) && (double)ftmp1 > 0.0) {
                        i = 0;
                        while (i < plc_blockl - 10) {
                            int n = i++;
                            plc_pred[n] = plc_pred[n] * (2.0f * ftmp2 / ftmp1);
                        }
                        for (i = plc_blockl - 10; i < plc_blockl; ++i) {
                            int n = i;
                            plc_pred[n] = plc_pred[n] * ((float)(i - plc_blockl + 10) * (1.0f - 2.0f * ftmp2 / ftmp1) / 10.0f + 2.0f * ftmp2 / ftmp1);
                        }
                    }
                    enh_bufPtr1 = ilbc_constants.ENH_BUFL - 1 - this.ULP_inst.blockl;
                    for (i = 0; i < plc_blockl; ++i) {
                        ftmp1 = (float)(i + 1) / (float)(plc_blockl + 1);
                        int n = enh_bufPtr1;
                        this.enh_buf[n] = this.enh_buf[n] * ftmp1;
                        int n2 = enh_bufPtr1--;
                        this.enh_buf[n2] = this.enh_buf[n2] + (1.0f - ftmp1) * plc_pred[plc_blockl - 1 - i];
                    }
                }
                if (this.ULP_inst.mode != 20) break block14;
                for (iblock = 0; iblock < 2; ++iblock) {
                    this.enhancer(out, iblock * ilbc_constants.ENH_BLOCKL, this.enh_buf, ilbc_constants.ENH_BUFL, (5 + iblock) * ilbc_constants.ENH_BLOCKL + 40, ilbc_constants.ENH_ALPHA0, this.enh_period, ilbc_constants.enh_plocsTbl, ilbc_constants.ENH_NBLOCKS_TOT);
                }
                break block15;
            }
            if (this.ULP_inst.mode != 30) break block15;
            for (iblock = 0; iblock < 3; ++iblock) {
                this.enhancer(out, iblock * ilbc_constants.ENH_BLOCKL, this.enh_buf, ilbc_constants.ENH_BUFL, (4 + iblock) * ilbc_constants.ENH_BLOCKL, ilbc_constants.ENH_ALPHA0, this.enh_period, ilbc_constants.enh_plocsTbl, ilbc_constants.ENH_NBLOCKS_TOT);
            }
        }
        return lag * 2;
    }

    public void compCorr(float[] cc, float[] gc, float[] pm, float[] buffer, int lag, int bLen, int sRange) {
        if (bLen - sRange - lag < 0) {
            sRange = bLen - lag;
        }
        float ftmp1 = 0.0f;
        float ftmp2 = 0.0f;
        float ftmp3 = 0.0f;
        for (int i = 0; i < sRange; ++i) {
            ftmp1 += buffer[bLen - sRange + i] * buffer[bLen - sRange + i - lag];
            ftmp2 += buffer[bLen - sRange + i - lag] * buffer[bLen - sRange + i - lag];
            ftmp3 += buffer[bLen - sRange + i] * buffer[bLen - sRange + i];
        }
        if (ftmp2 > 0.0f) {
            cc[0] = ftmp1 * ftmp1 / ftmp2;
            gc[0] = Math.abs(ftmp1 / ftmp2);
            pm[0] = Math.abs(ftmp1) / ((float)Math.sqrt(ftmp2) * (float)Math.sqrt(ftmp3));
        } else {
            cc[0] = 0.0f;
            gc[0] = 0.0f;
            pm[0] = 0.0f;
        }
    }

    public void doThePLC(float[] PLCresidual, float[] PLClpc, int PLI, float[] decresidual, float[] lpc, int lpc_idx, int inlag) {
        int lag = 20;
        int randlag = 0;
        float gain = 0.0f;
        float maxcc = 0.0f;
        float use_gain = 0.0f;
        float gain_comp = 0.0f;
        float maxcc_comp = 0.0f;
        float per = 0.0f;
        float max_per = 0.0f;
        float[] randvec = new float[ilbc_constants.BLOCKL_MAX];
        float[] a_gain = new float[1];
        float[] a_comp = new float[1];
        float[] a_per = new float[1];
        if (PLI == 1) {
            int i;
            ++this.consPLICount;
            if (this.prevPLI != 1) {
                lag = inlag - 3;
                a_comp[0] = maxcc;
                a_gain[0] = gain;
                a_per[0] = max_per;
                this.compCorr(a_comp, a_gain, a_per, this.prevResidual, lag, this.ULP_inst.blockl, 60);
                maxcc = a_comp[0];
                gain = a_gain[0];
                max_per = a_per[0];
                for (i = inlag - 2; i <= inlag + 3; ++i) {
                    a_comp[0] = maxcc_comp;
                    a_gain[0] = gain_comp;
                    a_per[0] = per;
                    this.compCorr(a_comp, a_gain, a_per, this.prevResidual, i, this.ULP_inst.blockl, 60);
                    maxcc_comp = a_comp[0];
                    gain_comp = a_gain[0];
                    per = a_per[0];
                    if (!(maxcc_comp > maxcc)) continue;
                    maxcc = maxcc_comp;
                    gain = gain_comp;
                    lag = i;
                    max_per = per;
                }
            } else {
                lag = this.prevLag;
                max_per = this.per;
            }
            use_gain = 1.0f;
            if (this.consPLICount * this.ULP_inst.blockl > 320) {
                use_gain = 0.9f;
            } else if (this.consPLICount * this.ULP_inst.blockl > 640) {
                use_gain = 0.7f;
            } else if (this.consPLICount * this.ULP_inst.blockl > 960) {
                use_gain = 0.5f;
            } else if (this.consPLICount * this.ULP_inst.blockl > 1280) {
                use_gain = 0.0f;
            }
            float ftmp = (float)Math.sqrt(max_per);
            float pitchfact = ftmp > 0.7f ? 1.0f : (ftmp > 0.4f ? (ftmp - 0.4f) / 0.29999998f : 0.0f);
            int use_lag = lag;
            if (lag < 80) {
                use_lag = 2 * lag;
            }
            float energy = 0.0f;
            for (i = 0; i < this.ULP_inst.blockl; ++i) {
                this.seed = this.seed * 69069L + 1L & Integer.MAX_VALUE;
                randlag = 50 + (int)(this.seed % 70L);
                int pick = i - randlag;
                randvec[i] = pick < 0 ? this.prevResidual[this.ULP_inst.blockl + pick] : randvec[pick];
                pick = i - use_lag;
                PLCresidual[i] = pick < 0 ? this.prevResidual[this.ULP_inst.blockl + pick] : PLCresidual[pick];
                PLCresidual[i] = i < 80 ? use_gain * (pitchfact * PLCresidual[i] + (1.0f - pitchfact) * randvec[i]) : (i < 160 ? 0.95f * use_gain * (pitchfact * PLCresidual[i] + (1.0f - pitchfact) * randvec[i]) : 0.9f * use_gain * (pitchfact * PLCresidual[i] + (1.0f - pitchfact) * randvec[i]));
                energy += PLCresidual[i] * PLCresidual[i];
            }
            if ((float)Math.sqrt(energy / (float)this.ULP_inst.blockl) < 30.0f) {
                gain = 0.0f;
                for (i = 0; i < this.ULP_inst.blockl; ++i) {
                    PLCresidual[i] = randvec[i];
                }
            }
            System.arraycopy(this.prevLpc, 0, PLClpc, 0, ilbc_constants.LPC_FILTERORDER + 1);
        } else {
            System.arraycopy(decresidual, 0, PLCresidual, 0, this.ULP_inst.blockl);
            System.arraycopy(lpc, lpc_idx, PLClpc, 0, ilbc_constants.LPC_FILTERORDER + 1);
            this.consPLICount = 0;
        }
        if (PLI != 0) {
            this.prevLag = lag;
            this.per = max_per;
        }
        this.prevPLI = PLI;
        System.arraycopy(PLClpc, 0, this.prevLpc, 0, ilbc_constants.LPC_FILTERORDER + 1);
        System.arraycopy(PLCresidual, 0, this.prevResidual, 0, this.ULP_inst.blockl);
    }

    public short decode(short[] decoded_data, short[] encoded_data, short mode) {
        int k;
        float[] decblock = new float[ilbc_constants.BLOCKL_MAX];
        bitstream en_data = new bitstream(this.ULP_inst.no_of_bytes);
        if (mode < 0 || mode > 1) {
            System.out.println("\nERROR - Wrong mode - 0, 1 allowed\n");
        }
        for (k = 0; k < encoded_data.length; ++k) {
            en_data.buffer[2 * k + 1] = (char)(encoded_data[k] & 0xFF);
            en_data.buffer[2 * k] = (char)(encoded_data[k] >> 8 & 0xFF);
        }
        this.iLBC_decode(decblock, en_data, mode);
        for (k = 0; k < this.ULP_inst.blockl; ++k) {
            float dtmp = decblock[k];
            if (dtmp < (float)ilbc_constants.MIN_SAMPLE) {
                dtmp = ilbc_constants.MIN_SAMPLE;
            } else if (dtmp > (float)ilbc_constants.MAX_SAMPLE) {
                dtmp = ilbc_constants.MAX_SAMPLE;
            }
            decoded_data[k] = (short)dtmp;
        }
        return (short)this.ULP_inst.blockl;
    }

    public void Decode(float[] decresidual, int start, int idxForMax, int[] idxVec, float[] syntdenum, int[] cb_index, int[] gain_index, int[] extra_cb_index, int[] extra_gain_index, int state_first) {
        int Nback;
        int subframe;
        int meml_gotten;
        int k;
        int li;
        float[] reverseDecresidual = new float[ilbc_constants.BLOCKL_MAX];
        float[] mem = new float[ilbc_constants.CB_MEML];
        int diff = ilbc_constants.STATE_LEN - this.ULP_inst.state_short_len;
        int start_pos = state_first == 1 ? (start - 1) * ilbc_constants.SUBL : (start - 1) * ilbc_constants.SUBL + diff;
        ilbc_common.StateConstructW(idxForMax, idxVec, syntdenum, (start - 1) * (ilbc_constants.LPC_FILTERORDER + 1), decresidual, start_pos, this.ULP_inst.state_short_len);
        if (state_first != 0) {
            for (li = 0; li < ilbc_constants.CB_MEML - this.ULP_inst.state_short_len; ++li) {
                mem[li] = 0.0f;
            }
            System.arraycopy(decresidual, start_pos, mem, ilbc_constants.CB_MEML - this.ULP_inst.state_short_len, this.ULP_inst.state_short_len);
            ilbc_common.iCBConstruct(decresidual, start_pos + this.ULP_inst.state_short_len, extra_cb_index, 0, extra_gain_index, 0, mem, ilbc_constants.CB_MEML - ilbc_constants.stMemLTbl, ilbc_constants.stMemLTbl, diff, ilbc_constants.CB_NSTAGES);
        } else {
            for (k = 0; k < diff; ++k) {
                reverseDecresidual[k] = decresidual[(start + 1) * ilbc_constants.SUBL - 1 - (k + this.ULP_inst.state_short_len)];
            }
            meml_gotten = this.ULP_inst.state_short_len;
            for (k = 0; k < meml_gotten; ++k) {
                mem[ilbc_constants.CB_MEML - 1 - k] = decresidual[start_pos + k];
            }
            for (li = 0; li < ilbc_constants.CB_MEML - k; ++li) {
                mem[li] = 0.0f;
            }
            ilbc_common.iCBConstruct(reverseDecresidual, 0, extra_cb_index, 0, extra_gain_index, 0, mem, ilbc_constants.CB_MEML - ilbc_constants.stMemLTbl, ilbc_constants.stMemLTbl, diff, ilbc_constants.CB_NSTAGES);
            for (k = 0; k < diff; ++k) {
                decresidual[start_pos - 1 - k] = reverseDecresidual[k];
            }
        }
        int subcount = 0;
        int Nfor = this.ULP_inst.nsub - start - 1;
        if (Nfor > 0) {
            for (li = 0; li < ilbc_constants.CB_MEML - ilbc_constants.STATE_LEN; ++li) {
                mem[li] = 0.0f;
            }
            System.arraycopy(decresidual, (start - 1) * ilbc_constants.SUBL, mem, ilbc_constants.CB_MEML - ilbc_constants.STATE_LEN, ilbc_constants.STATE_LEN);
            for (subframe = 0; subframe < Nfor; ++subframe) {
                ilbc_common.iCBConstruct(decresidual, (start + 1 + subframe) * ilbc_constants.SUBL, cb_index, subcount * ilbc_constants.CB_NSTAGES, gain_index, subcount * ilbc_constants.CB_NSTAGES, mem, ilbc_constants.CB_MEML - ilbc_constants.memLfTbl[subcount], ilbc_constants.memLfTbl[subcount], ilbc_constants.SUBL, ilbc_constants.CB_NSTAGES);
                System.arraycopy(mem, ilbc_constants.SUBL, mem, 0, ilbc_constants.CB_MEML - ilbc_constants.SUBL);
                System.arraycopy(decresidual, (start + 1 + subframe) * ilbc_constants.SUBL, mem, ilbc_constants.CB_MEML - ilbc_constants.SUBL, ilbc_constants.SUBL);
                ++subcount;
            }
        }
        if ((Nback = start - 1) > 0) {
            meml_gotten = ilbc_constants.SUBL * (this.ULP_inst.nsub + 1 - start);
            if (meml_gotten > ilbc_constants.CB_MEML) {
                meml_gotten = ilbc_constants.CB_MEML;
            }
            for (k = 0; k < meml_gotten; ++k) {
                mem[ilbc_constants.CB_MEML - 1 - k] = decresidual[(start - 1) * ilbc_constants.SUBL + k];
            }
            for (li = 0; li < ilbc_constants.CB_MEML - k; ++li) {
                mem[li] = 0.0f;
            }
            for (subframe = 0; subframe < Nback; ++subframe) {
                ilbc_common.iCBConstruct(reverseDecresidual, subframe * ilbc_constants.SUBL, cb_index, subcount * ilbc_constants.CB_NSTAGES, gain_index, subcount * ilbc_constants.CB_NSTAGES, mem, ilbc_constants.CB_MEML - ilbc_constants.memLfTbl[subcount], ilbc_constants.memLfTbl[subcount], ilbc_constants.SUBL, ilbc_constants.CB_NSTAGES);
                System.arraycopy(mem, ilbc_constants.SUBL, mem, 0, ilbc_constants.CB_MEML - ilbc_constants.SUBL);
                System.arraycopy(reverseDecresidual, subframe * ilbc_constants.SUBL, mem, ilbc_constants.CB_MEML - ilbc_constants.SUBL, ilbc_constants.SUBL);
                ++subcount;
            }
            for (int i = 0; i < ilbc_constants.SUBL * Nback; ++i) {
                decresidual[ilbc_constants.SUBL * Nback - i - 1] = reverseDecresidual[i];
            }
        }
    }

    void iLBC_decode(float[] decblock, bitstream bytes, int mode) {
        int i;
        int start;
        float[] data = new float[ilbc_constants.BLOCKL_MAX];
        float[] lsfdeq = new float[ilbc_constants.LPC_FILTERORDER * ilbc_constants.LPC_N_MAX];
        float[] PLCresidual = new float[ilbc_constants.BLOCKL_MAX];
        float[] PLClpc = new float[ilbc_constants.LPC_FILTERORDER + 1];
        float[] zeros = new float[ilbc_constants.BLOCKL_MAX];
        float[] one = new float[ilbc_constants.LPC_FILTERORDER + 1];
        int[] idxVec = new int[ilbc_constants.STATE_LEN];
        int[] gain_index = new int[ilbc_constants.NASUB_MAX * ilbc_constants.CB_NSTAGES];
        int[] extra_gain_index = new int[ilbc_constants.CB_NSTAGES];
        int[] cb_index = new int[ilbc_constants.CB_NSTAGES * ilbc_constants.NASUB_MAX];
        int[] extra_cb_index = new int[ilbc_constants.CB_NSTAGES];
        int[] lsf_i = new int[ilbc_constants.LSF_NSPLIT * ilbc_constants.LPC_N_MAX];
        float[] weightdenum = new float[(ilbc_constants.LPC_FILTERORDER + 1) * ilbc_constants.NSUB_MAX];
        float[] syntdenum = new float[ilbc_constants.NSUB_MAX * (ilbc_constants.LPC_FILTERORDER + 1)];
        float[] decresidual = new float[ilbc_constants.BLOCKL_MAX];
        if (mode > 0) {
            int k;
            boolean pos = false;
            for (k = 0; k < ilbc_constants.LSF_NSPLIT * ilbc_constants.LPC_N_MAX; ++k) {
                lsf_i[k] = 0;
            }
            start = 0;
            int state_first = 0;
            int idxForMax = 0;
            for (k = 0; k < this.ULP_inst.state_short_len; ++k) {
                idxVec[k] = 0;
            }
            for (k = 0; k < ilbc_constants.CB_NSTAGES; ++k) {
                extra_cb_index[k] = 0;
            }
            for (k = 0; k < ilbc_constants.CB_NSTAGES; ++k) {
                extra_gain_index[k] = 0;
            }
            for (i = 0; i < this.ULP_inst.nasub; ++i) {
                for (k = 0; k < ilbc_constants.CB_NSTAGES; ++k) {
                    cb_index[i * ilbc_constants.CB_NSTAGES + k] = 0;
                }
            }
            for (i = 0; i < this.ULP_inst.nasub; ++i) {
                for (k = 0; k < ilbc_constants.CB_NSTAGES; ++k) {
                    gain_index[i * ilbc_constants.CB_NSTAGES + k] = 0;
                }
            }
            for (int ulp = 0; ulp < 3; ++ulp) {
                int lastpart;
                for (k = 0; k < ilbc_constants.LSF_NSPLIT * this.ULP_inst.lpc_n; ++k) {
                    lastpart = bytes.unpack(this.ULP_inst.lsf_bits[k][ulp]);
                    lsf_i[k] = bytes.packcombine(lsf_i[k], lastpart, this.ULP_inst.lsf_bits[k][ulp]);
                }
                lastpart = bytes.unpack(this.ULP_inst.start_bits[ulp]);
                start = bytes.packcombine(start, lastpart, this.ULP_inst.start_bits[ulp]);
                lastpart = bytes.unpack(this.ULP_inst.startfirst_bits[ulp]);
                state_first = bytes.packcombine(state_first, lastpart, this.ULP_inst.startfirst_bits[ulp]);
                lastpart = bytes.unpack(this.ULP_inst.scale_bits[ulp]);
                idxForMax = bytes.packcombine(idxForMax, lastpart, this.ULP_inst.scale_bits[ulp]);
                for (k = 0; k < this.ULP_inst.state_short_len; ++k) {
                    lastpart = bytes.unpack(this.ULP_inst.state_bits[ulp]);
                    idxVec[k] = bytes.packcombine(idxVec[k], lastpart, this.ULP_inst.state_bits[ulp]);
                }
                for (k = 0; k < ilbc_constants.CB_NSTAGES; ++k) {
                    lastpart = bytes.unpack(this.ULP_inst.extra_cb_index[k][ulp]);
                    extra_cb_index[k] = bytes.packcombine(extra_cb_index[k], lastpart, this.ULP_inst.extra_cb_index[k][ulp]);
                }
                for (k = 0; k < ilbc_constants.CB_NSTAGES; ++k) {
                    lastpart = bytes.unpack(this.ULP_inst.extra_cb_gain[k][ulp]);
                    extra_gain_index[k] = bytes.packcombine(extra_gain_index[k], lastpart, this.ULP_inst.extra_cb_gain[k][ulp]);
                }
                for (i = 0; i < this.ULP_inst.nasub; ++i) {
                    for (k = 0; k < ilbc_constants.CB_NSTAGES; ++k) {
                        lastpart = bytes.unpack(this.ULP_inst.cb_index[i][k][ulp]);
                        cb_index[i * ilbc_constants.CB_NSTAGES + k] = bytes.packcombine(cb_index[i * ilbc_constants.CB_NSTAGES + k], lastpart, this.ULP_inst.cb_index[i][k][ulp]);
                    }
                }
                for (i = 0; i < this.ULP_inst.nasub; ++i) {
                    for (k = 0; k < ilbc_constants.CB_NSTAGES; ++k) {
                        lastpart = bytes.unpack(this.ULP_inst.cb_gain[i][k][ulp]);
                        gain_index[i * ilbc_constants.CB_NSTAGES + k] = bytes.packcombine(gain_index[i * ilbc_constants.CB_NSTAGES + k], lastpart, this.ULP_inst.cb_gain[i][k][ulp]);
                    }
                }
            }
            int last_bit = bytes.unpack(1);
            if (start < 1) {
                mode = 0;
            }
            if (this.ULP_inst.mode == 20 && start > 3) {
                mode = 0;
            }
            if (this.ULP_inst.mode == 30 && start > 5) {
                mode = 0;
            }
            if (last_bit == 1) {
                mode = 0;
            }
            if (mode == 1) {
                this.index_conv_dec(cb_index);
                this.SimplelsfDEQ(lsfdeq, lsf_i, this.ULP_inst.lpc_n);
                int check = ilbc_common.LSF_check(lsfdeq, ilbc_constants.LPC_FILTERORDER, this.ULP_inst.lpc_n);
                this.DecoderInterpolateLSF(syntdenum, weightdenum, lsfdeq, ilbc_constants.LPC_FILTERORDER);
                this.Decode(decresidual, start, idxForMax, idxVec, syntdenum, cb_index, gain_index, extra_cb_index, extra_gain_index, state_first);
                this.doThePLC(PLCresidual, PLClpc, 0, decresidual, syntdenum, (ilbc_constants.LPC_FILTERORDER + 1) * (this.ULP_inst.nsub - 1), this.last_lag);
                System.arraycopy(PLCresidual, 0, decresidual, 0, this.ULP_inst.blockl);
            }
        }
        if (mode == 0) {
            int li;
            for (li = 0; li < ilbc_constants.BLOCKL_MAX; ++li) {
                zeros[li] = 0.0f;
            }
            one[0] = 1.0f;
            for (li = 0; li < ilbc_constants.LPC_FILTERORDER; ++li) {
                one[li + 1] = 0.0f;
            }
            start = 0;
            this.doThePLC(PLCresidual, PLClpc, 1, zeros, one, 0, this.last_lag);
            System.arraycopy(PLCresidual, 0, decresidual, 0, this.ULP_inst.blockl);
            int order_plus_one = ilbc_constants.LPC_FILTERORDER + 1;
            for (i = 0; i < this.ULP_inst.nsub; ++i) {
                System.arraycopy(PLClpc, 0, syntdenum, i * order_plus_one, order_plus_one);
            }
        }
        if (this.use_enhancer == 1) {
            this.last_lag = this.enhancerInterface(data, decresidual);
            if (this.ULP_inst.mode == 20) {
                i = 0;
                this.syntFilter(data, i * ilbc_constants.SUBL, this.old_syntdenum, (i + this.ULP_inst.nsub - 1) * (ilbc_constants.LPC_FILTERORDER + 1), ilbc_constants.SUBL, this.syntMem);
                for (i = 1; i < this.ULP_inst.nsub; ++i) {
                    this.syntFilter(data, i * ilbc_constants.SUBL, syntdenum, (i - 1) * (ilbc_constants.LPC_FILTERORDER + 1), ilbc_constants.SUBL, this.syntMem);
                }
            } else if (this.ULP_inst.mode == 30) {
                for (i = 0; i < 2; ++i) {
                    this.syntFilter(data, i * ilbc_constants.SUBL, this.old_syntdenum, (i + this.ULP_inst.nsub - 2) * (ilbc_constants.LPC_FILTERORDER + 1), ilbc_constants.SUBL, this.syntMem);
                }
                for (i = 2; i < this.ULP_inst.nsub; ++i) {
                    this.syntFilter(data, i * ilbc_constants.SUBL, syntdenum, (i - 2) * (ilbc_constants.LPC_FILTERORDER + 1), ilbc_constants.SUBL, this.syntMem);
                }
            }
        } else {
            int lag = 20;
            float maxcc = this.xCorrCoef(decresidual, ilbc_constants.BLOCKL_MAX - ilbc_constants.ENH_BLOCKL, decresidual, ilbc_constants.BLOCKL_MAX - ilbc_constants.ENH_BLOCKL - lag, ilbc_constants.ENH_BLOCKL);
            for (int ilag = 21; ilag < 120; ++ilag) {
                float cc = this.xCorrCoef(decresidual, ilbc_constants.BLOCKL_MAX - ilbc_constants.ENH_BLOCKL, decresidual, ilbc_constants.BLOCKL_MAX - ilbc_constants.ENH_BLOCKL - ilag, ilbc_constants.ENH_BLOCKL);
                if (!(cc > maxcc)) continue;
                maxcc = cc;
                lag = ilag;
            }
            this.last_lag = lag;
            System.arraycopy(decresidual, 0, data, 0, this.ULP_inst.blockl);
            for (i = 0; i < this.ULP_inst.nsub; ++i) {
                this.syntFilter(data, i * ilbc_constants.SUBL, syntdenum, i * (ilbc_constants.LPC_FILTERORDER + 1), ilbc_constants.SUBL, this.syntMem);
            }
        }
        this.hpOutput(data, this.ULP_inst.blockl, decblock, this.hpomem);
        System.arraycopy(syntdenum, 0, this.old_syntdenum, 0, this.ULP_inst.nsub * (ilbc_constants.LPC_FILTERORDER + 1));
        this.prev_enh_pl = 0;
        if (mode == 0) {
            this.prev_enh_pl = 1;
        }
    }

    public ilbc_decoder(int init_mode, int init_enhancer) {
        int li;
        this.ULP_inst = new ilbc_ulp(init_mode);
        this.syntMem = new float[ilbc_constants.LPC_FILTERORDER];
        this.prevLpc = new float[ilbc_constants.LPC_FILTERORDER + 1];
        this.prevResidual = new float[ilbc_constants.NSUB_MAX * ilbc_constants.SUBL];
        this.old_syntdenum = new float[(ilbc_constants.LPC_FILTERORDER + 1) * ilbc_constants.NSUB_MAX];
        this.hpomem = new float[4];
        this.enh_buf = new float[ilbc_constants.ENH_BUFL];
        this.enh_period = new float[ilbc_constants.ENH_NBLOCKS_TOT];
        this.lsfdeqold = new float[ilbc_constants.LPC_FILTERORDER];
        for (li = 0; li < this.syntMem.length; ++li) {
            this.syntMem[li] = 0.0f;
        }
        System.arraycopy(ilbc_constants.lsfmeanTbl, 0, this.lsfdeqold, 0, ilbc_constants.LPC_FILTERORDER);
        for (li = 0; li < this.old_syntdenum.length; ++li) {
            this.old_syntdenum[li] = 0.0f;
        }
        for (li = 0; li < ilbc_constants.NSUB_MAX; ++li) {
            this.old_syntdenum[li * (ilbc_constants.LPC_FILTERORDER + 1)] = 1.0f;
        }
        this.last_lag = 20;
        this.prevLag = 120;
        this.per = 0.0f;
        this.consPLICount = 0;
        this.prevPLI = 0;
        this.prevLpc[0] = 1.0f;
        for (li = 1; li < this.prevLpc.length; ++li) {
            this.prevLpc[li] = 0.0f;
        }
        for (li = 0; li < this.prevResidual.length; ++li) {
            this.prevResidual[li] = 0.0f;
        }
        this.seed = 777L;
        for (li = 0; li < this.hpomem.length; ++li) {
            this.hpomem[li] = 0.0f;
        }
        this.use_enhancer = init_enhancer;
        for (li = 0; li < this.enh_buf.length; ++li) {
            this.enh_buf[li] = 0.0f;
        }
        for (li = 0; li < ilbc_constants.ENH_NBLOCKS_TOT; ++li) {
            this.enh_period[li] = 40.0f;
        }
        this.prev_enh_pl = 0;
    }
}

