/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controlpanel;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.StartEvent;
import javax.media.StopEvent;
import javax.swing.SwingUtilities;
import net.sf.fmj.ejmf.toolkit.gui.controls.AbstractListenerControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.Skin;

abstract class AbstractControls
implements ControllerListener {
    private Player player;
    private Hashtable controlTable = new Hashtable();
    private final Skin skin;

    private AbstractControls(Skin skin) {
        this.skin = skin;
    }

    protected AbstractControls(Skin skin, Player player) {
        this.skin = skin;
        if (player.getState() < 300) {
            throw new NotRealizedError("Player must be realized");
        }
        this.player = player;
        this.makeControls(skin);
        this.setControlsPlayer(player);
        player.addControllerListener(this);
        this.setControlComponentState(player.getState());
    }

    public AbstractListenerControl getControl(String name) {
        return (AbstractListenerControl)this.controlTable.get(name);
    }

    public AbstractListenerControl[] getControls() {
        Vector v = new Vector();
        Enumeration elements = this.controlTable.elements();
        while (elements.hasMoreElements()) {
            v.addElement(elements.nextElement());
        }
        Object[] controls = new AbstractListenerControl[v.size()];
        v.copyInto(controls);
        return controls;
    }

    private void setControlsPlayer(Player player) {
        Player c = player;
        Enumeration e = this.controlTable.elements();
        while (e.hasMoreElements()) {
            AbstractListenerControl alc = (AbstractListenerControl)e.nextElement();
            alc.setController(c);
        }
    }

    protected void addControl(String name, AbstractListenerControl alc) {
        this.controlTable.put(name, alc);
    }

    public Player getPlayer() {
        return this.player;
    }

    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof StartEvent) {
            SwingUtilities.invokeLater(new ControllerEventThread(600));
        } else if (event instanceof StopEvent || event instanceof ControllerErrorEvent) {
            SwingUtilities.invokeLater(new ControllerEventThread(500));
        }
    }

    protected abstract void makeControls(Skin var1);

    protected abstract void setControlComponentState(int var1);

    class ControllerEventThread
    implements Runnable {
        private int state;

        public ControllerEventThread(int state) {
            this.state = state;
        }

        public void run() {
            AbstractControls.this.setControlComponentState(this.state);
        }
    }
}

