/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controls;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class BasicIconButton
extends JButton
implements SwingConstants {
    private final ImageIcon icon;
    private final ImageIcon disabledIcon;
    private final Dimension size;

    public BasicIconButton(ImageIcon icon, ImageIcon disabledIcon) {
        this.icon = icon;
        this.disabledIcon = disabledIcon;
        this.size = new Dimension(icon.getIconWidth(), icon.getIconHeight());
    }

    public void paint(Graphics g) {
        boolean isPressed = this.getModel().isPressed();
        boolean isEnabled = this.isEnabled();
        g.setColor(UIManager.getColor("control"));
        g.fillRect(0, 0, this.size.width, this.size.height);
        if (isEnabled) {
            g.drawImage(this.icon.getImage(), 0, 0, this.size.width, this.size.height, null);
        } else {
            g.drawImage(this.disabledIcon.getImage(), 0, 0, this.size.width, this.size.height, null);
        }
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public Dimension getMinimumSize() {
        return this.size;
    }

    public boolean isFocusTraversable() {
        return false;
    }
}

