/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.util;

import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Player;
import javax.media.Processor;
import javax.media.StopEvent;
import javax.media.Time;
import javax.media.TransitionEvent;

public class StateWaiter
implements ControllerListener {
    private int state;
    private boolean stateReached = false;
    private boolean listening = false;
    private Controller controller;

    public StateWaiter(Controller controller) {
        this.controller = controller;
    }

    private void setState(int state) {
        this.state = state;
        this.stateReached = false;
        this.addAsListener();
    }

    private void addAsListener() {
        if (!this.listening) {
            this.controller.addControllerListener(this);
            this.listening = true;
        }
    }

    private void removeAsListener() {
        this.controller.removeControllerListener(this);
        this.listening = false;
    }

    public synchronized void controllerUpdate(ControllerEvent event) {
        if (event.getSourceController() != this.controller) {
            return;
        }
        if (event instanceof TransitionEvent) {
            int currState = ((TransitionEvent)event).getCurrentState();
            boolean bl = this.stateReached = currState >= this.state;
        }
        if (event instanceof StopEvent || event instanceof ControllerClosedEvent || this.stateReached) {
            this.removeAsListener();
            this.notifyAll();
        }
    }

    public boolean blockingRealize() {
        this.setState(300);
        this.controller.realize();
        return this.waitForState();
    }

    public boolean blockingPrefetch() {
        this.setState(500);
        this.controller.prefetch();
        return this.waitForState();
    }

    public boolean blockingStart() {
        this.setState(600);
        Player player = (Player)this.controller;
        player.start();
        return this.waitForState();
    }

    public boolean blockingSyncStart(Time t) {
        this.setState(600);
        this.controller.syncStart(t);
        return this.waitForState();
    }

    public boolean blockingConfigure() {
        this.setState(180);
        ((Processor)this.controller).configure();
        return this.waitForState();
    }

    public boolean blockingWait(int state) {
        this.setState(state);
        return this.waitForState();
    }

    private synchronized boolean waitForState() {
        while (this.listening) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.stateReached;
    }
}

