/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import java.util.logging.Logger;
import net.sf.fmj.filtergraph.Link;
import net.sf.fmj.filtergraph.Node;
import net.sf.fmj.utility.LoggerSingleton;

class FilterGraphPrinter {
    private static final Logger logger = LoggerSingleton.logger;

    FilterGraphPrinter() {
    }

    private static String tabs(int i) {
        StringBuffer b = new StringBuffer();
        while (i-- > 0) {
            b.append('\t');
        }
        return b.toString();
    }

    public static void print(Node n, int tabs) {
        String trackStr = "";
        n.print(logger, FilterGraphPrinter.tabs(tabs) + trackStr);
        for (int j = 0; j < n.getNumDestLinks(); ++j) {
            Link linkChild = n.getDestLink(j);
            if (linkChild == null) continue;
            FilterGraphPrinter.print(linkChild, tabs + 1);
        }
    }

    public static void print(Link link, int tabs) {
        Node n = link.getDestNode();
        String trackStr = "";
        if (link.getDestPin() != null && link.getDestPin().getTrack() >= 0) {
            trackStr = "[Track " + link.getDestPin().getTrack() + " of] ";
        }
        n.print(logger, FilterGraphPrinter.tabs(tabs) + trackStr);
        for (int j = 0; j < n.getNumDestLinks(); ++j) {
            Link linkChild = n.getDestLink(j);
            if (linkChild == null) continue;
            FilterGraphPrinter.print(linkChild, tabs + 1);
        }
    }
}

