/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import java.io.IOException;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.ResourceUnavailableException;
import net.sf.fmj.filtergraph.DemuxNode;
import net.sf.fmj.filtergraph.Link;
import net.sf.fmj.filtergraph.Node;
import net.sf.fmj.utility.LoggerSingleton;

final class FilterGraphProcessor {
    private static final Logger logger = LoggerSingleton.logger;
    private static final boolean TRACE = true;
    public static final int PROCESS_DEFAULT = 0;
    public static final int SUPPRESS_TRACK_READ = 1;

    private FilterGraphProcessor() {
    }

    public static Node getTail(Node n) {
        if (n == null) {
            return n;
        }
        while (n.getNumDestLinks() > 0) {
            n = n.getDestLink(0).getDestNode();
        }
        return n;
    }

    public static Node getBeforeTail(Node n) {
        while (n.getNumDestLinks() > 0 && n.getDestLink(0).getDestNode().getNumDestLinks() > 0) {
            n = n.getDestLink(0).getDestNode();
        }
        return n;
    }

    public static void start(Node n) throws IOException {
        n.start();
        for (int i = 0; i < n.getNumDestLinks(); ++i) {
            Link destLink = n.getDestLink(i);
            if (destLink == null) continue;
            FilterGraphProcessor.start(destLink.getDestNode());
        }
    }

    public static void stop(Node n) throws IOException {
        n.stop();
        for (int i = 0; i < n.getNumDestLinks(); ++i) {
            Link destLink = n.getDestLink(i);
            if (destLink == null) continue;
            FilterGraphProcessor.stop(destLink.getDestNode());
        }
    }

    public static void open(Node n) throws ResourceUnavailableException {
        n.open();
        for (int i = 0; i < n.getNumDestLinks(); ++i) {
            Link destLink = n.getDestLink(i);
            if (destLink == null) continue;
            FilterGraphProcessor.open(destLink.getDestNode());
        }
    }

    public static void close(Node n) throws ResourceUnavailableException {
        n.close();
        for (int i = 0; i < n.getNumDestLinks(); ++i) {
            Link destLink = n.getDestLink(i);
            if (destLink == null) continue;
            FilterGraphProcessor.close(destLink.getDestNode());
        }
    }

    public static int process(Node n, Buffer input, int sourceTrackNumber, int destTrackNumber, int flags) {
        int result = 0;
        do {
            if ((result = n.process(input, sourceTrackNumber, destTrackNumber, flags)) != 0 && result != 2) {
                if (result == 1) {
                    logger.warning("BUFFER_PROCESSED_FAILED: " + n.getPlugIn());
                }
                return result;
            }
            for (int i = 0; i < n.getNumDestLinks(); ++i) {
                Link linkDest;
                if (n instanceof DemuxNode && sourceTrackNumber >= 0 && i != sourceTrackNumber || (linkDest = n.getDestLink(i)) == null) continue;
                if (n.getOutputBuffer(i) == null) {
                    throw new NullPointerException("Buffer " + i + " is null, trackNumber=" + sourceTrackNumber + ", flags=" + flags);
                }
                Buffer b = n.getOutputBuffer(i);
                if (b.isDiscard() || FilterGraphProcessor.process(linkDest.getDestNode(), b, -1, linkDest.getDestPin().getTrack(), flags) != 1) continue;
                return 1;
            }
        } while (result == 2);
        return result;
    }
}

