/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import javax.media.Buffer;
import javax.media.Clock;
import javax.media.Format;
import javax.media.Prefetchable;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import net.sf.fmj.filtergraph.InputPin;
import net.sf.fmj.filtergraph.Link;
import net.sf.fmj.filtergraph.Node;
import net.sf.fmj.filtergraph.OutputPin;
import net.sf.fmj.media.SleepHelper;

public class RendererNode
extends Node {
    private final Renderer renderer;
    private boolean prefetched;
    private final SleepHelper sleepHelper = new SleepHelper();

    public RendererNode(Renderer renderer, Format inputFormat) {
        super(renderer, 1, 0);
        this.setInputPin(0, new InputPin(this));
        this.renderer = renderer;
        this.getInputPin(0).setFormat(inputFormat);
    }

    public int getPlugInType() {
        return 4;
    }

    Format setPlugInInputFormat(InputPin pin, Format format) {
        return this.renderer.setInputFormat(format);
    }

    Format setPlugInOutputFormat(OutputPin pin, Format format) {
        throw new UnsupportedOperationException();
    }

    public Node duplicate() {
        return this.propagateDuplicate(new RendererNode(this.getRenderer(), this.getInputFormat()));
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public Format getInputFormat() {
        return this.getInputPin(0).getFormat();
    }

    public void setPrefetched(boolean prefetched) {
        this.prefetched = prefetched;
    }

    public boolean isPrefetched() {
        return this.prefetched;
    }

    public void open() throws ResourceUnavailableException {
        super.open();
        this.sleepHelper.reset();
    }

    public void stop() {
        this.getRenderer().stop();
        this.sleepHelper.reset();
    }

    public void start() {
        this.sleepHelper.reset();
        this.getRenderer().start();
    }

    public int process(Buffer input, int sourceTrackNumber, int destTrackNumber, int flags) {
        int processResult;
        Renderer renderer = this.getRenderer();
        if (input.getFormat() == null) {
            input.setFormat(this.getInputFormat());
        }
        if (renderer instanceof Prefetchable) {
            Prefetchable rendererAsPrefetchable = (Prefetchable)((Object)renderer);
            if (!this.isPrefetched() && rendererAsPrefetchable.isPrefetched()) {
                if (renderer instanceof Clock) {
                    Clock rendererAsClock = (Clock)((Object)renderer);
                    rendererAsClock.syncStart(new Time(rendererAsClock.getMediaNanoseconds()));
                }
                this.setPrefetched(true);
            }
        }
        do {
            int oldOffset = input.getOffset();
            processResult = renderer.process(input);
            if (processResult == 2) {
                logger.fine("processResult == Renderer.INPUT_BUFFER_NOT_CONSUMED");
                logger.fine("oldOffset = " + oldOffset);
                logger.fine("newoffset = " + input.getOffset());
                break;
            }
            if (processResult == 0) continue;
            logger.warning("Renderer process result (loop): " + processResult);
        } while (processResult == 2);
        if (processResult != 0) {
            logger.warning("Renderer process result: " + processResult);
            return processResult;
        }
        return 0;
    }

    public void addDestLink(Link n) {
        throw new UnsupportedOperationException();
    }
}

