/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import com.lti.utils.synchronization.ProducerConsumerQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import net.sf.fmj.utility.LoggerSingleton;

public class BufferQueueInputStream
extends InputStream {
    private static final Logger logger = LoggerSingleton.logger;
    private final ProducerConsumerQueue q;
    private static final int DEFAULT_QUEUE_SIZE = 20;
    private boolean trace = false;
    private Buffer buffer;
    private int available = 0;

    public BufferQueueInputStream() {
        this(20);
    }

    public BufferQueueInputStream(int qSize) {
        this.q = new ProducerConsumerQueue(qSize);
    }

    public BufferQueueInputStream(ProducerConsumerQueue q) {
        this.q = q;
    }

    public void setTrace(boolean value) {
        this.trace = value;
    }

    public boolean put(Buffer b) {
        return this.put(b, true);
    }

    public void blockingPut(Buffer b) {
        this.blockingPut(b, true);
    }

    public boolean put(Buffer b, boolean clone) {
        return this.put(b, false, clone);
    }

    public void blockingPut(Buffer b, boolean clone) {
        this.put(b, true, clone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean put(Buffer b, boolean block, boolean clone) {
        if (b.getLength() == -1) {
            throw new IllegalArgumentException();
        }
        if (!(b.getData() instanceof byte[])) {
            throw new IllegalArgumentException("Expected byte array: " + b.getData());
        }
        if (b.isEOM()) {
            logger.fine("putting EOM buffer");
        } else {
            if (b.getLength() == 0) {
                if (this.trace) {
                    logger.fine("Skipping zero length buffer, not adding to queue");
                }
                return true;
            }
            if (b.isDiscard()) {
                if (this.trace) {
                    logger.fine("Skipping discard buffer, not adding to queue");
                }
                return true;
            }
        }
        if (this.trace) {
            logger.fine(this + " BufferQueueInputStream.put: Putting buffer, length=" + b.getLength() + " eom=" + b.isEOM());
        }
        try {
            ProducerConsumerQueue producerConsumerQueue = this.q;
            synchronized (producerConsumerQueue) {
                if (!block && this.q.isFull()) {
                    return false;
                }
                this.available += b.getLength();
                this.q.put(clone ? (Buffer)b.clone() : b);
                if (this.trace) {
                    logger.fine(this + " put: available=" + this.available);
                }
                return true;
            }
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillBuffer() throws IOException {
        try {
            ProducerConsumerQueue producerConsumerQueue = this.q;
            synchronized (producerConsumerQueue) {
                do {
                    if (this.buffer != null) {
                        if (this.buffer.isEOM()) {
                            return;
                        }
                        if (this.buffer.getLength() > 0) {
                            return;
                        }
                    }
                    this.buffer = (Buffer)this.q.get();
                    if (this.trace) {
                        logger.fine(this + " Getting buffer: " + this.buffer.getLength());
                    }
                    if (this.buffer.getLength() != 0 || this.buffer.isDiscard() || !this.trace) continue;
                    logger.fine("Skipping zero-length buffer in queue");
                } while (this.buffer.isDiscard() || this.buffer.getLength() == 0);
            }
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new InterruptedIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        ProducerConsumerQueue producerConsumerQueue = this.q;
        synchronized (producerConsumerQueue) {
            if (this.trace) {
                logger.fine(this + " available: available=" + this.available);
            }
            return this.available;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        this.fillBuffer();
        if (this.buffer.getLength() <= 0 && this.buffer.isEOM()) {
            if (this.trace) {
                logger.fine(this + " BufferQueueInputStream.read: returning -1");
            }
            return -1;
        }
        byte[] data = (byte[])this.buffer.getData();
        int result = data[this.buffer.getOffset()] & 0xFF;
        this.buffer.setOffset(this.buffer.getOffset() + 1);
        this.buffer.setLength(this.buffer.getLength() - 1);
        ProducerConsumerQueue producerConsumerQueue = this.q;
        synchronized (producerConsumerQueue) {
            --this.available;
            if (this.trace) {
                logger.fine(this + " read: available=" + this.available);
            }
        }
        if (this.trace) {
            logger.fine(this + " BufferQueueInputStream.read: returning " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        int lengthToCopy;
        this.fillBuffer();
        if (this.buffer.getLength() <= 0 && this.buffer.isEOM()) {
            if (this.trace) {
                logger.fine(this + " BufferQueueInputStream.read: returning -1");
            }
            return -1;
        }
        byte[] data = (byte[])this.buffer.getData();
        if (data == null) {
            throw new NullPointerException("Buffer has null data.  length=" + this.buffer.getLength() + " offset=" + this.buffer.getOffset());
        }
        int n = lengthToCopy = this.buffer.getLength() < len ? this.buffer.getLength() : len;
        if (this.trace) {
            logger.fine(this + " BufferQueueInputStream.read: lengthToCopy=" + lengthToCopy + " buffer.getLength()=" + this.buffer.getLength() + " buffer.getOffset()=" + this.buffer.getOffset() + " b.length=" + b.length + " len=" + len + " off=" + off);
        }
        System.arraycopy(data, this.buffer.getOffset(), b, off, lengthToCopy);
        this.buffer.setOffset(this.buffer.getOffset() + lengthToCopy);
        this.buffer.setLength(this.buffer.getLength() - lengthToCopy);
        ProducerConsumerQueue producerConsumerQueue = this.q;
        synchronized (producerConsumerQueue) {
            this.available -= lengthToCopy;
            if (this.trace) {
                logger.fine(this + " read: available=" + this.available);
            }
        }
        if (this.trace) {
            logger.fine(this + " BufferQueueInputStream.read[]: returning " + lengthToCopy);
        }
        return lengthToCopy;
    }
}

