/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import com.lti.utils.synchronization.ProducerConsumerQueue;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.SourceCloneable;
import net.sf.fmj.media.BufferQueueInputStream;
import net.sf.fmj.utility.LoggerSingleton;

public class CloneablePullDataSource
extends PullDataSource
implements SourceCloneable {
    private static final Logger logger = LoggerSingleton.logger;
    private final PullDataSource source;
    private PullSourceStream[] streams;
    private final ClonedDataSource firstClonedDataSource;
    private List<ClonedDataSource> clones = new ArrayList<ClonedDataSource>();
    private boolean sourceConnected = false;
    private boolean sourceStarted = false;

    public CloneablePullDataSource(PullDataSource source) {
        this.source = source;
        this.firstClonedDataSource = (ClonedDataSource)this.createClone();
    }

    public PullSourceStream[] getStreams() {
        return this.firstClonedDataSource.getStreams();
    }

    public void connect() throws IOException {
        this.firstClonedDataSource.connect();
    }

    public void disconnect() {
        this.firstClonedDataSource.disconnect();
    }

    public String getContentType() {
        return this.firstClonedDataSource.getContentType();
    }

    public Object getControl(String controlType) {
        return this.firstClonedDataSource.getControl(controlType);
    }

    public Object[] getControls() {
        return this.firstClonedDataSource.getControls();
    }

    public Time getDuration() {
        return this.firstClonedDataSource.getDuration();
    }

    public void start() throws IOException {
        this.firstClonedDataSource.start();
    }

    public void stop() throws IOException {
        this.firstClonedDataSource.stop();
    }

    public synchronized DataSource createClone() {
        ClonedDataSource result = new ClonedDataSource();
        this.clones.add(result);
        return result;
    }

    static /* synthetic */ PullSourceStream[] access$102(CloneablePullDataSource x0, PullSourceStream[] x1) {
        x0.streams = x1;
        return x1;
    }

    private class ClonedDataSource
    extends PullDataSource {
        private ClonedPullSourceStream[] clonedStreams;
        private boolean cloneConnected;
        private boolean cloneStarted;
        private static final int READ_BUFFER_SIZE = 2000;

        private ClonedDataSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PullSourceStream[] getStreams() {
            CloneablePullDataSource cloneablePullDataSource = CloneablePullDataSource.this;
            synchronized (cloneablePullDataSource) {
                if (this.clonedStreams == null) {
                    this.clonedStreams = new ClonedPullSourceStream[CloneablePullDataSource.this.streams.length];
                    for (int i = 0; i < CloneablePullDataSource.this.streams.length; ++i) {
                        this.clonedStreams[i] = new ClonedPullSourceStream(i, CloneablePullDataSource.this.streams[i]);
                    }
                }
                return this.clonedStreams;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connect() throws IOException {
            CloneablePullDataSource cloneablePullDataSource = CloneablePullDataSource.this;
            synchronized (cloneablePullDataSource) {
                if (this.cloneConnected) {
                    return;
                }
                if (!CloneablePullDataSource.this.sourceConnected) {
                    CloneablePullDataSource.this.source.connect();
                    CloneablePullDataSource.this.sourceConnected = true;
                }
                this.cloneConnected = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect() {
            CloneablePullDataSource cloneablePullDataSource = CloneablePullDataSource.this;
            synchronized (cloneablePullDataSource) {
                if (!this.cloneConnected) {
                    return;
                }
                this.cloneConnected = false;
                if (CloneablePullDataSource.this.sourceConnected) {
                    for (ClonedDataSource clone : CloneablePullDataSource.this.clones) {
                        if (!clone.cloneConnected) continue;
                        return;
                    }
                    CloneablePullDataSource.this.source.disconnect();
                    CloneablePullDataSource.this.sourceConnected = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getContentType() {
            CloneablePullDataSource cloneablePullDataSource = CloneablePullDataSource.this;
            synchronized (cloneablePullDataSource) {
                return CloneablePullDataSource.this.source.getContentType();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getControl(String controlType) {
            CloneablePullDataSource cloneablePullDataSource = CloneablePullDataSource.this;
            synchronized (cloneablePullDataSource) {
                return CloneablePullDataSource.this.source.getControl(controlType);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getControls() {
            CloneablePullDataSource cloneablePullDataSource = CloneablePullDataSource.this;
            synchronized (cloneablePullDataSource) {
                return CloneablePullDataSource.this.source.getControls();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Time getDuration() {
            CloneablePullDataSource cloneablePullDataSource = CloneablePullDataSource.this;
            synchronized (cloneablePullDataSource) {
                return CloneablePullDataSource.this.source.getDuration();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() throws IOException {
            CloneablePullDataSource cloneablePullDataSource = CloneablePullDataSource.this;
            synchronized (cloneablePullDataSource) {
                if (this.cloneStarted) {
                    return;
                }
                if (!CloneablePullDataSource.this.sourceStarted) {
                    CloneablePullDataSource.access$102(CloneablePullDataSource.this, CloneablePullDataSource.this.source.getStreams());
                    CloneablePullDataSource.this.source.start();
                    CloneablePullDataSource.this.sourceStarted = true;
                }
                this.cloneStarted = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() throws IOException {
            CloneablePullDataSource cloneablePullDataSource = CloneablePullDataSource.this;
            synchronized (cloneablePullDataSource) {
                if (!this.cloneStarted) {
                    return;
                }
                this.cloneStarted = false;
                if (CloneablePullDataSource.this.sourceStarted) {
                    for (ClonedDataSource clone : CloneablePullDataSource.this.clones) {
                        if (!clone.cloneStarted) continue;
                        return;
                    }
                    CloneablePullDataSource.this.source.stop();
                    CloneablePullDataSource.this.sourceStarted = false;
                }
            }
        }

        class ClonedPullSourceStream
        implements PullSourceStream {
            private final int streamIndex;
            private final PullSourceStream stream;
            private final ProducerConsumerQueue bufferQueue = new ProducerConsumerQueue();
            private final BufferQueueInputStream bufferQueueInputStream = new BufferQueueInputStream(this.bufferQueue);
            private boolean eos = false;

            public ClonedPullSourceStream(int streamIndex, PullSourceStream stream) {
                this.streamIndex = streamIndex;
                this.stream = stream;
            }

            ProducerConsumerQueue getBufferQueue() {
                return this.bufferQueue;
            }

            public boolean endOfStream() {
                return this.eos;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ContentDescriptor getContentDescriptor() {
                CloneablePullDataSource cloneablePullDataSource = CloneablePullDataSource.this;
                synchronized (cloneablePullDataSource) {
                    return this.stream.getContentDescriptor();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long getContentLength() {
                CloneablePullDataSource cloneablePullDataSource = CloneablePullDataSource.this;
                synchronized (cloneablePullDataSource) {
                    return this.stream.getContentLength();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getControl(String controlType) {
                CloneablePullDataSource cloneablePullDataSource = CloneablePullDataSource.this;
                synchronized (cloneablePullDataSource) {
                    return this.stream.getControl(controlType);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object[] getControls() {
                CloneablePullDataSource cloneablePullDataSource = CloneablePullDataSource.this;
                synchronized (cloneablePullDataSource) {
                    return this.stream.getControls();
                }
            }

            public boolean willReadBlock() {
                return this.bufferQueue.isEmpty();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(byte[] buffer, int offset, int length) throws IOException {
                CloneablePullDataSource cloneablePullDataSource = CloneablePullDataSource.this;
                synchronized (cloneablePullDataSource) {
                    if (this.bufferQueue.isEmpty()) {
                        Buffer originalBuffer = new Buffer();
                        byte[] originalBufferData = new byte[2000];
                        originalBuffer.setData(originalBufferData);
                        int numRead = this.stream.read(originalBufferData, 0, originalBufferData.length);
                        if (numRead < 0) {
                            originalBuffer.setEOM(true);
                        } else {
                            originalBuffer.setLength(numRead);
                        }
                        try {
                            for (ClonedDataSource clone : CloneablePullDataSource.this.clones) {
                                ClonedPullSourceStream clonedStream = (ClonedPullSourceStream)clone.getStreams()[this.streamIndex];
                                clonedStream.getBufferQueue().put((Buffer)originalBuffer.clone());
                            }
                        }
                        catch (InterruptedException e) {
                            logger.log(Level.WARNING, "" + e, e);
                            throw new InterruptedIOException();
                        }
                    }
                }
                return this.bufferQueueInputStream.read(buffer, offset, length);
            }
        }
    }
}

