/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import net.sf.fmj.media.AbstractMultiplexer;
import net.sf.fmj.media.multiplexer.BigPipedInputStream;
import net.sf.fmj.media.multiplexer.InputStreamPushDataSource;
import net.sf.fmj.utility.LoggerSingleton;

public abstract class AbstractInputStreamMux
extends AbstractMultiplexer {
    private static final Logger logger = LoggerSingleton.logger;
    private PipedInputStream pipedInputStream;
    private PipedOutputStream pipedOutputStream;
    private InputStreamPushDataSource dataOutput;
    private final ContentDescriptor contentDescriptor;
    private static final int PIPE_SIZE = 200000;

    public AbstractInputStreamMux(ContentDescriptor contentDescriptor) {
        this.contentDescriptor = contentDescriptor;
    }

    protected OutputStream getOutputStream() {
        return this.pipedOutputStream;
    }

    protected InputStreamPushDataSource getDataOutputNoInit() {
        return this.dataOutput;
    }

    public DataSource getDataOutput() {
        if (this.dataOutput == null) {
            this.dataOutput = this.createInputStreamPushDataSource(this.outputContentDescriptor, 1, new InputStream[]{this.pipedInputStream});
        }
        logger.finer(this.getClass().getSimpleName() + " getDataOutput");
        return this.dataOutput;
    }

    public abstract Format[] getSupportedInputFormats();

    public void close() {
        logger.finer(this.getClass().getSimpleName() + " close");
        super.close();
        if (this.dataOutput != null) {
            try {
                this.dataOutput.stop();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
            }
            this.dataOutput.disconnect();
        }
    }

    public void open() throws ResourceUnavailableException {
        logger.finer(this.getClass().getSimpleName() + " open");
        super.open();
    }

    public ContentDescriptor[] getSupportedOutputContentDescriptors(Format[] inputs) {
        return new ContentDescriptor[]{this.contentDescriptor};
    }

    public int process(Buffer buffer, int trackID) {
        logger.finer(this.getClass().getSimpleName() + " process " + buffer + " " + trackID + " length " + buffer.getLength());
        try {
            this.doProcess(buffer, trackID, this.pipedOutputStream);
        }
        catch (IOException e1) {
            logger.log(Level.SEVERE, "" + e1, e1);
            return 1;
        }
        if (this.dataOutput != null) {
            this.dataOutput.notifyDataAvailable(0);
        }
        return 0;
    }

    protected void doProcess(Buffer buffer, int trackID, OutputStream os) throws IOException {
        if (buffer.isEOM()) {
            os.close();
            return;
        }
        os.write((byte[])buffer.getData(), buffer.getOffset(), buffer.getLength());
    }

    public int setNumTracks(int numTracks) {
        numTracks = super.setNumTracks(numTracks);
        try {
            this.pipedInputStream = new BigPipedInputStream(200000);
            this.pipedOutputStream = new PipedOutputStream(this.pipedInputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return numTracks;
    }

    protected InputStreamPushDataSource createInputStreamPushDataSource(ContentDescriptor outputContentDescriptor, int numTracks, InputStream[] inputStreams) {
        return new InputStreamPushDataSource(outputContentDescriptor, numTracks, inputStreams);
    }

    protected void writeInt(OutputStream os, long value) throws IOException {
        byte[] aBuffer = new byte[]{(byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value & 0xFFL)};
        os.write(aBuffer, 0, aBuffer.length);
    }
}

