/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.fmj.ui.objeditor.ComponentValidationException;
import net.sf.fmj.ui.objeditor.ComponentValidator;
import net.sf.fmj.ui.objeditor.ObjEditor;
import net.sf.fmj.ui.objeditor.ObjEditorOKCancelDialog;
import net.sf.fmj.ui.utils.ErrorDialog;

public class RTPReceivePanel
extends JPanel
implements ObjEditor {
    private String url;
    private JComboBox comboTTL;
    private JLabel labelAddress;
    private JLabel labelPort;
    private JLabel labelTTL;
    private JTextField textAddress;
    private JTextField textPort;

    public RTPReceivePanel() {
        this.initComponents();
    }

    public static String run(Frame parent) {
        RTPReceivePanel p = new RTPReceivePanel();
        return (String)ObjEditorOKCancelDialog.run(parent, p, "", "Open RTP Session");
    }

    public Component getComponent() {
        return this;
    }

    public Object getObject() {
        return this.url;
    }

    public void setObjectAndUpdateControl(Object o) {
        this.url = (String)o;
    }

    public boolean validateAndUpdateObj() {
        this.url = null;
        ComponentValidator v = new ComponentValidator();
        try {
            v.validateNotEmpty(this.textAddress, this.labelAddress);
            v.validateNotEmpty(this.textPort, this.labelPort);
            v.validateInteger(this.textPort, this.labelPort);
            v.validateNotEmpty(this.comboTTL, this.labelTTL);
            v.validateInteger(this.comboTTL, this.labelTTL);
        }
        catch (ComponentValidationException e) {
            ErrorDialog.showError((Component)this, e.getMessage());
            return false;
        }
        String sessionAddress = this.textAddress.getText();
        int port = Integer.parseInt(this.textPort.getText());
        int ttl = Integer.parseInt((String)this.comboTTL.getSelectedItem());
        this.url = "rtp://" + sessionAddress + ":" + port;
        return true;
    }

    public String getUrl() {
        return this.url;
    }

    private void initComponents() {
        this.labelAddress = new JLabel();
        this.textAddress = new JTextField();
        this.labelPort = new JLabel();
        this.textPort = new JTextField();
        this.labelTTL = new JLabel();
        this.comboTTL = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.labelAddress.setText("Address:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.labelAddress, gridBagConstraints);
        this.textAddress.setPreferredSize(new Dimension(80, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.textAddress, gridBagConstraints);
        this.labelPort.setText("Port:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.labelPort, gridBagConstraints);
        this.textPort.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.textPort, gridBagConstraints);
        this.labelTTL.setText("TTL:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.labelTTL, gridBagConstraints);
        this.comboTTL.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "8", "16", "32", "64", "128", "255"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.comboTTL, gridBagConstraints);
    }
}

