/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.TrapezoidIntegrator;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealIntegratorImpl;

public class RombergIntegrator
extends UnivariateRealIntegratorImpl {
    private static final long serialVersionUID = -1058849527738180243L;

    public RombergIntegrator(UnivariateRealFunction f) {
        super(f, 32);
    }

    public double integrate(double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        int m = this.maximalIterationCount + 1;
        double[][] t = new double[m][m];
        this.clearResult();
        this.verifyInterval(min, max);
        this.verifyIterationCount();
        TrapezoidIntegrator qtrap = new TrapezoidIntegrator(this.f);
        t[0][0] = qtrap.stage(min, max, 0);
        double olds = t[0][0];
        for (int i = 1; i <= this.maximalIterationCount; ++i) {
            t[i][0] = qtrap.stage(min, max, i);
            for (int j = 1; j <= i; ++j) {
                double r = (1L << 2 * j) - 1L;
                t[i][j] = t[i][j - 1] + (t[i][j - 1] - t[i - 1][j - 1]) / r;
            }
            double s = t[i][i];
            if (i >= this.minimalIterationCount && Math.abs(s - olds) <= Math.abs(this.relativeAccuracy * olds)) {
                this.setResult(s, i);
                return this.result;
            }
            olds = s;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }

    protected void verifyIterationCount() throws IllegalArgumentException {
        super.verifyIterationCount();
        if (this.maximalIterationCount > 32) {
            throw new IllegalArgumentException("Iteration upper limit out of [0, 32] range: " + this.maximalIterationCount);
        }
    }
}

