/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.InterruptedIOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.impl.nio.reactor.AbstractIOReactor;
import org.apache.http.impl.nio.reactor.SessionHandle;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.nio.reactor.IOSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseIOReactor
extends AbstractIOReactor {
    private final long timeoutCheckInterval;
    private final Set<IOSession> bufferingSessions = new HashSet<IOSession>();
    private long lastTimeoutCheck;
    private IOReactorExceptionHandler exceptionHandler = null;
    private IOEventDispatch eventDispatch = null;

    public BaseIOReactor(long selectTimeout) throws IOReactorException {
        this(selectTimeout, false);
    }

    public BaseIOReactor(long selectTimeout, boolean interestOpsQueueing) throws IOReactorException {
        super(selectTimeout, interestOpsQueueing);
        this.timeoutCheckInterval = selectTimeout;
        this.lastTimeoutCheck = System.currentTimeMillis();
    }

    @Override
    public void execute(IOEventDispatch eventDispatch) throws InterruptedIOException, IOReactorException {
        if (eventDispatch == null) {
            throw new IllegalArgumentException("Event dispatcher may not be null");
        }
        this.eventDispatch = eventDispatch;
        this.execute();
    }

    public void setExceptionHandler(IOReactorExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected void handleRuntimeException(RuntimeException ex) {
        if (this.exceptionHandler == null || !this.exceptionHandler.handle(ex)) {
            throw ex;
        }
    }

    @Override
    protected void acceptable(SelectionKey key) {
    }

    @Override
    protected void connectable(SelectionKey key) {
    }

    @Override
    protected void readable(SelectionKey key) {
        SessionHandle handle = (SessionHandle)key.attachment();
        IOSession session = handle.getSession();
        handle.resetLastRead();
        try {
            this.eventDispatch.inputReady(session);
        }
        catch (CancelledKeyException ex) {
            this.queueClosedSession(session);
            key.attach(null);
        }
        catch (RuntimeException ex) {
            this.handleRuntimeException(ex);
        }
        if (session.hasBufferedInput()) {
            this.bufferingSessions.add(session);
        }
    }

    @Override
    protected void writable(SelectionKey key) {
        SessionHandle handle = (SessionHandle)key.attachment();
        IOSession session = handle.getSession();
        handle.resetLastWrite();
        try {
            this.eventDispatch.outputReady(session);
        }
        catch (CancelledKeyException ex) {
            this.queueClosedSession(session);
            key.attach(null);
        }
        catch (RuntimeException ex) {
            this.handleRuntimeException(ex);
        }
    }

    @Override
    protected void validate(Set<SelectionKey> keys) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTimeoutCheck >= this.timeoutCheckInterval) {
            this.lastTimeoutCheck = currentTime;
            if (keys != null) {
                for (SelectionKey key : keys) {
                    this.timeoutCheck(key, currentTime);
                }
            }
        }
        if (!this.bufferingSessions.isEmpty()) {
            Iterator<Object> it = this.bufferingSessions.iterator();
            while (it.hasNext()) {
                IOSession session = (IOSession)it.next();
                if (!session.hasBufferedInput()) {
                    it.remove();
                    continue;
                }
                int ops = 0;
                try {
                    ops = session.getEventMask();
                }
                catch (CancelledKeyException ex) {
                    it.remove();
                    this.queueClosedSession(session);
                    continue;
                }
                if ((ops & 1) <= 0) continue;
                try {
                    this.eventDispatch.inputReady(session);
                }
                catch (CancelledKeyException ex) {
                    it.remove();
                    this.queueClosedSession(session);
                }
                catch (RuntimeException ex) {
                    this.handleRuntimeException(ex);
                }
                if (session.hasBufferedInput()) continue;
                it.remove();
            }
        }
    }

    @Override
    protected void timeoutCheck(SelectionKey key, long now) {
        SessionHandle handle;
        IOSession session;
        int timeout;
        Object attachment = key.attachment();
        if (attachment instanceof SessionHandle && (timeout = (session = (handle = (SessionHandle)key.attachment()).getSession()).getSocketTimeout()) > 0 && handle.getLastAccessTime() + (long)timeout < now) {
            try {
                this.eventDispatch.timeout(session);
            }
            catch (CancelledKeyException ex) {
                this.queueClosedSession(session);
                key.attach(null);
            }
            catch (RuntimeException ex) {
                this.handleRuntimeException(ex);
            }
        }
    }

    @Override
    protected void sessionCreated(SelectionKey key, IOSession session) {
        SessionHandle handle = new SessionHandle(session);
        key.attach(handle);
        try {
            this.eventDispatch.connected(session);
        }
        catch (CancelledKeyException ex) {
            this.queueClosedSession(session);
            key.attach(null);
        }
        catch (RuntimeException ex) {
            this.handleRuntimeException(ex);
        }
    }

    @Override
    protected IOSession getSession(SelectionKey key) {
        Object attachment = key.attachment();
        if (attachment instanceof SessionHandle) {
            SessionHandle handle = (SessionHandle)attachment;
            return handle.getSession();
        }
        return null;
    }

    @Override
    protected void sessionClosed(IOSession session) {
        try {
            this.eventDispatch.disconnected(session);
        }
        catch (CancelledKeyException cancelledKeyException) {
        }
        catch (RuntimeException ex) {
            this.handleRuntimeException(ex);
        }
    }
}

