/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.bushe.swing.event.EventService;

public abstract class EventServiceAction
extends AbstractAction {
    public static final String EVENT_SERVICE_TOPIC_NAME = "event-service-topic";
    private boolean throwsExceptionOnNullEventService = true;
    public static final String EVENT_BUS_EVENT_CLASS_NAME = "eventBus.eventClassName";
    private String topicName;
    private boolean publishesOnTopic = true;

    public EventServiceAction() {
    }

    public EventServiceAction(String string, ImageIcon imageIcon) {
        super(string, imageIcon);
    }

    protected abstract EventService getEventService(ActionEvent var1);

    public boolean isPublishesOnTopic() {
        return this.publishesOnTopic;
    }

    public void setPublishesOnTopic(boolean bl) {
        this.publishesOnTopic = bl;
    }

    public void setTopicName(String string) {
        this.topicName = string;
    }

    public String getTopicName(ActionEvent actionEvent) {
        if (this.topicName != null) {
            return this.topicName;
        }
        Object object = this.getValue(EVENT_SERVICE_TOPIC_NAME);
        if (object != null) {
            return object + "";
        }
        object = this.getValue("ID");
        if (object != null) {
            return object + "";
        }
        object = this.getValue("ActionCommandKey");
        if (object != null) {
            return object + "";
        }
        object = actionEvent.getActionCommand();
        if (object != null) {
            return object + "";
        }
        return (String)this.getName();
    }

    protected Object getTopicValue(ActionEvent actionEvent) {
        return actionEvent;
    }

    public Object getName() {
        return this.getValue("Name");
    }

    protected Object getEventServiceEvent(ActionEvent actionEvent) {
        return actionEvent;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        EventService eventService = this.getEventService(actionEvent);
        if (eventService == null) {
            if (this.getThrowsExceptionOnNullEventService()) {
                throw new RuntimeException("Null EventService supplied to EventServiceAction with name:" + this.getName());
            }
            return;
        }
        if (this.isPublishesOnTopic()) {
            String string = this.getTopicName(actionEvent);
            Object object = this.getTopicValue(actionEvent);
            eventService.publish(string, object);
        } else {
            Object object = this.getEventServiceEvent(actionEvent);
            eventService.publish(object);
        }
    }

    public boolean getThrowsExceptionOnNullEventService() {
        return this.throwsExceptionOnNullEventService;
    }

    public void setThrowsExceptionOnNullEventService(boolean bl) {
        this.throwsExceptionOnNullEventService = bl;
    }
}

