/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class CountingInputStream
extends FilterInputStream {
    private long markPos = 0L;
    private long readCount = 0L;

    public CountingInputStream(InputStream stream) {
        super(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bytesRead(long i) {
        CountingInputStream countingInputStream = this;
        synchronized (countingInputStream) {
            if (i >= 0L) {
                this.readCount += i;
            }
        }
    }

    public long getReadCount() {
        return this.readCount;
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.markPos = this.readCount;
    }

    @Override
    public int read() throws IOException {
        int result = super.read();
        this.bytesRead(1L);
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        this.bytesRead(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        CountingInputStream countingInputStream = this;
        synchronized (countingInputStream) {
            this.readCount = this.markPos;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = super.skip(n);
        this.bytesRead(skipped);
        return skipped;
    }
}

