/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;

public class TextEncodedStringSizeTerminated
extends AbstractString {
    public TextEncodedStringSizeTerminated(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
    }

    public TextEncodedStringSizeTerminated(TextEncodedStringSizeTerminated object) {
        super(object);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TextEncodedStringSizeTerminated)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        String charSetName = this.getTextEncodingCharSet();
        CharsetDecoder decoder = Charset.forName(charSetName).newDecoder();
        ByteBuffer inBuffer = ByteBuffer.wrap(arr, offset, arr.length - offset).slice();
        CharBuffer outBuffer = CharBuffer.allocate(arr.length - offset);
        decoder.reset();
        CoderResult coderResult = decoder.decode(inBuffer, outBuffer, true);
        if (coderResult.isError()) {
            // empty if block
        }
        decoder.flush(outBuffer);
        outBuffer.flip();
        this.value = outBuffer.toString();
        this.setSize(arr.length - offset);
    }

    @Override
    public byte[] writeByteArray() {
        byte[] data = null;
        try {
            String charSetName;
            String stringValue;
            if (TagOptionSingleton.getInstance().isRemoveTrailingTerminatorOnWrite() && (stringValue = (String)this.value).length() > 0 && stringValue.charAt(stringValue.length() - 1) == '\u0000') {
                stringValue = stringValue.substring(0, stringValue.length() - 1);
                this.value = stringValue;
            }
            if ((charSetName = this.getTextEncodingCharSet()).equals("UTF-16")) {
                charSetName = "UTF-16LE";
                CharsetEncoder encoder = Charset.forName(charSetName).newEncoder();
                ByteBuffer bb = encoder.encode(CharBuffer.wrap('\ufeff' + (String)this.value));
                data = new byte[bb.limit()];
                bb.get(data, 0, bb.limit());
            } else {
                CharsetEncoder encoder = Charset.forName(charSetName).newEncoder();
                ByteBuffer bb = encoder.encode(CharBuffer.wrap((String)this.value));
                data = new byte[bb.limit()];
                bb.get(data, 0, bb.limit());
            }
        }
        catch (CharacterCodingException ce) {
            throw new RuntimeException(ce);
        }
        this.setSize(data.length);
        return data;
    }

    protected String getTextEncodingCharSet() {
        byte textEncoding = this.getBody().getTextEncoding();
        String charSetName = TextEncoding.getInstanceOf().getValueForId(textEncoding);
        return charSetName;
    }

    private static List splitByNullSeperator(String value) {
        String[] valuesarray = value.split("\\u0000");
        List<String> values = Arrays.asList(valuesarray);
        if (values.size() == 0) {
            values = new ArrayList<String>(1);
            values.add("");
        }
        return values;
    }

    public void addValue(String value) {
        this.setValue(this.value + "\u0000" + value);
    }

    public int getNumberOfValues() {
        return TextEncodedStringSizeTerminated.splitByNullSeperator((String)this.value).size();
    }

    public String getValueAtIndex(int index) {
        List values = TextEncodedStringSizeTerminated.splitByNullSeperator((String)this.value);
        return (String)values.get(index);
    }
}

