/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.transitions;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;
import org.jdesktop.animation.timing.interpolation.PropertySetter;
import org.jdesktop.animation.transitions.AnimationLayer;
import org.jdesktop.animation.transitions.AnimationManager;
import org.jdesktop.animation.transitions.AnimationState;
import org.jdesktop.animation.transitions.ComponentState;
import org.jdesktop.animation.transitions.TransitionTarget;

public class ScreenTransition {
    private AnimationManager animationManager;
    private AnimationLayer animationLayer;
    private JComponent containerLayer;
    private BufferedImage transitionImage;
    private TransitionTarget transitionTarget;
    private Component savedGlassPane;
    private Animator animator = null;
    private TimingTarget transitionTimingTarget = new TimingTargetAdapter(){

        public void begin() {
            ScreenTransition.this.createTransitionImages();
            ScreenTransition.this.animationManager.setupStart();
            ScreenTransition.this.animationLayer.setupBackground(ScreenTransition.this.containerLayer);
            ScreenTransition.this.savedGlassPane = ScreenTransition.this.containerLayer.getRootPane().getGlassPane();
            ScreenTransition.this.containerLayer.getRootPane().setGlassPane(ScreenTransition.this.animationLayer);
            ScreenTransition.this.containerLayer.getRootPane().getGlassPane().setVisible(true);
            ScreenTransition.this.transitionTarget.setupNextScreen();
            ScreenTransition.this.containerLayer.validate();
            ScreenTransition.this.animationManager.setupEnd();
            ScreenTransition.this.animationManager.init(ScreenTransition.this.animator);
            ScreenTransition.this.containerLayer.setVisible(false);
            this.timingEvent(0.0f);
        }

        public void timingEvent(float elapsedFraction) {
            Graphics2D gImg = (Graphics2D)ScreenTransition.this.transitionImage.getGraphics();
            ScreenTransition.this.animationManager.paint(gImg);
            gImg.dispose();
            ScreenTransition.this.animationLayer.repaint();
        }

        public void end() {
            ScreenTransition.this.containerLayer.getRootPane().setGlassPane(ScreenTransition.this.savedGlassPane);
            ScreenTransition.this.containerLayer.getRootPane().getGlassPane().setVisible(false);
            ScreenTransition.this.animationLayer.setVisible(false);
            ScreenTransition.this.containerLayer.setVisible(true);
            ScreenTransition.this.containerLayer.repaint();
            ScreenTransition.this.animationManager.reset(ScreenTransition.this.animator);
        }
    };

    private ScreenTransition(JComponent transitionComponent, TransitionTarget transitionTarget) {
        this.containerLayer = transitionComponent;
        this.transitionTarget = transitionTarget;
        this.animationManager = new AnimationManager(transitionComponent);
        this.animationLayer = new AnimationLayer(this);
        this.animationLayer.setVisible(false);
        PropertySetter propertySetter = new PropertySetter((Object)transitionComponent, "location", new Point(0, 0));
        AnimationState animState = new AnimationState();
        ComponentState compState = new ComponentState();
        this.containerLayer.addComponentListener(new ContainerSizeListener());
        this.createTransitionImages();
    }

    public ScreenTransition(JComponent transitionComponent, TransitionTarget transitionTarget, Animator animator) {
        this(transitionComponent, transitionTarget);
        this.setAnimator(animator);
    }

    public ScreenTransition(JComponent transitionComponent, TransitionTarget transitionTarget, int duration) {
        this(transitionComponent, transitionTarget);
        this.setAnimator(new Animator(duration, this.transitionTimingTarget));
    }

    private void createTransitionImages() {
        int cw = this.containerLayer.getWidth();
        int ch = this.containerLayer.getHeight();
        if (cw > 0 && ch > 0 && (this.transitionImage == null || this.transitionImage.getWidth() != cw || this.transitionImage.getHeight() != ch)) {
            this.transitionImage = (BufferedImage)this.containerLayer.createImage(cw, ch);
            this.animationManager.recreateImage();
        }
    }

    public Animator getAnimator() {
        return this.animator;
    }

    public void setAnimator(Animator animator) {
        if (animator == null) {
            throw new IllegalArgumentException("Animator must be non-null");
        }
        if (animator.isRunning()) {
            throw new IllegalStateException("Cannot perform this operation while animator is running");
        }
        this.animator = animator;
        animator.addTarget(this.transitionTimingTarget);
    }

    Image getTransitionImage() {
        return this.transitionImage;
    }

    public void start() {
        if (this.animator.isRunning()) {
            this.animator.stop();
        }
        this.animator.start();
    }

    private class ContainerSizeListener
    extends ComponentAdapter {
        private ContainerSizeListener() {
        }

        public void componentResized(ComponentEvent ce) {
            ScreenTransition.this.createTransitionImages();
        }
    }
}

