/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.net.URI;
import org.jivesoftware.smackx.packet.PEPItem;

public class Tune
extends PEPItem {
    private String artist;
    private short length;
    private int rating;
    private String source;
    private String title;
    private String track;
    private URI uri;

    public Tune(String id) {
        super(id);
    }

    String getNode() {
        return "http://jabber.org/protocol/tune";
    }

    String getItemDetailsXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append("tune").append(" xmlns=\"").append("http://jabber.org/protocol/tune").append("\">");
        if (this.artist != null) {
            buf.append("<artist>").append(this.artist).append("</artist>");
        }
        if (this.length != 0) {
            buf.append("<length>").append(this.length).append("</length>");
        }
        if (this.rating != 0) {
            buf.append("<rating>").append(this.rating).append("</rating>");
        }
        if (this.source != null) {
            buf.append("<source>").append(this.source).append("</source>");
        }
        if (this.title != null) {
            buf.append("<title>").append(this.title).append("</title>");
        }
        if (this.track != null) {
            buf.append("<track>").append(this.track).append("</track>");
        }
        if (this.uri != null) {
            buf.append("<uri>").append(this.uri).append("</uri>");
        }
        buf.append("</tune>");
        return buf.toString();
    }

    public String getArtist() {
        return this.artist;
    }

    public void setArtist(String artist) {
        this.artist = artist;
    }

    public short getLength() {
        return this.length;
    }

    public void setLength(short length) {
        if (length < 0) {
            length = (short)(length * -1);
        }
        this.length = length;
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int rating) {
        if (rating < 0) {
            rating = 0;
        } else if (rating > 10) {
            rating = 10;
        }
        this.rating = rating;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTrack() {
        return this.track;
    }

    public void setTrack(String track) {
        this.track = track;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }
}

