/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.bittorrent.bencoding;

import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.limewire.bittorrent.bencoding.BEBoolean;
import org.limewire.bittorrent.bencoding.BEDictionary;
import org.limewire.bittorrent.bencoding.BEList;
import org.limewire.bittorrent.bencoding.BELong;
import org.limewire.bittorrent.bencoding.BERational;
import org.limewire.bittorrent.bencoding.BEString;
import org.limewire.util.BEncoder;

public abstract class Token<T> {
    protected static final int INTERNAL = -1;
    public static final int LONG = 0;
    public static final int STRING = 1;
    public static final int LIST = 2;
    public static final int DICTIONARY = 3;
    public static final int BOOLEAN = 4;
    public static final int RATIONAL = 5;
    protected static final String ASCII = "ISO-8859-1";
    protected static final byte ZERO;
    protected static final byte NINE;
    protected final ReadableByteChannel chan;
    protected T result;
    static final EndElement TERMINATOR;

    public Token(ReadableByteChannel chan) {
        this.chan = chan;
    }

    public abstract void handleRead() throws IOException;

    protected abstract boolean isDone();

    public abstract int getType();

    public T getResult() {
        if (!this.isDone()) {
            return null;
        }
        return this.result;
    }

    public static Token<?> getNextToken(ReadableByteChannel chan, String charsetName) throws IOException {
        byte[] b = new byte[1];
        ByteBuffer one_byte = ByteBuffer.wrap(b);
        int read = chan.read(one_byte);
        if (read == 0) {
            return null;
        }
        if (read == -1) {
            throw new EOFException("Could not read next Token");
        }
        if (b[0] == BEncoder.I) {
            return new BELong(chan);
        }
        if (b[0] == BEncoder.R) {
            return new BERational(chan);
        }
        if (b[0] == BEncoder.D) {
            return new BEDictionary(chan, charsetName);
        }
        if (b[0] == BEncoder.L) {
            return new BEList(chan);
        }
        if (b[0] == BEncoder.E) {
            return TERMINATOR;
        }
        if (b[0] >= ZERO && b[0] <= NINE) {
            return new BEString(b[0], chan);
        }
        if (b[0] == BEncoder.TRUE || b[0] == BEncoder.FALSE) {
            return b[0] == BEncoder.TRUE ? BEBoolean.TRUE : BEBoolean.FALSE;
        }
        throw new IOException("unrecognized token type " + (char)b[0]);
    }

    public static Token<?> getNextToken(ReadableByteChannel chan) throws IOException {
        return Token.getNextToken(chan, ASCII);
    }

    public static Object parse(ReadableByteChannel byteChannel, String charsetName) throws IOException {
        Token<?> t = Token.getNextToken(byteChannel, charsetName);
        if (t == null) {
            return null;
        }
        t.handleRead();
        return t.getResult();
    }

    public static Object parse(ReadableByteChannel byteChannel) throws IOException {
        return Token.parse(byteChannel, ASCII);
    }

    static {
        byte zero = 0;
        byte nine = 0;
        try {
            zero = "0".getBytes(ASCII)[0];
            nine = "9".getBytes(ASCII)[0];
        }
        catch (UnsupportedEncodingException impossible) {
            throw new RuntimeException(impossible);
        }
        ZERO = zero;
        NINE = nine;
        TERMINATOR = new EndElement();
    }

    private static class EndElement
    extends Token<EndElement> {
        EndElement() {
            super(null);
            this.result = this;
        }

        @Override
        public void handleRead() throws IOException {
        }

        @Override
        protected boolean isDone() {
            return true;
        }

        @Override
        public int getType() {
            return -1;
        }
    }
}

