/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import org.limewire.collection.LIFOSet;

public class FixedSizeLIFOSet<E>
extends LIFOSet<E> {
    final int maxSize;
    private final EjectionPolicy policy;

    public FixedSizeLIFOSet(int maxSize) {
        this(maxSize, EjectionPolicy.LIFO);
    }

    public FixedSizeLIFOSet(int maxSize, EjectionPolicy policy) {
        this.maxSize = maxSize;
        this.policy = policy;
    }

    public FixedSizeLIFOSet(int maxSize, int initialCapacity, float loadFactor) {
        this(maxSize, initialCapacity, loadFactor, EjectionPolicy.LIFO);
    }

    public FixedSizeLIFOSet(int maxSize, int initialCapacity, float loadFactor, EjectionPolicy policy) {
        super(initialCapacity, loadFactor);
        this.maxSize = maxSize;
        this.policy = policy;
    }

    @Override
    public boolean add(E o) {
        boolean added = super.add(o);
        if (added && this.size() > this.maxSize) {
            if (this.policy == EjectionPolicy.FIFO) {
                this.remove(0);
            } else {
                this.remove(Math.max(0, this.size() - 2));
            }
            assert (this.size() <= this.maxSize);
        }
        return added;
    }

    public static enum EjectionPolicy {
        LIFO,
        FIFO;

    }
}

