/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MultiIterator<T>
implements Iterator<T> {
    protected final Iterator<? extends T>[] iterators;
    protected int current;

    public MultiIterator(Iterator<? extends T> i1) {
        this.iterators = new Iterator[]{i1};
    }

    public MultiIterator(Iterator<? extends T> i1, Iterator<? extends T> i2) {
        this.iterators = new Iterator[]{i1, i2};
    }

    public MultiIterator(Iterator<? extends T> i1, Iterator<? extends T> i2, Iterator<? extends T> i3) {
        this.iterators = new Iterator[]{i1, i2, i3};
    }

    public MultiIterator(Iterator<? extends T> i1, Iterator<? extends T> i2, Iterator<? extends T> i3, Iterator<? extends T> i4) {
        this.iterators = new Iterator[]{i1, i2, i3, i4};
    }

    public MultiIterator(Iterator<? extends T> ... iterators) {
        this.iterators = iterators;
    }

    public MultiIterator(Iterable<? extends Iterator<? extends T>> iterators) {
        ArrayList<Iterator<T>> list = new ArrayList<Iterator<T>>();
        for (Iterator<T> iterator : iterators) {
            list.add(iterator);
        }
        this.iterators = list.toArray(new Iterator[list.size()]);
    }

    @Override
    public void remove() {
        if (this.iterators.length == 0) {
            throw new IllegalStateException();
        }
        this.iterators[this.current].remove();
    }

    @Override
    public boolean hasNext() {
        for (Iterator<T> iterator : this.iterators) {
            if (!iterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (this.iterators.length == 0) {
            throw new NoSuchElementException();
        }
        this.positionCurrent();
        return this.iterators[this.current].next();
    }

    protected void positionCurrent() {
        while (!this.iterators[this.current].hasNext() && this.current < this.iterators.length) {
            ++this.current;
        }
    }
}

