/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.limewire.util.Clock;

public class Periodic {
    private static final long NANO_ORIGIN = System.nanoTime();
    private final ScheduledExecutorService scheduler;
    private final Delegate d;
    private long nextExecuteTime;
    private Future future;
    private final Clock clock;

    private long now() {
        if (this.clock == null) {
            return System.nanoTime() - NANO_ORIGIN;
        }
        return this.clock.nanoTime() - NANO_ORIGIN;
    }

    public Periodic(Runnable r, ScheduledExecutorService scheduler) {
        this(r, scheduler, null);
    }

    public Periodic(Runnable r, ScheduledExecutorService scheduler, Clock clock) {
        this.d = new Delegate(r);
        this.scheduler = scheduler;
        this.clock = clock;
    }

    public synchronized boolean rescheduleIfLater(long newDelay) {
        newDelay = TimeUnit.MILLISECONDS.toNanos(newDelay);
        long now = this.now();
        if (Long.MAX_VALUE - now < newDelay) {
            newDelay = Long.MAX_VALUE - now;
        }
        long newTime = now + newDelay;
        if (this.future == null) {
            this.nextExecuteTime = newTime;
            if (newDelay > 0L) {
                this.future = this.scheduler.schedule(this.d, newDelay, TimeUnit.NANOSECONDS);
            } else {
                this.scheduler.execute(this.d);
            }
            return true;
        }
        if (newTime > this.nextExecuteTime) {
            this.nextExecuteTime = newTime;
            return true;
        }
        return false;
    }

    public synchronized boolean rescheduleIfSooner(long newDelay) {
        long newTime;
        if (this.future == null) {
            return this.rescheduleIfLater(newDelay);
        }
        newDelay = TimeUnit.MILLISECONDS.toNanos(newDelay);
        long now = this.now();
        if (Long.MAX_VALUE - now < newDelay) {
            newDelay = Long.MAX_VALUE - now;
        }
        if ((newTime = now + newDelay) < this.nextExecuteTime) {
            this.future.cancel(false);
            this.nextExecuteTime = newTime;
            if (newDelay > 0L) {
                this.future = this.scheduler.schedule(this.d, newDelay, TimeUnit.NANOSECONDS);
            } else {
                this.future = null;
                this.scheduler.execute(this.d);
            }
            return true;
        }
        return false;
    }

    public synchronized void unschedule() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
            this.nextExecuteTime = -1L;
        }
    }

    protected Runnable getRunnable() {
        return this.d.r;
    }

    private class Delegate
    implements Runnable {
        private final Runnable r;

        Delegate(Runnable r) {
            this.r = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Periodic periodic = Periodic.this;
            synchronized (periodic) {
                Periodic.this.future = null;
                long now = Periodic.this.now();
                if (now < Periodic.this.nextExecuteTime) {
                    Periodic.this.future = Periodic.this.scheduler.schedule(this, Math.max(0L, Periodic.this.nextExecuteTime - now), TimeUnit.NANOSECONDS);
                    return;
                }
            }
            this.r.run();
        }
    }
}

