/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.api.download;

import java.io.File;
import java.io.IOException;

public class DownloadException
extends IOException {
    private final ErrorCode errorCode;
    private final File file;

    public DownloadException(IOException cause, File file) {
        super(cause);
        this.errorCode = ErrorCode.FILESYSTEM_ERROR;
        this.file = file;
    }

    public DownloadException(ErrorCode errorCode, File file) {
        super("error code " + (Object)((Object)errorCode) + ", file " + file);
        this.errorCode = errorCode;
        this.file = file;
    }

    public DownloadException(ErrorCode errorCode, File file, String message) {
        super(message);
        this.errorCode = errorCode;
        this.file = file;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public File getFile() {
        return this.file;
    }

    public static enum ErrorCode {
        SECURITY_VIOLATION,
        FILE_ALREADY_SAVED,
        DIRECTORY_NOT_WRITEABLE,
        DIRECTORY_DOES_NOT_EXIST,
        FILE_ALREADY_EXISTS,
        FILE_IS_ALREADY_DOWNLOADED_TO,
        FILE_NOT_REGULAR,
        NOT_A_DIRECTORY,
        FILESYSTEM_ERROR,
        FILE_ALREADY_DOWNLOADING,
        PATH_NAME_TOO_LONG,
        TORRENT_FILE_TOO_LARGE,
        NO_TORRENT_MANAGER,
        FILES_STILL_RESUMING,
        DOWNLOAD_CANCELLED,
        FILE_ALREADY_UPLOADING;

    }
}

