/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.library;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.library.CreationTimeCache;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.IncompleteFileDesc;
import com.limegroup.gnutella.library.LocalFileDetailsFactory;
import java.io.File;
import java.util.Date;
import java.util.HashSet;
import org.limewire.core.api.Category;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.impl.InvalidURN;
import org.limewire.core.impl.util.FilePropertyKeyPopulator;
import org.limewire.friend.api.FileMetaData;
import org.limewire.friend.impl.FileMetaDataImpl;
import org.limewire.util.FileUtils;
import org.limewire.util.Objects;

class CoreLocalFileItem
implements LocalFileItem,
Comparable {
    private final Category category;
    private final FileDesc fileDesc;
    private final LocalFileDetailsFactory detailsFactory;
    private final CreationTimeCache creationTimeCache;

    @Inject
    public CoreLocalFileItem(@Assisted FileDesc fileDesc, LocalFileDetailsFactory detailsFactory, CreationTimeCache creationTimeCache, CategoryManager categoryManager) {
        this.fileDesc = fileDesc;
        this.detailsFactory = detailsFactory;
        this.creationTimeCache = creationTimeCache;
        this.category = categoryManager.getCategoryForFile(fileDesc.getFile());
    }

    @Override
    public long getCreationTime() {
        URN sha1 = this.fileDesc.getSHA1Urn();
        if (sha1 != null) {
            return this.creationTimeCache.getCreationTimeAsLong(sha1);
        }
        return -1L;
    }

    @Override
    public File getFile() {
        return this.fileDesc.getFile();
    }

    @Override
    public long getLastModifiedTime() {
        return this.fileDesc.lastModified();
    }

    @Override
    public String getName() {
        return FileUtils.getFilenameNoExtension(this.fileDesc.getFileName());
    }

    @Override
    public long getSize() {
        return this.fileDesc.getFileSize();
    }

    @Override
    public int getNumHits() {
        return this.fileDesc.getHitCount();
    }

    @Override
    public int getNumUploads() {
        return this.fileDesc.getCompletedUploads();
    }

    @Override
    public int getNumUploadAttempts() {
        return this.getFileDesc().getAttemptedUploads();
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public Object getProperty(FilePropertyKey property) {
        switch (property) {
            case LOCATION: {
                return this.getFile().getParent();
            }
            case NAME: {
                return this.getName();
            }
            case DATE_CREATED: {
                long ct = this.getCreationTime();
                return ct == -1L ? null : Long.valueOf(ct);
            }
            case FILE_SIZE: {
                return this.getSize();
            }
        }
        return FilePropertyKeyPopulator.get(this.category, property, this.fileDesc.getXMLDocument());
    }

    @Override
    public String getPropertyString(FilePropertyKey key) {
        Object value = this.getProperty(key);
        if (value != null) {
            String stringValue = value.toString();
            return stringValue;
        }
        return null;
    }

    @Override
    public FileMetaData toMetadata() {
        FileMetaDataImpl fileMetaData = new FileMetaDataImpl();
        fileMetaData.setCreateTime(new Date(this.getCreationTime()));
        fileMetaData.setDescription("");
        fileMetaData.setId(this.fileDesc.getSHA1Urn().toString());
        fileMetaData.setIndex(this.fileDesc.getIndex());
        fileMetaData.setName(this.fileDesc.getFileName());
        fileMetaData.setSize(this.fileDesc.getFileSize());
        HashSet<String> urns = new HashSet<String>();
        for (URN urn : this.fileDesc.getUrns()) {
            urns.add(urn.toString());
        }
        fileMetaData.setURNs(urns);
        return fileMetaData;
    }

    public FileDetails getFileDetails() {
        return this.detailsFactory.create(this.fileDesc);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getFile() == null ? 0 : this.getFile().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.getFile().equals(((CoreLocalFileItem)obj).getFile());
    }

    public String toString() {
        return "CoreLocalFileItem for: " + this.fileDesc;
    }

    @Override
    public String getFileName() {
        return this.fileDesc.getFileName();
    }

    @Override
    public boolean isShareable() {
        return !InvalidURN.instance.equals(this.getUrn()) && this.fileDesc.isShareable() && !this.isIncomplete();
    }

    @Override
    public org.limewire.core.api.URN getUrn() {
        URN urn = this.fileDesc.getSHA1Urn();
        if (urn != null) {
            return urn;
        }
        return InvalidURN.instance;
    }

    @Override
    public boolean isIncomplete() {
        return this.fileDesc instanceof IncompleteFileDesc;
    }

    public FileDesc getFileDesc() {
        return this.fileDesc;
    }

    public int compareTo(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return -1;
        }
        return Objects.compareToNullIgnoreCase(this.getFileName(), ((CoreLocalFileItem)obj).getFileName(), true);
    }

    @Override
    public boolean isLoaded() {
        return !InvalidURN.instance.equals(this.getUrn());
    }
}

