/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.library;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.metadata.MetaDataFactory;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.limewire.core.api.Category;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.MetaDataException;
import org.limewire.core.api.library.MetaDataManager;
import org.limewire.core.impl.library.CoreLocalFileItem;
import org.limewire.core.impl.util.FilePropertyKeyPopulator;
import org.limewire.util.NameValue;
import org.xml.sax.SAXException;

@Singleton
public class MetaDataManagerImpl
implements MetaDataManager {
    private final SchemaReplyCollectionMapper schemaReplyCollectionMapper;
    private final LimeXMLDocumentFactory limeXMLDocumentFactory;
    private final Provider<MetaDataFactory> metaDataFactory;

    @Inject
    public MetaDataManagerImpl(LimeXMLDocumentFactory limeXMLDocumentFactory, SchemaReplyCollectionMapper schemaReplyCollectionMapper, Provider<MetaDataFactory> metaDataFactory) {
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
        this.schemaReplyCollectionMapper = schemaReplyCollectionMapper;
        this.metaDataFactory = metaDataFactory;
    }

    @Override
    public void save(LocalFileItem localFileItem, Map<FilePropertyKey, Object> newData) throws MetaDataException {
        if (localFileItem instanceof CoreLocalFileItem) {
            CoreLocalFileItem coreLocalFileItem = (CoreLocalFileItem)localFileItem;
            this.saveMetaData(coreLocalFileItem, newData);
        }
    }

    private void saveMetaData(CoreLocalFileItem coreLocalFileItem, Map<FilePropertyKey, Object> newData) throws MetaDataException {
        LimeXMLReplyCollection.MetaDataState committed;
        FileDesc fileDesc = coreLocalFileItem.getFileDesc();
        Category category = coreLocalFileItem.getCategory();
        String limeXMLSchemaUri = FilePropertyKeyPopulator.getLimeXmlSchemaUri(category);
        LimeXMLDocument oldDocument = fileDesc.getXMLDocument(limeXMLSchemaUri);
        String input = this.buildInput(fileDesc, limeXMLSchemaUri, coreLocalFileItem, newData);
        if (oldDocument != null && (input == null || input.trim().length() == 0)) {
            this.removeMeta(fileDesc, limeXMLSchemaUri);
            return;
        }
        if (input == null || input.trim().length() == 0) {
            return;
        }
        LimeXMLDocument newDoc = null;
        try {
            newDoc = this.limeXMLDocumentFactory.createLimeXMLDocument(input);
        }
        catch (SAXException e) {
            throw new MetaDataException("Internal Document Error. Data could not be saved.", e);
        }
        catch (SchemaNotFoundException e) {
            throw new MetaDataException("Internal Document Error. Data could not be saved.", e);
        }
        catch (IOException e) {
            throw new MetaDataException("Internal Document Error. Data could not be saved.", e);
        }
        String schemaURI = newDoc.getSchemaURI();
        LimeXMLReplyCollection collection = this.schemaReplyCollectionMapper.getReplyCollection(schemaURI);
        LimeXMLDocument result = null;
        if (oldDocument != null) {
            result = this.merge(oldDocument, newDoc);
            oldDocument = collection.replaceDoc(fileDesc, result);
        } else {
            result = newDoc;
            collection.addReply(fileDesc, result);
        }
        if (this.metaDataFactory.get().containsReader(fileDesc.getFile()) ? (committed = collection.mediaFileToDisk(fileDesc, result)) != LimeXMLReplyCollection.MetaDataState.NORMAL && committed != LimeXMLReplyCollection.MetaDataState.UNCHANGED : !collection.writeMapToDisk()) {
            throw new MetaDataException("Internal Document Error. Data could not be saved.");
        }
    }

    public LimeXMLDocument merge(LimeXMLDocument currentDoc, LimeXMLDocument newDoc) {
        if (!currentDoc.getSchemaURI().equalsIgnoreCase(newDoc.getSchemaURI())) {
            throw new IllegalArgumentException("Current XML document and new XML document must be of the same type!");
        }
        HashMap<String, Map.Entry<String, String>> map = new HashMap<String, Map.Entry<String, String>>();
        for (Map.Entry<String, String> entry : currentDoc.getNameValueSet()) {
            map.put(entry.getKey(), entry);
        }
        for (Map.Entry<String, String> entry : newDoc.getNameValueSet()) {
            map.put(entry.getKey(), entry);
        }
        return this.limeXMLDocumentFactory.createLimeXMLDocument(map.values(), currentDoc.getSchemaURI());
    }

    private String buildInput(FileDesc fileDesc, String limeXMLSchemaUri, LocalFileItem localFileItem, Map<FilePropertyKey, Object> newData) {
        ArrayList<NameValue<String>> nameValueList = new ArrayList<NameValue<String>>();
        Category category = localFileItem.getCategory();
        for (FilePropertyKey filePropertyKey : newData.keySet()) {
            String limeXmlName = FilePropertyKeyPopulator.getLimeXmlName(category, filePropertyKey);
            if (limeXmlName == null) continue;
            Object value = newData.get((Object)filePropertyKey);
            if (value != null) {
                value = FilePropertyKeyPopulator.sanitizeValue(filePropertyKey, value);
            }
            if (value == null) {
                value = "";
            }
            nameValueList.add(new NameValue<String>(limeXmlName, value.toString()));
        }
        if (nameValueList.size() == 0) {
            return null;
        }
        return this.limeXMLDocumentFactory.createLimeXMLDocument(nameValueList, limeXMLSchemaUri).getXMLString();
    }

    private void removeMeta(FileDesc fileDesc, String limeXMLSchemaUri) throws MetaDataException {
        LimeXMLReplyCollection collection = this.schemaReplyCollectionMapper.getReplyCollection(limeXMLSchemaUri);
        if (!collection.removeDoc(fileDesc)) {
            throw new MetaDataException("Internal Document Error. Data could not be saved.");
        }
    }
}

