/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.library;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import com.limegroup.gnutella.library.FileCollectionManager;
import com.limegroup.gnutella.library.FileView;
import com.limegroup.gnutella.library.FileViewChangeEvent;
import com.limegroup.gnutella.library.SharedFileCollection;
import com.limegroup.gnutella.library.SharedFileCollectionChangeEvent;
import com.limegroup.gnutella.library.SharedFiles;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.Category;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.core.api.library.SharedFileListManager;
import org.limewire.core.impl.library.CoreLocalFileItemFactory;
import org.limewire.core.impl.library.SharedFileListImpl;
import org.limewire.core.settings.LibrarySettings;
import org.limewire.inject.EagerSingleton;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.inspection.InspectionPoint;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.SwingSafePropertyChangeSupport;

@EagerSingleton
class SharedFileListManagerImpl
implements SharedFileListManager {
    private final FileCollectionManager collectionManager;
    private final CoreLocalFileItemFactory coreLocalFileItemFactory;
    private final EventList<SharedFileList> sharedLists = GlazedListsFactory.threadSafeList(new BasicEventList());
    private final EventList<SharedFileList> readOnlySharedLists = GlazedListsFactory.readOnlyList(this.sharedLists);
    private final FileView allSharedFilesView;
    private final PropertyChangeSupport changeSupport = new SwingSafePropertyChangeSupport(this);
    @InspectablePrimitive(value="number of lists created", category=DataCategory.USAGE)
    private volatile long listsCreated;
    @InspectablePrimitive(value="number of lists shared", category=DataCategory.USAGE)
    private volatile long listsShared;

    @Inject
    SharedFileListManagerImpl(FileCollectionManager collectionManager, CoreLocalFileItemFactory coreLocalFileItemFactory, LibraryManager libraryManager, @SharedFiles FileView allSharedFilesView) {
        this.collectionManager = collectionManager;
        this.coreLocalFileItemFactory = coreLocalFileItemFactory;
        this.allSharedFilesView = allSharedFilesView;
    }

    @Inject
    void register(ListenerSupport<SharedFileCollectionChangeEvent> support) {
        this.allSharedFilesView.addListener(new EventListener<FileViewChangeEvent>(){

            @Override
            public void handleEvent(FileViewChangeEvent event) {
                switch (event.getType()) {
                    case FILE_ADDED: 
                    case FILE_REMOVED: 
                    case FILES_CLEARED: {
                        SharedFileListManagerImpl.this.changeSupport.firePropertyChange("sharedFileCount", null, (Object)SharedFileListManagerImpl.this.allSharedFilesView.size());
                    }
                }
            }
        });
        for (SharedFileCollection collection : this.collectionManager.getSharedFileCollections()) {
            this.collectionAdded(collection);
        }
        support.addListener(new EventListener<SharedFileCollectionChangeEvent>(){

            @Override
            public void handleEvent(SharedFileCollectionChangeEvent event) {
                switch (event.getType()) {
                    case COLLECTION_ADDED: {
                        SharedFileListManagerImpl.this.collectionAdded(event.getSource());
                        break;
                    }
                    case COLLECTION_REMOVED: {
                        SharedFileListManagerImpl.this.collectionRemoved(event.getSource());
                        break;
                    }
                    case FRIEND_ADDED: {
                        SharedFileListManagerImpl.this.friendAddedToCollection(event.getSource(), event.getFriendId());
                        break;
                    }
                    case FRIEND_IDS_CHANGED: {
                        SharedFileListManagerImpl.this.friendsSetInCollection(event.getSource(), event.getNewFriendIds());
                        break;
                    }
                    case FRIEND_REMOVED: {
                        SharedFileListManagerImpl.this.friendRemoved(event.getSource(), event.getFriendId());
                        break;
                    }
                    case NAME_CHANGED: {
                        SharedFileListManagerImpl.this.nameChanged(event.getSource());
                    }
                }
            }
        });
    }

    private void nameChanged(SharedFileCollection collection) {
        this.setListInPlace(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setListInPlace(SharedFileCollection collection) {
        this.sharedLists.getReadWriteLock().writeLock().lock();
        try {
            for (int i = 0; i < this.sharedLists.size(); ++i) {
                SharedFileListImpl impl = (SharedFileListImpl)this.sharedLists.get(i);
                if (impl.getCoreCollection() != collection) continue;
                this.sharedLists.set(i, impl);
                break;
            }
        }
        finally {
            this.sharedLists.getReadWriteLock().writeLock().unlock();
        }
    }

    private void friendRemoved(SharedFileCollection collection, String friendId) {
        SharedFileListImpl list = this.getListForCollection(collection);
        int oldSize = list.getFriendIds().size();
        boolean removed = list.friendRemoved(friendId);
        if (oldSize == 1 && removed) {
            this.setListInPlace(collection);
        }
    }

    private void friendsSetInCollection(SharedFileCollection collection, Collection<String> newFriendIds) {
        SharedFileListImpl list = this.getListForCollection(collection);
        boolean wasEmpty = list.getFriendIds().isEmpty();
        list.friendsSet(newFriendIds);
        boolean isEmpty = newFriendIds.isEmpty();
        if (wasEmpty != isEmpty) {
            if (!isEmpty) {
                ++this.listsShared;
            }
            this.setListInPlace(collection);
        }
    }

    private void friendAddedToCollection(SharedFileCollection collection, String friendId) {
        SharedFileListImpl list = this.getListForCollection(collection);
        boolean wasEmpty = list.getFriendIds().isEmpty();
        list.friendAdded(friendId);
        if (wasEmpty) {
            ++this.listsShared;
            this.setListInPlace(collection);
        }
    }

    private void collectionAdded(SharedFileCollection collection) {
        SharedFileListImpl listImpl = new SharedFileListImpl(this.coreLocalFileItemFactory, collection);
        listImpl.friendsSet(collection.getFriendList());
        this.sharedLists.add(listImpl);
    }

    private void collectionRemoved(SharedFileCollection collection) {
        this.sharedLists.remove(this.getListForCollection(collection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedFileListImpl getListForCollection(SharedFileCollection collection) {
        this.sharedLists.getReadWriteLock().readLock().lock();
        try {
            for (SharedFileList list : this.sharedLists) {
                SharedFileListImpl impl = (SharedFileListImpl)list;
                if (impl.getCoreCollection() != collection) continue;
                SharedFileListImpl sharedFileListImpl = impl;
                return sharedFileListImpl;
            }
            SharedFileListImpl sharedFileListImpl = null;
            return sharedFileListImpl;
        }
        finally {
            this.sharedLists.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public int getSharedFileCount() {
        return this.allSharedFilesView.size();
    }

    @Override
    public int createNewSharedFileList(String name) {
        ++this.listsCreated;
        return this.collectionManager.createNewCollection(name).getId();
    }

    @Override
    public EventList<SharedFileList> getModel() {
        return this.readOnlySharedLists;
    }

    @Override
    public void deleteSharedFileList(SharedFileList fileList) {
        if (!(fileList instanceof SharedFileListImpl)) {
            throw new IllegalStateException("invalid FileList: " + fileList);
        }
        this.collectionManager.removeCollectionById(((SharedFileListImpl)fileList).getCoreCollection().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDocumentsFromPublicLists() {
        LibrarySettings.ALLOW_DOCUMENT_GNUTELLA_SHARING.setValue(false);
        EventList<SharedFileList> shareLists = this.getModel();
        shareLists.getReadWriteLock().readLock().lock();
        try {
            for (SharedFileList sharedFileList : shareLists) {
                if (!sharedFileList.isPublic()) continue;
                sharedFileList.removeFiles(new Predicate<LocalFileItem>(){

                    @Override
                    public boolean apply(LocalFileItem localFileItem) {
                        return localFileItem.getCategory() == Category.DOCUMENT;
                    }
                });
            }
        }
        finally {
            shareLists.getReadWriteLock().readLock().unlock();
        }
    }

    @InspectableContainer
    private final class LazyInspectableContainer {
        @InspectablePrimitive(value="number of shared lists", category=DataCategory.USAGE)
        private int sharedListCount = 0;
        @InspectablePrimitive(value="number of lists not shared", category=DataCategory.USAGE)
        private int unSharedListCount = 0;
        @InspectionPoint(value="number of lists with friends in multiple lists", category=DataCategory.USAGE)
        private final Inspectable multipleFriendLists = new Inspectable(){

            @Override
            public Object inspect() {
                HashMap listsPerFriend = new HashMap();
                for (int i = 1; i < SharedFileListManagerImpl.this.getModel().size(); ++i) {
                    if (((SharedFileList)SharedFileListManagerImpl.this.getModel().get(i)).getFriendIds().size() <= 0) continue;
                    for (String friendId : ((SharedFileList)SharedFileListManagerImpl.this.getModel().get(i)).getFriendIds()) {
                        if (listsPerFriend.get(friendId) == null) {
                            listsPerFriend.put(friendId, new ArrayList());
                        }
                        ((List)listsPerFriend.get(friendId)).add(SharedFileListManagerImpl.this.getModel().get(i));
                    }
                }
                HashSet set = new HashSet();
                for (List listsSharedWithFriend : listsPerFriend.values()) {
                    if (SharedFileListManagerImpl.this.sharedLists.size() <= 0) continue;
                    set.addAll(listsSharedWithFriend);
                }
                return set.size();
            }
        };
        @InspectionPoint(value="number of lists", category=DataCategory.USAGE)
        private final Inspectable numberOfLists = new Inspectable(){

            @Override
            public Object inspect() {
                return SharedFileListManagerImpl.this.getModel().size() - 1;
            }
        };
        @InspectionPoint(value="number of files in public shared list", category=DataCategory.USAGE)
        private final Inspectable numberOfFiles = new Inspectable(){

            @Override
            public Object inspect() {
                return ((SharedFileList)SharedFileListManagerImpl.this.getModel().get(0)).size();
            }
        };
        @InspectionPoint(value="number of files in private shared list", category=DataCategory.USAGE)
        private final Inspectable numberOfFilesInPrivateList = new Inspectable(){

            @Override
            public Object inspect() {
                if (SharedFileListManagerImpl.this.getModel().size() >= 2) {
                    return ((SharedFileList)SharedFileListManagerImpl.this.getModel().get(1)).size();
                }
                return 0;
            }
        };
        @InspectionPoint(value="number of people in private shared list", category=DataCategory.USAGE)
        private final Inspectable numberOfPeopleInPrivateList = new Inspectable(){

            @Override
            public Object inspect() {
                if (SharedFileListManagerImpl.this.getModel().size() >= 2) {
                    return ((SharedFileList)SharedFileListManagerImpl.this.getModel().get(1)).getFriendIds().size();
                }
                return 0;
            }
        };

        public LazyInspectableContainer() {
            this.initialize();
        }

        private void initialize() {
            for (int i = 1; i < SharedFileListManagerImpl.this.getModel().size(); ++i) {
                if (((SharedFileList)SharedFileListManagerImpl.this.getModel().get(i)).getFriendIds().size() > 0) {
                    ++this.sharedListCount;
                    continue;
                }
                ++this.unSharedListCount;
            }
        }
    }
}

