/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.mozilla;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.downloader.CoreDownloader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.core.api.mozilla.LimeMozillaDownloadManagerListener;
import org.limewire.core.api.mozilla.LimeMozillaDownloadProgressListener;
import org.limewire.core.impl.mozilla.LimeMozillaDownloadProgressListenerImpl;
import org.limewire.core.impl.mozilla.XPComUtility;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.Objects;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDownload;
import org.mozilla.interfaces.nsIDownloadManager;
import org.mozilla.interfaces.nsIDownloadProgressListener;
import org.mozilla.interfaces.nsIRequest;
import org.mozilla.interfaces.nsISimpleEnumerator;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIWebProgress;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

@Singleton
class LimeMozillaDownloadManagerListenerImpl
implements LimeMozillaDownloadManagerListener,
nsIDownloadProgressListener {
    private static final Log LOG = LogFactory.getLog(LimeMozillaDownloadManagerListenerImpl.class);
    public static final String NS_IDOWNLOADMANAGER_CID = "@mozilla.org/download-manager;1";
    private final Map<Long, LimeMozillaDownloadProgressListener> listeners;
    private final DownloadManager downloadManager;
    private final ScheduledExecutorService backgroundExecutor;
    private final XPComUtility xpComUtility;

    @Inject
    public LimeMozillaDownloadManagerListenerImpl(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, DownloadManager downloadManager, XPComUtility xpComUtility) {
        this.backgroundExecutor = Objects.nonNull(backgroundExecutor, "backgroundExecutor");
        this.downloadManager = Objects.nonNull(downloadManager, "downloadManager");
        this.xpComUtility = Objects.nonNull(xpComUtility, "xpComUtility");
        this.listeners = new HashMap<Long, LimeMozillaDownloadProgressListener>();
    }

    public synchronized void resumeDownloads() {
        nsIDownloadManager downloadManager = this.getDownloadManager();
        nsISimpleEnumerator enumerator = downloadManager.getActiveDownloads();
        while (enumerator.hasMoreElements()) {
            nsISupports elem = enumerator.getNext();
            nsIDownload download = this.xpComUtility.proxy(elem, nsIDownload.class);
            long downloadId = download.getId();
            try {
                downloadManager.resumeDownload(downloadId);
            }
            catch (XPCOMException e) {}
        }
    }

    public synchronized void addMissingDownloads() {
        nsIDownloadManager downloadManager = this.getDownloadManager();
        nsISimpleEnumerator enumerator = downloadManager.getActiveDownloads();
        while (enumerator.hasMoreElements()) {
            nsISupports elem = enumerator.getNext();
            nsIDownload download = this.xpComUtility.proxy(elem, nsIDownload.class);
            this.addListener(download, (short)5);
        }
    }

    private nsIDownloadManager getDownloadManager() {
        nsIDownloadManager downloadManager = this.xpComUtility.getServiceProxy(NS_IDOWNLOADMANAGER_CID, nsIDownloadManager.class);
        return downloadManager;
    }

    @Override
    public void onDownloadStateChange(short state, nsIDownload download) {
        this.addMissingDownloads();
    }

    private synchronized boolean addListener(nsIDownload download, short state) {
        long downloadId = download.getId();
        LimeMozillaDownloadProgressListener listener = this.listeners.get(downloadId);
        if (listener == null) {
            LimeMozillaDownloadProgressListenerImpl listenerImpl = new LimeMozillaDownloadProgressListenerImpl(this, this.backgroundExecutor, download, this.xpComUtility);
            this.listeners.put(download.getId(), listenerImpl);
            CoreDownloader downloader = (CoreDownloader)this.downloadManager.downloadFromMozilla(listenerImpl);
            listenerImpl.init(downloader, state);
            this.getDownloadManager().addListener(listenerImpl);
            return true;
        }
        return false;
    }

    @Override
    public void onProgressChange(nsIWebProgress webProgress, nsIRequest request, long curSelfProgress, long maxSelfProgress, long curTotalProgress, long maxTotalProgress, nsIDownload download) {
    }

    @Override
    public void onSecurityChange(nsIWebProgress webProgress, nsIRequest request, long state, nsIDownload download) {
    }

    @Override
    public void onStateChange(nsIWebProgress webProgress, nsIRequest request, long stateFlags, long status, nsIDownload download) {
        this.addMissingDownloads();
    }

    @Override
    public void setDocument(nsIDOMDocument document) {
    }

    @Override
    public nsIDOMDocument getDocument() {
        return null;
    }

    @Override
    public nsISupports queryInterface(String uuid) {
        return Mozilla.queryInterface(this, uuid);
    }

    @Override
    public synchronized void removeListener(final LimeMozillaDownloadProgressListener limeMozillaDownloadProgressListener) {
        MozillaExecutor.mozSyncExec(new Runnable(){

            @Override
            public void run() {
                nsIDownloadManager downloadManager = LimeMozillaDownloadManagerListenerImpl.this.getDownloadManager();
                try {
                    long downloadId = limeMozillaDownloadProgressListener.getDownloadId();
                    downloadManager.removeDownload(downloadId);
                }
                catch (XPCOMException e) {
                    LOG.debug(e.getMessage(), e);
                }
                LimeMozillaDownloadManagerListenerImpl.this.listeners.remove(limeMozillaDownloadProgressListener);
            }
        });
    }
}

