/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.upload;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.limegroup.bittorrent.BTUploader;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.uploader.UploadType;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.limewire.core.api.Category;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.endpoint.RemoteHost;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.transfer.SourceInfo;
import org.limewire.core.api.upload.UploadItem;
import org.limewire.core.api.upload.UploadPropertyKey;
import org.limewire.core.api.upload.UploadState;
import org.limewire.core.impl.util.FilePropertyKeyPopulator;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.feature.LimewireFeature;
import org.limewire.listener.SwingSafePropertyChangeSupport;
import org.limewire.util.FileUtils;

class CoreUploadItem
implements UploadItem {
    private final Uploader uploader;
    private final FriendPresence friendPresence;
    private final PropertyChangeSupport support = new SwingSafePropertyChangeSupport(this);
    private final CategoryManager categoryManager;
    public static final long UNKNOWN_TIME = Long.MAX_VALUE;
    private final UploadItem.UploadItemType uploadItemType;
    private boolean isFinished = false;
    private UploadRemoteHost uploadRemoteHost;
    private final long startTime;
    private volatile long totalAmountUploaded;
    private volatile float uploadSpeed;

    @Inject
    CoreUploadItem(@Assisted Uploader uploader, @Assisted FriendPresence friendPresence, CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
        this.uploader = uploader;
        this.friendPresence = friendPresence;
        this.uploadItemType = uploader instanceof BTUploader ? UploadItem.UploadItemType.BITTORRENT : UploadItem.UploadItemType.GNUTELLA;
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void cancel() {
        this.uploader.stop();
        this.fireDataChanged();
    }

    @Override
    public String getFileName() {
        return this.uploader.getFileName();
    }

    @Override
    public long getFileSize() {
        return this.uploader.getFileSize();
    }

    Uploader getUploader() {
        return this.uploader;
    }

    @Override
    public UploadState getState() {
        switch (this.getUploaderStatus()) {
            case CANCELLED: {
                return UploadState.CANCELED;
            }
            case COMPLETE: {
                if (this.uploader.getUploadType() == UploadType.BROWSE_HOST) {
                    return UploadState.BROWSE_HOST_DONE;
                }
                return UploadState.DONE;
            }
            case CONNECTING: 
            case UPLOADING: 
            case THEX_REQUEST: 
            case PUSH_PROXY: 
            case UPDATE_FILE: {
                return UploadState.UPLOADING;
            }
            case QUEUED: {
                return UploadState.QUEUED;
            }
            case PAUSED: {
                return UploadState.PAUSED;
            }
            case INTERRUPTED: 
            case FILE_NOT_FOUND: 
            case UNAVAILABLE_RANGE: 
            case MALFORMED_REQUEST: {
                return UploadState.REQUEST_ERROR;
            }
            case LIMIT_REACHED: 
            case BANNED_GREEDY: 
            case FREELOADER: {
                return UploadState.LIMIT_REACHED;
            }
            case BROWSE_HOST: {
                return UploadState.BROWSE_HOST;
            }
        }
        throw new IllegalStateException("Unknown Upload status : " + (Object)((Object)this.uploader.getState()));
    }

    private Uploader.UploadStatus getUploaderStatus() {
        Uploader.UploadStatus state = this.uploader.getState();
        Uploader.UploadStatus lastState = this.uploader.getLastTransferState();
        if (state == Uploader.UploadStatus.COMPLETE && !this.isFinished) {
            state = lastState;
        }
        if (this.uploader.getUploadType() != UploadType.BROWSE_HOST && state == Uploader.UploadStatus.COMPLETE && lastState != Uploader.UploadStatus.UPLOADING && lastState != Uploader.UploadStatus.QUEUED && lastState != Uploader.UploadStatus.THEX_REQUEST) {
            state = lastState;
        }
        return state;
    }

    @Override
    public long getTotalAmountUploaded() {
        return this.totalAmountUploaded;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uploader == null ? 0 : this.uploader.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoreUploadItem other = (CoreUploadItem)obj;
        return !(this.uploader == null ? other.uploader != null : !this.uploader.equals(other.uploader));
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    void fireDataChanged() {
        this.support.firePropertyChange("state", null, (Object)this.getState());
    }

    void refresh() {
        this.totalAmountUploaded = this.uploader.getTotalAmountUploaded();
        try {
            this.uploadSpeed = this.uploader.getMeasuredBandwidth();
        }
        catch (InsufficientDataException e) {
            this.uploadSpeed = 0.0f;
        }
        this.fireDataChanged();
    }

    @Override
    public Category getCategory() {
        return this.categoryManager.getCategoryForFilename(this.getFileName());
    }

    @Override
    public RemoteHost getRemoteHost() {
        if (this.uploadRemoteHost == null) {
            this.uploadRemoteHost = new UploadRemoteHost();
        }
        return this.uploadRemoteHost;
    }

    @Override
    public UploadItem.BrowseType getBrowseType() {
        if (this.getState() != UploadState.BROWSE_HOST && this.getState() != UploadState.BROWSE_HOST_DONE) {
            return UploadItem.BrowseType.NONE;
        }
        if ("".equals(this.getFileName())) {
            return UploadItem.BrowseType.P2P;
        }
        return UploadItem.BrowseType.FRIEND;
    }

    public String toString() {
        return "CoreUploadItem: " + this.getFileName() + ", " + (Object)((Object)this.getState());
    }

    @Override
    public int getQueuePosition() {
        return this.uploader.getQueuePosition();
    }

    @Override
    public float getUploadSpeed() {
        return this.uploadSpeed;
    }

    @Override
    public long getRemainingUploadTime() {
        float speed = this.getUploadSpeed();
        if (speed > 0.0f) {
            double remaining = (double)(this.getFileSize() - this.getTotalAmountUploaded()) / 1024.0;
            return (long)(remaining / (double)speed);
        }
        return Long.MAX_VALUE;
    }

    @Override
    public Object getProperty(FilePropertyKey property) {
        FileDesc fd = this.uploader.getFileDesc();
        if (fd != null) {
            switch (property) {
                case NAME: {
                    return FileUtils.getFilenameNoExtension(fd.getFileName());
                }
                case DATE_CREATED: {
                    long ct = fd.lastModified();
                    return ct == -1L ? null : Long.valueOf(ct);
                }
                case FILE_SIZE: {
                    return fd.getFileSize();
                }
            }
            Category category = this.categoryManager.getCategoryForFilename(fd.getFileName());
            return FilePropertyKeyPopulator.get(category, property, fd.getXMLDocument());
        }
        return null;
    }

    @Override
    public String getPropertyString(FilePropertyKey key) {
        Object value = this.getProperty(key);
        if (value != null) {
            String stringValue = value.toString();
            return stringValue;
        }
        return null;
    }

    @Override
    public org.limewire.core.api.URN getUrn() {
        URN urn = this.uploader.getUrn();
        if (urn != null) {
            return urn;
        }
        return null;
    }

    @Override
    public Collection<File> getCompleteFiles() {
        ArrayList<File> files = new ArrayList<File>();
        if (this.uploader instanceof BTUploader) {
            BTUploader btUploader = (BTUploader)this.uploader;
            files.addAll(btUploader.getCompleteFiles());
        } else {
            files.add(this.uploader.getFile());
        }
        return files;
    }

    @Override
    public File getFile() {
        return this.uploader.getFile();
    }

    @Override
    public String getRenderName() {
        return this.friendPresence.getFriend().getRenderName();
    }

    @Override
    public UploadItem.UploadItemType getUploadItemType() {
        return this.uploadItemType;
    }

    @Override
    public int getNumUploadConnections() {
        return this.uploader.getNumUploadConnections();
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    void finish() {
        this.isFinished = true;
        this.fireDataChanged();
    }

    @Override
    public float getSeedRatio() {
        return this.uploader.getSeedRatio();
    }

    @Override
    public boolean isFinished() {
        if (this.uploader instanceof BTUploader) {
            return ((BTUploader)this.uploader).getTorrent().isFinished();
        }
        UploadState state = this.getState();
        return state == UploadState.DONE || state == UploadState.BROWSE_HOST_DONE;
    }

    @Override
    public boolean isStarted() {
        if (this.uploader instanceof BTUploader) {
            return ((BTUploader)this.uploader).getTorrent().isStarted();
        }
        return true;
    }

    @Override
    public void pause() {
        this.uploader.pause();
    }

    @Override
    public void resume() {
        this.uploader.resume();
    }

    @Override
    public Object getUploadProperty(UploadPropertyKey key) {
        if (key == UploadPropertyKey.TORRENT && UploadItem.UploadItemType.BITTORRENT == this.uploadItemType) {
            BTUploader btUploader = (BTUploader)this.uploader;
            return btUploader.getTorrent();
        }
        return null;
    }

    @Override
    public List<SourceInfo> getTransferDetails() {
        return this.uploader.getTransferDetails();
    }

    private class UploadRemoteHost
    implements RemoteHost {
        private UploadRemoteHost() {
        }

        @Override
        public FriendPresence getFriendPresence() {
            return CoreUploadItem.this.friendPresence;
        }

        @Override
        public boolean isBrowseHostEnabled() {
            if (CoreUploadItem.this.friendPresence.getFriend().isAnonymous()) {
                return CoreUploadItem.this.uploader.isBrowseHostEnabled();
            }
            return CoreUploadItem.this.friendPresence.hasFeatures(LimewireFeature.ID);
        }

        @Override
        public boolean isChatEnabled() {
            if (CoreUploadItem.this.friendPresence.getFriend().isAnonymous()) {
                return false;
            }
            return CoreUploadItem.this.friendPresence.hasFeatures(LimewireFeature.ID);
        }

        @Override
        public boolean isSharingEnabled() {
            if (CoreUploadItem.this.friendPresence.getFriend().isAnonymous()) {
                return false;
            }
            return CoreUploadItem.this.friendPresence.hasFeatures(LimewireFeature.ID);
        }
    }

    static interface Factory {
        public CoreUploadItem create(@Assisted Uploader var1, @Assisted FriendPresence var2);
    }
}

