/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.friend.impl.feature;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.limewire.friend.api.feature.FeatureInitializer;
import org.limewire.friend.api.feature.FeatureRegistry;

@Singleton
class FeatureRegistryImpl
implements FeatureRegistry {
    private final Object lock = new Object();
    private final Map<URI, FeatureInitializer> featureInitializers = new HashMap<URI, FeatureInitializer>();
    private final Set<URI> publicFeatureUris = new HashSet<URI>();

    @Inject
    FeatureRegistryImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureInitializer get(URI uri) {
        Object object = this.lock;
        synchronized (object) {
            return this.featureInitializers.get(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<URI> getPublicFeatureUris() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<URI>(this.publicFeatureUris);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<URI> getAllFeatureUris() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<URI>(this.featureInitializers.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPrivateInitializer(URI uri, FeatureInitializer featureInitializer) {
        Object object = this.lock;
        synchronized (object) {
            this.featureInitializers.put(uri, featureInitializer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPublicInitializer(URI uri, FeatureInitializer featureInitializer) {
        Object object = this.lock;
        synchronized (object) {
            this.featureInitializers.put(uri, featureInitializer);
            this.publicFeatureUris.add(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterInitializer(URI uri) {
        Object object = this.lock;
        synchronized (object) {
            this.featureInitializers.remove(uri);
            this.publicFeatureUris.remove(uri);
        }
    }
}

