/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.friend.impl.util;

public class PresenceUtils {
    private static final char[] QUOTE_ENCODE = "&quot;".toCharArray();
    private static final char[] AMP_ENCODE = "&amp;".toCharArray();
    private static final char[] LT_ENCODE = "&lt;".toCharArray();
    private static final char[] GT_ENCODE = "&gt;".toCharArray();

    public static String parseResource(String XMPPAddress) {
        if (XMPPAddress == null) {
            return null;
        }
        int slashIndex = XMPPAddress.indexOf("/");
        if (slashIndex + 1 > XMPPAddress.length() || slashIndex < 0) {
            return "";
        }
        return XMPPAddress.substring(slashIndex + 1);
    }

    public static String parseBareAddress(String XMPPAddress) {
        if (XMPPAddress == null) {
            return null;
        }
        int slashIndex = XMPPAddress.indexOf("/");
        if (slashIndex < 0) {
            return XMPPAddress;
        }
        if (slashIndex == 0) {
            return "";
        }
        return XMPPAddress.substring(0, slashIndex);
    }

    public static String escapeForXML(String string) {
        int i;
        if (string == null) {
            return null;
        }
        int last = 0;
        char[] input = string.toCharArray();
        int len = input.length;
        StringBuilder out = new StringBuilder((int)((double)len * 1.3));
        for (i = 0; i < len; ++i) {
            char ch = input[i];
            if (ch > '>') continue;
            if (ch == '<') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(LT_ENCODE);
                continue;
            }
            if (ch == '>') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(GT_ENCODE);
                continue;
            }
            if (ch == '&') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                if (len > i + 5 && input[i + 1] == '#' && Character.isDigit(input[i + 2]) && Character.isDigit(input[i + 3]) && Character.isDigit(input[i + 4]) && input[i + 5] == ';') continue;
                last = i + 1;
                out.append(AMP_ENCODE);
                continue;
            }
            if (ch != '\"') continue;
            if (i > last) {
                out.append(input, last, i - last);
            }
            last = i + 1;
            out.append(QUOTE_ENCODE);
        }
        if (last == 0) {
            return string;
        }
        if (i > last) {
            out.append(input, last, i - last);
        }
        return out.toString();
    }

    private PresenceUtils() {
    }
}

