/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.inject;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.spi.BindingScopingVisitor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicReference;
import org.limewire.inject.MoreScopes;

public class LazyBinder<T>
implements Provider<T> {
    private final AtomicReference<T> providee = new AtomicReference();
    private final Class<T> expected;
    private final Class<? extends T> implClass;
    private Injector injector;

    public static <T> Provider<T> newLazyProvider(Class<T> expected, Class<? extends T> implClass) {
        if (!expected.isInterface()) {
            throw new RuntimeException("Expected class must be an interface");
        }
        return new LazyBinder<T>(expected, implClass);
    }

    private LazyBinder(Class<T> expected, Class<? extends T> implClass) {
        this.expected = expected;
        this.implClass = implClass;
    }

    @Inject
    private void registerAndCheckTypes(Injector injector) {
        this.injector = injector;
        injector.getBinding(this.implClass).acceptScopingVisitor(new BindingScopingVisitor<Void>(){

            @Override
            public Void visitEagerSingleton() {
                return null;
            }

            @Override
            public Void visitNoScoping() {
                throw new RuntimeException("Class: " + LazyBinder.this.implClass + " must be in scope @Singleton or @LazySingleton or @EagerSingleton");
            }

            @Override
            public Void visitScope(Scope scope) {
                if (scope != Scopes.SINGLETON && scope != MoreScopes.LAZY_SINGLETON && scope != MoreScopes.EAGER_SINGLETON) {
                    throw new RuntimeException("Class: " + LazyBinder.this.implClass + " must be in scope @Singleton or @LazySingleton or @EagerSingleton");
                }
                return null;
            }

            @Override
            public Void visitScopeAnnotation(Class<? extends Annotation> scopeAnnotation) {
                throw new RuntimeException("Wasn't expecting this");
            }
        });
    }

    @Override
    public T get() {
        T got = this.providee.get();
        if (got != null) {
            return got;
        }
        this.providee.compareAndSet(null, LazyBinder.createProxy(this.expected, this.injector.getProvider(this.implClass)));
        return this.providee.get();
    }

    private static <T> T createProxy(Class<T> expected, final Provider<? extends T> provider) {
        ClassLoader classLoader = expected.getClassLoader();
        return expected.cast(Proxy.newProxyInstance(classLoader, new Class[]{expected}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return method.invoke(provider.get(), args);
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }
        }));
    }
}

