/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.inspection;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.ExposedBinding;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.UntargettedBinding;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.limewire.inject.MoreScopes;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectableForSize;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.inspection.InspectionException;
import org.limewire.inspection.InspectionPoint;
import org.limewire.inspection.InspectionRequirement;
import org.limewire.util.OSUtils;

public class InspectionUtils {
    public static Object inspectValue(String encodedField, Injector injector, boolean collectUsageData) throws InspectionException {
        try {
            InspectionData data = InspectionUtils.createInspectionData(encodedField);
            InspectionUtils.validateField(data, collectUsageData);
            InspectionUtils.setFieldContainerInstance(data, injector);
            InspectionUtils.setFieldValue(data);
            return InspectionUtils.inspect(data);
        }
        catch (Throwable e) {
            if (e instanceof InspectionException) {
                throw (InspectionException)e;
            }
            throw new InspectionException(e);
        }
    }

    private static InspectionData createInspectionData(String encodedField) throws Throwable {
        InspectionData data = encodedField.contains(":") ? InspectionUtils.getStaticField(encodedField) : InspectionUtils.getInjectedField(encodedField);
        data.annotations = Arrays.asList(data.field.getAnnotations());
        return data;
    }

    private static InspectionData getStaticField(String encodedField) throws Throwable {
        StringTokenizer t = new StringTokenizer(encodedField, ":");
        if (t.countTokens() != 2) {
            throw new InspectionException("invalid encoded field: " + encodedField);
        }
        Class<?> clazz = Class.forName(t.nextToken());
        Field field = clazz.getDeclaredField(t.nextToken());
        field.setAccessible(true);
        InspectionData data = new InspectionData();
        data.isStatic = true;
        data.fieldValue = clazz;
        data.field = field;
        return data;
    }

    private static InspectionData getInjectedField(String encodedField) throws Throwable {
        StringTokenizer t;
        InspectionData data = new InspectionData();
        Class<?> lookupClass = null;
        if (encodedField.contains("|")) {
            StringTokenizer tokenizer = new StringTokenizer(encodedField, "|");
            if (tokenizer.countTokens() != 2) {
                throw new InspectionException("invalid encoded field: " + encodedField);
            }
            lookupClass = Class.forName(tokenizer.nextToken());
            encodedField = tokenizer.nextToken();
        }
        if ((t = new StringTokenizer(encodedField, ",")).countTokens() != 2) {
            throw new InspectionException("invalid encoded field: " + encodedField);
        }
        Class<?> clazz = Class.forName(t.nextToken());
        Field field = clazz.getDeclaredField(t.nextToken());
        field.setAccessible(true);
        data.lookupClass = lookupClass;
        data.actualClass = clazz;
        data.field = field;
        return data;
    }

    private static void validateField(InspectionData data, boolean collectUsageData) throws InspectionException {
        boolean valid = false;
        for (Annotation annotation : data.annotations) {
            if (annotation.annotationType() == InspectionPoint.class) {
                InspectionUtils.validateLimitations(((InspectionPoint)annotation).requires(), ((InspectionPoint)annotation).category(), data, collectUsageData);
                valid = true;
                break;
            }
            if (annotation.annotationType() == InspectablePrimitive.class) {
                InspectionUtils.validateLimitations(((InspectablePrimitive)annotation).requires(), ((InspectablePrimitive)annotation).category(), data, collectUsageData);
                valid = true;
                break;
            }
            if (annotation.annotationType() != InspectableForSize.class) continue;
            InspectionUtils.validateLimitations(((InspectableForSize)annotation).requires(), ((InspectableForSize)annotation).category(), data, collectUsageData);
            valid = true;
            break;
        }
        if (!valid) {
            throw new InspectionException("field not annotated for inspection: " + data.field);
        }
    }

    private static void validateLimitations(InspectionRequirement[] limitations, DataCategory category, InspectionData data, boolean collectUsageData) throws InspectionException {
        InspectionUtils.validateOSLimitations(limitations, data);
        InspectionUtils.validateDataCategoryLimitations(category, data, collectUsageData);
    }

    private static void validateDataCategoryLimitations(DataCategory category, InspectionData data, boolean collectUsageData) throws InspectionException {
        if (category == DataCategory.USAGE && !collectUsageData) {
            throw new InspectionException("field " + data.field + " is usage data, but usage data collection not allowed");
        }
    }

    private static void validateOSLimitations(InspectionRequirement[] limitations, InspectionData data) throws InspectionException {
        boolean valid = false;
        if (limitations != null && limitations.length > 0) {
            block5: for (InspectionRequirement limitation : limitations) {
                switch (limitation) {
                    case OS_LINUX: {
                        valid |= OSUtils.isLinux();
                        continue block5;
                    }
                    case OS_OSX: {
                        valid |= OSUtils.isMacOSX();
                        continue block5;
                    }
                    case OS_WINDOWS: {
                        valid |= OSUtils.isWindows();
                    }
                }
            }
        } else {
            valid = true;
        }
        if (!valid) {
            List<InspectionRequirement> requires = Arrays.asList(limitations);
            throw new InspectionException("invalid limitations: " + requires + " on field: " + data.field, requires);
        }
    }

    private static void setFieldContainerInstance(InspectionData data, Injector injector) throws Throwable {
        if (!data.isStatic) {
            if (data.lookupClass == null && data.actualClass.getEnclosingClass() != null && !Modifier.isStatic(data.actualClass.getModifiers())) {
                data.lookupClass = data.actualClass.getEnclosingClass();
            }
            if (data.lookupClass == null) {
                if (!injector.getAllBindings().containsKey(Key.get(data.actualClass))) {
                    throw new InspectionException("no existing binding for class: " + data.actualClass);
                }
                Binding<?> binding = injector.getBinding(data.actualClass);
                InspectionUtils.validateBindingIsSingleton(injector, binding);
                data.fieldContainerInstance = binding.getProvider().get();
            } else {
                if (!injector.getAllBindings().containsKey(Key.get(data.lookupClass))) {
                    throw new InspectionException("no existing binding for class: " + data.lookupClass);
                }
                Binding<?> binding = injector.getBinding(data.lookupClass);
                InspectionUtils.validateBindingIsSingleton(injector, binding);
                Object lookupObj = binding.getProvider().get();
                if (data.actualClass.getEnclosingClass() != null && !Modifier.isStatic(data.actualClass.getModifiers())) {
                    if (data.actualClass.getAnnotation(InspectableContainer.class) == null) {
                        throw new InspectionException("container must be annotated with InspectableContainer");
                    }
                    Constructor<?>[] constructors = data.actualClass.getDeclaredConstructors();
                    if (constructors.length != 1) {
                        throw new InspectionException("wrong constructors length: " + constructors.length);
                    }
                    Class<?>[] parameters = constructors[0].getParameterTypes();
                    if (parameters.length != 1 || !data.lookupClass.isAssignableFrom(parameters[0])) {
                        throw new InspectionException("wrong parameter count or type for constructor");
                    }
                    constructors[0].setAccessible(true);
                    data.fieldContainerInstance = constructors[0].newInstance(lookupObj);
                } else {
                    data.fieldContainerInstance = lookupObj;
                }
            }
        }
    }

    private static void setFieldValue(InspectionData data) throws Throwable {
        data.fieldValue = data.isStatic ? data.field.get(null) : data.field.get(data.fieldContainerInstance);
    }

    private static void validateBindingIsSingleton(Injector injector, Binding<?> binding) throws InspectionException {
        boolean singleton = (binding = InspectionUtils.resolveBinding(injector, binding)).acceptScopingVisitor(new BindingScopingVisitor<Boolean>(){

            @Override
            public Boolean visitEagerSingleton() {
                return true;
            }

            @Override
            public Boolean visitNoScoping() {
                return false;
            }

            @Override
            public Boolean visitScope(Scope scope) {
                return scope == Scopes.SINGLETON || scope == MoreScopes.LAZY_SINGLETON || scope == MoreScopes.EAGER_SINGLETON;
            }

            @Override
            public Boolean visitScopeAnnotation(Class<? extends Annotation> scopeAnnotation) {
                return false;
            }
        });
        if (!singleton) {
            throw new InspectionException("must be singleton or lazysingleton or eagerSingleton annotation or be interface!");
        }
    }

    private static Binding<?> resolveBinding(Injector injector, Binding<?> binding) {
        Binding resolved;
        while ((resolved = (Binding)binding.acceptTargetVisitor(new Resolver(injector, binding))) != binding) {
            binding = resolved;
        }
        return binding;
    }

    private static Object inspect(InspectionData data) throws Exception {
        if (data.fieldValue instanceof Inspectable) {
            Inspectable i = (Inspectable)data.fieldValue;
            return i.inspect();
        }
        for (Annotation a : data.annotations) {
            if (a instanceof InspectablePrimitive) {
                return String.valueOf(data.fieldValue);
            }
            if (!(a instanceof InspectableForSize)) continue;
            Method m = data.fieldValue.getClass().getMethod("size", new Class[0]);
            m.setAccessible(true);
            return m.invoke(data.fieldValue, new Object[0]).toString();
        }
        throw new InspectionException("no valid Inspectable annotation!");
    }

    private static class Resolver
    implements BindingTargetVisitor<Object, Binding<?>> {
        private final Binding<?> binding;
        private final Injector injector;

        Resolver(Injector injector, Binding<?> binding) {
            this.binding = binding;
            this.injector = injector;
        }

        @Override
        public Binding<?> visit(InstanceBinding<? extends Object> link) {
            return this.binding;
        }

        @Override
        public Binding<?> visit(ProviderInstanceBinding<? extends Object> link) {
            return this.binding;
        }

        @Override
        public Binding<?> visit(ProviderKeyBinding<? extends Object> link) {
            return this.injector.getBinding(link.getProviderKey());
        }

        @Override
        public Binding<?> visit(LinkedKeyBinding<? extends Object> link) {
            return this.injector.getBinding(link.getLinkedKey());
        }

        @Override
        public Binding<?> visit(ExposedBinding<? extends Object> link) {
            return this.binding;
        }

        @Override
        public Binding<?> visit(UntargettedBinding<? extends Object> link) {
            return this.binding;
        }

        @Override
        public Binding<?> visit(ConstructorBinding<? extends Object> link) {
            return this.binding;
        }

        @Override
        public Binding<?> visit(ConvertedConstantBinding<? extends Object> link) {
            return this.binding;
        }

        @Override
        public Binding<?> visit(ProviderBinding<? extends Object> link) {
            return this.injector.getBinding(link.getProvidedKey());
        }
    }

    private static class InspectionData {
        boolean isStatic;
        Field field;
        List<Annotation> annotations;
        Class<?> lookupClass;
        Class<?> actualClass;
        Object fieldContainerInstance;
        Object fieldValue;

        private InspectionData() {
        }
    }
}

