/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.libtorrent;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.limewire.bittorrent.ProxySetting;
import org.limewire.bittorrent.Torrent;
import org.limewire.bittorrent.TorrentEvent;
import org.limewire.bittorrent.TorrentEventType;
import org.limewire.bittorrent.TorrentException;
import org.limewire.bittorrent.TorrentIpFilter;
import org.limewire.bittorrent.TorrentIpPort;
import org.limewire.bittorrent.TorrentManager;
import org.limewire.bittorrent.TorrentManagerSettings;
import org.limewire.bittorrent.TorrentParams;
import org.limewire.bittorrent.TorrentSettingsAnnotation;
import org.limewire.inject.LazySingleton;
import org.limewire.libtorrent.IpFilterCallback;
import org.limewire.libtorrent.LibTorrentAlert;
import org.limewire.libtorrent.LibTorrentProxySetting;
import org.limewire.libtorrent.LibTorrentStatus;
import org.limewire.libtorrent.LibTorrentWrapper;
import org.limewire.libtorrent.TorrentImpl;
import org.limewire.libtorrent.callback.AlertCallback;
import org.limewire.listener.EventListener;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

@LazySingleton
public class LibTorrentSession
implements TorrentManager {
    private static final Log LOG = LogFactory.getLog(LibTorrentSession.class);
    private final ScheduledExecutorService fastExecutor;
    private final LibTorrentWrapper libTorrent;
    private final Map<String, Torrent> torrents;
    private final BasicAlertCallback alertCallback = new BasicAlertCallback();
    private IpFilterCallback ipFilterCallback;
    private final AtomicReference<TorrentManagerSettings> torrentSettings = new AtomicReference<Object>(null);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean dhtStarted = new AtomicBoolean(false);
    private final AtomicBoolean upnpStarted = new AtomicBoolean(false);
    private final EventListener<TorrentEvent> torrentListener = new EventListener<TorrentEvent>(){

        @Override
        public void handleEvent(TorrentEvent event) {
            LibTorrentSession.this.handleTorrentEvent(event);
        }
    };
    private final Lock lock = new ReentrantLock();
    private final List<ScheduledFuture<?>> torrentManagerTasks;

    @Inject
    public LibTorrentSession(LibTorrentWrapper torrentWrapper, @Named(value="fastExecutor") ScheduledExecutorService fastExecutor, @TorrentSettingsAnnotation TorrentManagerSettings torrentSettings) {
        this.fastExecutor = fastExecutor;
        this.libTorrent = torrentWrapper;
        this.torrents = new HashMap<String, Torrent>();
        this.torrentSettings.set(torrentSettings);
        this.torrentManagerTasks = new ArrayList();
    }

    private void validateLibrary() {
        if (!this.initialized.get()) {
            throw new TorrentException("The Torrent Manager must be initialized first.", -100002);
        }
        if (!this.torrentSettings.get().isTorrentsEnabled()) {
            throw new TorrentException("LibTorrent is disabled (through settings)", -100001);
        }
        if (!this.isValid()) {
            throw new TorrentException("There was a problem loading LibTorrent", -100000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Torrent addTorrent(TorrentParams params) throws IOException {
        assert (this.started.get());
        this.lock.lock();
        try {
            this.validateLibrary();
            File torrentFile = params.getTorrentFile();
            File fastResumefile = params.getFastResumeFile();
            String trackerURI = params.getTrackerURL() != null ? params.getTrackerURL() : "";
            String fastResumePath = fastResumefile != null ? fastResumefile.getAbsolutePath() : null;
            String torrentPath = torrentFile != null ? torrentFile.getAbsolutePath() : "";
            String saveDirectory = params.getDownloadFolder().getAbsolutePath();
            String sha1 = params.getSha1();
            TorrentImpl torrent = new TorrentImpl(params, this.libTorrent, this.fastExecutor);
            this.libTorrent.add_torrent(sha1, trackerURI, torrentPath, saveDirectory, fastResumePath);
            this.updateStatus(torrent);
            this.torrents.put(sha1, torrent);
            torrent.addListener(this.torrentListener);
            TorrentImpl torrentImpl = torrent;
            return torrentImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isValid() {
        return this.libTorrent.isLoaded();
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTorrent(Torrent torrent) {
        this.validateLibrary();
        this.lock.lock();
        try {
            torrent.removeListener(this.torrentListener);
            this.torrents.remove(torrent.getSha1());
            this.libTorrent.remove_torrent(torrent.getSha1());
        }
        finally {
            this.lock.unlock();
        }
    }

    private LibTorrentStatus getStatus(Torrent torrent) {
        this.validateLibrary();
        LibTorrentStatus status = new LibTorrentStatus();
        String sha1 = torrent.getSha1();
        this.libTorrent.get_torrent_status(sha1, status);
        this.libTorrent.free_torrent_status(status);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus(Torrent torrent) {
        this.lock.lock();
        try {
            LibTorrentStatus torrentStatus = this.getStatus(torrent);
            torrent.updateStatus(torrentStatus);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void handleTorrentEvent(TorrentEvent event) {
        if (event.getType() == TorrentEventType.STOPPED) {
            this.removeTorrent(event.getTorrent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        if (!this.initialized.getAndSet(true) && this.torrentSettings.get().isTorrentsEnabled()) {
            this.lock.lock();
            try {
                this.libTorrent.initialize(this.torrentSettings.get());
                if (this.libTorrent.isLoaded()) {
                    this.setTorrentManagerSettings(this.torrentSettings.get());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIpFilter(TorrentIpFilter ipFilter) {
        this.lock.lock();
        try {
            IpFilterCallback ipFilterCallback = new IpFilterCallback(ipFilter);
            this.libTorrent.set_ip_filter(ipFilterCallback);
            this.ipFilterCallback = ipFilterCallback;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        this.lock.lock();
        try {
            ScheduledFuture<?> scheduledFuture = this.fastExecutor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
            this.torrentManagerTasks.add(scheduledFuture);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        assert (!this.started.get());
        this.started.set(true);
        if (this.isValid()) {
            this.lock.lock();
            try {
                this.scheduleWithFixedDelay(new AlertPoller(), 1000L, 500L, TimeUnit.MILLISECONDS);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.lock.lock();
        try {
            for (ScheduledFuture<?> scheduledFuture : this.torrentManagerTasks) {
                scheduledFuture.cancel(true);
            }
            if (this.isValid()) {
                this.libTorrent.freeze_and_save_all_fast_resume_data(this.alertCallback);
                if (this.isDHTStarted()) {
                    this.libTorrent.save_dht_state(this.torrentSettings.get().getDHTStateFile());
                }
                this.libTorrent.abort_torrents();
            }
            this.torrents.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Torrent getTorrent(File torrentFile) {
        if (torrentFile != null) {
            this.lock.lock();
            try {
                for (Torrent torrent : this.torrents.values()) {
                    if (!torrentFile.equals(torrent.getTorrentFile())) continue;
                    Torrent torrent2 = torrent;
                    return torrent2;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Torrent getTorrent(String sha1) {
        this.lock.lock();
        try {
            Torrent torrent = this.torrents.get(sha1);
            return torrent;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDownloadingTorrent(File torrentFile) {
        if (torrentFile != null) {
            this.lock.lock();
            try {
                for (Torrent torrent : this.torrents.values()) {
                    if (!torrentFile.equals(torrent.getTorrentFile()) || torrent.isFinished()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTorrentManagerSettings(TorrentManagerSettings settings) {
        this.validateLibrary();
        this.lock.lock();
        try {
            this.torrentSettings.set(settings);
            this.libTorrent.update_settings(settings);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public TorrentManagerSettings getTorrentManagerSettings() {
        return this.torrentSettings.get();
    }

    @Override
    public boolean isInitialized() {
        return this.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Torrent> getTorrents() {
        this.lock.lock();
        try {
            ArrayList<Torrent> arrayList = new ArrayList<Torrent>(this.torrents.values());
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isDHTStarted() {
        return this.dhtStarted.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startDHT(File dhtStateFile) {
        this.validateLibrary();
        this.lock.lock();
        try {
            this.libTorrent.start_dht(dhtStateFile);
            this.addDHTRouters();
            this.dhtStarted.set(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addDHTRouters() {
        for (TorrentIpPort ipPort : this.getTorrentManagerSettings().getBootStrapDHTRouters()) {
            this.libTorrent.add_dht_router(ipPort.getAddress(), ipPort.getPort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopDHT() {
        this.validateLibrary();
        this.lock.lock();
        try {
            this.libTorrent.stop_dht();
            this.dhtStarted.set(false);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveDHTState(File dhtStateFile) {
        if (this.dhtStarted.get()) {
            this.validateLibrary();
            this.lock.lock();
            try {
                this.libTorrent.save_dht_state(dhtStateFile);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public boolean isUPnPStarted() {
        return this.upnpStarted.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startUPnP() {
        this.validateLibrary();
        this.lock.lock();
        try {
            this.libTorrent.start_upnp();
            this.libTorrent.start_natpmp();
            this.upnpStarted.set(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopUPnP() {
        this.validateLibrary();
        this.lock.lock();
        try {
            this.libTorrent.stop_upnp();
            this.libTorrent.stop_natpmp();
            this.upnpStarted.set(false);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPeerProxy(ProxySetting proxy) {
        this.validateLibrary();
        LibTorrentProxySetting proxySetting = null;
        proxySetting = proxy != null ? new LibTorrentProxySetting(proxy) : LibTorrentProxySetting.nullProxy();
        this.lock.lock();
        try {
            this.libTorrent.set_peer_proxy(proxySetting);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDHTProxy(ProxySetting proxy) {
        this.validateLibrary();
        LibTorrentProxySetting proxySetting = null;
        proxySetting = proxy != null ? new LibTorrentProxySetting(proxy) : LibTorrentProxySetting.nullProxy();
        this.lock.lock();
        try {
            this.libTorrent.set_dht_proxy(proxySetting);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTrackerProxy(ProxySetting proxy) {
        this.validateLibrary();
        LibTorrentProxySetting proxySetting = null;
        proxySetting = proxy != null ? new LibTorrentProxySetting(proxy) : LibTorrentProxySetting.nullProxy();
        this.lock.lock();
        try {
            this.libTorrent.set_tracker_proxy(proxySetting);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWebSeedProxy(ProxySetting proxy) {
        this.validateLibrary();
        LibTorrentProxySetting proxySetting = null;
        proxySetting = proxy != null ? new LibTorrentProxySetting(proxy) : LibTorrentProxySetting.nullProxy();
        this.lock.lock();
        try {
            this.libTorrent.set_web_seed_proxy(proxySetting);
        }
        finally {
            this.lock.unlock();
        }
    }

    private class AlertPoller
    implements Runnable {
        private AlertPoller() {
        }

        @Override
        public void run() {
            LibTorrentSession.this.libTorrent.get_alerts(LibTorrentSession.this.alertCallback);
            LibTorrentSession.this.alertCallback.updateAlertedTorrents();
        }
    }

    private class BasicAlertCallback
    implements AlertCallback {
        private final Set<String> updatedTorrents = new HashSet<String>();

        private BasicAlertCallback() {
        }

        @Override
        public void callback(LibTorrentAlert alert) {
            String sha1;
            if (LOG.isDebugEnabled()) {
                LOG.debug(alert.toString());
            }
            if ((sha1 = alert.getSha1()) != null) {
                Torrent torrent;
                this.updatedTorrents.add(sha1);
                if (alert.getCategory() == 8 && (torrent = LibTorrentSession.this.getTorrent(sha1)) != null) {
                    LibTorrentSession.this.libTorrent.save_fast_resume_data(alert, torrent.getFastResumeFile().getAbsolutePath());
                    torrent.handleFastResumeAlert(alert);
                }
            }
        }

        public void updateAlertedTorrents() {
            for (String sha1 : this.updatedTorrents) {
                Torrent torrent = LibTorrentSession.this.getTorrent(sha1);
                if (torrent == null) continue;
                LibTorrentSession.this.updateStatus(torrent);
            }
            this.updatedTorrents.clear();
        }
    }
}

