/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.listener;

import org.limewire.listener.BroadcastPolicy;
import org.limewire.listener.CachingEventMulticaster;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.listener.EventMulticaster;
import org.limewire.listener.EventMulticasterImpl;
import org.limewire.logging.Log;

public class CachingEventMulticasterImpl<E>
implements CachingEventMulticaster<E> {
    private final EventMulticaster<E> multicaster;
    private final BroadcastPolicy broadcastPolicy;
    private final EventListenerList.EventListenerListContext listenerContext;
    private final Object LOCK = new Object();
    private volatile E cachedEvent;

    public CachingEventMulticasterImpl() {
        this(BroadcastPolicy.ALWAYS, new EventMulticasterImpl());
    }

    public CachingEventMulticasterImpl(Log log) {
        this(BroadcastPolicy.ALWAYS, log);
    }

    public CachingEventMulticasterImpl(BroadcastPolicy broadcastPolicy) {
        this(broadcastPolicy, new EventMulticasterImpl());
    }

    public CachingEventMulticasterImpl(BroadcastPolicy broadcastPolicy, Log log) {
        this(broadcastPolicy, new EventMulticasterImpl(log));
    }

    public CachingEventMulticasterImpl(BroadcastPolicy broadcastPolicy, EventMulticaster<E> multicaster) {
        this.broadcastPolicy = broadcastPolicy;
        this.multicaster = multicaster;
        this.listenerContext = multicaster.getListenerContext();
    }

    @Override
    public void addListener(EventListener<E> eEventListener) {
        E copy = this.cachedEvent;
        if (copy != null) {
            EventListenerList.dispatch(eEventListener, copy, this.listenerContext);
        }
        this.multicaster.addListener(eEventListener);
    }

    @Override
    public boolean removeListener(EventListener<E> eEventListener) {
        return this.multicaster.removeListener(eEventListener);
    }

    @Override
    public void handleEvent(E event) {
        this.broadcast(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcast(E event) {
        boolean broadcast = false;
        Object object = this.LOCK;
        synchronized (object) {
            if (this.cachedEvent == null || this.broadcastPolicy == BroadcastPolicy.ALWAYS || !this.cachedEvent.equals(event)) {
                this.cachedEvent = event;
                broadcast = true;
            }
        }
        if (broadcast) {
            this.multicaster.broadcast(event);
        }
    }

    @Override
    public E getLastEvent() {
        return this.cachedEvent;
    }

    @Override
    public EventListenerList.EventListenerListContext getListenerContext() {
        return this.listenerContext;
    }
}

