/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.listener;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.listener.SourcedEvent;
import org.limewire.listener.SourcedEventMulticaster;

public class SourcedEventMulticasterImpl<E extends SourcedEvent<S>, S>
implements SourcedEventMulticaster<E, S> {
    private final EventListenerList.EventListenerListContext listenerContext;
    private final EventListenerList<E> listenersForAll;
    private final Map<S, EventListenerList<E>> sourceListeners;

    public SourcedEventMulticasterImpl() {
        this(new EventListenerList.EventListenerListContext());
    }

    public SourcedEventMulticasterImpl(EventListenerList.EventListenerListContext context) {
        this.listenerContext = context;
        this.listenersForAll = new EventListenerList(this.listenerContext);
        this.sourceListeners = new ConcurrentHashMap<S, EventListenerList<E>>();
    }

    @Override
    public void handleEvent(E event) {
        this.broadcast(event);
    }

    @Override
    public void broadcast(E event) {
        this.listenersForAll.broadcast(event);
        EventListenerList<E> list = this.sourceListeners.get(event.getSource());
        if (list != null) {
            list.broadcast(event);
        }
    }

    @Override
    public void addListener(EventListener<E> listener) {
        this.listenersForAll.addListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(S source, EventListener<E> listener) {
        Map<S, EventListenerList<E>> map = this.sourceListeners;
        synchronized (map) {
            EventListenerList<E> list = this.sourceListeners.get(source);
            if (list == null) {
                list = new EventListenerList(this.listenerContext);
                this.sourceListeners.put(source, list);
            }
            list.addListener(listener);
        }
    }

    @Override
    public boolean removeListener(EventListener<E> listener) {
        return this.listenersForAll.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(S source, EventListener<E> listener) {
        Map<S, EventListenerList<E>> map = this.sourceListeners;
        synchronized (map) {
            EventListenerList<E> list = this.sourceListeners.get(source);
            if (list == null) {
                return false;
            }
            boolean removed = list.removeListener(listener);
            if (list.size() == 0) {
                this.sourceListeners.remove(source);
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListeners(S source) {
        Map<S, EventListenerList<E>> map = this.sourceListeners;
        synchronized (map) {
            return this.sourceListeners.remove(source) != null;
        }
    }
}

