/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler;

import java.net.SocketAddress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.CollectionUtils;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.PingResponse;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.messages.SecurityTokenProvider;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.settings.DatabaseSettings;
import org.limewire.mojito.settings.KademliaSettings;
import org.limewire.mojito.settings.StoreSettings;
import org.limewire.mojito.statistics.DatabaseStatisticContainer;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.security.SecurityToken;

public class DefaultMessageHandler {
    private static final Log LOG = LogFactory.getLog(DefaultMessageHandler.class);
    private DatabaseStatisticContainer databaseStats;
    protected final Context context;

    public DefaultMessageHandler(Context context) {
        this.context = context;
        this.databaseStats = context.getDatabaseStats();
    }

    public void handleResponse(ResponseMessage message, long time) {
        this.addLiveContactInfo(message.getContact(), message);
    }

    public void handleLateResponse(ResponseMessage message) {
        Contact node = message.getContact();
        if (!node.isFirewalled()) {
            this.context.getRouteTable().add(node);
        }
    }

    public void handleTimeout(KUID nodeId, SocketAddress dst, RequestMessage message, long time) {
        this.context.getRouteTable().handleFailure(nodeId, dst);
    }

    public void handleRequest(RequestMessage message) {
        this.addLiveContactInfo(message.getContact(), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addLiveContactInfo(Contact node, DHTMessage message) {
        int k;
        Collection<Contact> nodes;
        Contact existing;
        RouteTable routeTable = this.context.getRouteTable();
        if (node.isShutdown()) {
            if (LOG.isInfoEnabled()) {
                LOG.info(node + " is going to shut down");
            }
            RouteTable routeTable2 = routeTable;
            synchronized (routeTable2) {
                Contact existing2 = routeTable.get(node.getNodeID());
                if (node.equals(existing2)) {
                    if (existing2.isAlive()) {
                        existing2.shutdown(true);
                    }
                    routeTable.add(node);
                    node.shutdown(true);
                }
            }
            return;
        }
        if (node.isFirewalled()) {
            if (LOG.isInfoEnabled()) {
                LOG.info(node + " is firewalled");
            }
            return;
        }
        if (ContactUtils.isPrivateAddress(node)) {
            if (LOG.isInfoEnabled()) {
                LOG.info(node + " has a private address");
            }
            return;
        }
        KUID nodeId = node.getNodeID();
        if (this.context.isLocalNodeID(nodeId)) {
            assert (message instanceof PingResponse) : "Expected a PingResponse but got a " + message.getClass() + " from " + message.getContact();
            if (LOG.isInfoEnabled()) {
                LOG.info("Looks like our NodeID collides with " + node);
            }
            return;
        }
        if (StoreSettings.STORE_FORWARD_ENABLED.getValue() && ((existing = routeTable.get(nodeId)) == null || existing.isDead() || existing.getInstanceID() != node.getInstanceID()) && this.context.isBootstrapped() && this.containsNodeID(nodes = routeTable.select(nodeId, 2 * (k = KademliaSettings.REPLICATION_PARAMETER.getValue()), RouteTable.SelectMode.ALL), this.context.getLocalNodeID())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Node " + node + " is new or has changed his instanceID, will check for store forward!");
            }
            this.forwardOrRemoveValues(node, existing, message);
        }
        routeTable.add(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardOrRemoveValues(Contact node, Contact existing, DHTMessage message) {
        Database database;
        ArrayList<DHTValueEntity> valuesToForward = new ArrayList<DHTValueEntity>();
        Database database2 = database = this.context.getDatabase();
        synchronized (database2) {
            for (KUID primaryKey : database.keySet()) {
                Map<KUID, DHTValueEntity> bag;
                Operation op = this.getOperation(node, existing, primaryKey);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("node: " + node + "existing: " + existing + "operation: " + (Object)((Object)op));
                }
                if (op.equals((Object)Operation.FORWARD)) {
                    bag = database.get(primaryKey);
                    valuesToForward.addAll(bag.values());
                    this.databaseStats.STORE_FORWARD_COUNT.incrementStat();
                    continue;
                }
                if (!op.equals((Object)Operation.DELETE) || !DatabaseSettings.DELETE_VALUE_IF_FURTHEST_NODE.getValue()) continue;
                bag = database.get(primaryKey);
                for (DHTValueEntity entity : bag.values()) {
                    database.remove(entity.getPrimaryKey(), entity.getSecondaryKey());
                }
                this.databaseStats.STORE_FORWARD_REMOVALS.incrementStat();
            }
        }
        if (!valuesToForward.isEmpty()) {
            SecurityToken securityToken = null;
            if (message instanceof SecurityTokenProvider && (securityToken = ((SecurityTokenProvider)((Object)message)).getSecurityToken()) == null && StoreSettings.STORE_REQUIRES_SECURITY_TOKEN.getValue()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(node + " sent us a null SecurityToken");
                }
                return;
            }
            this.context.store(node, securityToken, valuesToForward);
        }
    }

    private boolean containsNodeID(Collection<Contact> nodes, KUID id) {
        for (Contact node : nodes) {
            if (!id.equals(node.getNodeID())) continue;
            return true;
        }
        return false;
    }

    private Operation getOperation(Contact node, Contact existing, KUID valueId) {
        KUID furthestId;
        KUID nodeId;
        int k = KademliaSettings.REPLICATION_PARAMETER.getValue();
        RouteTable routeTable = this.context.getRouteTable();
        List<Contact> nodes = CollectionUtils.toList(routeTable.select(valueId, k, RouteTable.SelectMode.ALL));
        Contact closest = nodes.get(0);
        Contact furthest = nodes.get(nodes.size() - 1);
        if (LOG.isDebugEnabled()) {
            LOG.debug(MessageFormat.format("node: {0}, existing: {1}, close nodes: {2}", node, existing, nodes));
        }
        if (this.context.isLocalNode(closest) || node.equals(closest) && nodes.size() > 1 && this.context.isLocalNode(nodes.get(1))) {
            KUID furthestId2;
            KUID nodeId2 = node.getNodeID();
            if (nodeId2.equals(furthestId2 = furthest.getNodeID()) || nodeId2.isNearerTo(valueId, furthestId2)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Node " + node + " is now close enough to a value and we are responsible for xfer");
                }
                return Operation.FORWARD;
            }
        } else if (nodes.size() >= k && this.context.isLocalNode(furthest) && (existing == null || existing.isDead()) && (nodeId = node.getNodeID()).isNearerTo(valueId, furthestId = furthest.getNodeID())) {
            return Operation.DELETE;
        }
        return Operation.NOTHING;
    }

    private static enum Operation {
        NOTHING,
        FORWARD,
        DELETE;

    }
}

