/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import org.limewire.mojito.KUID;
import org.limewire.mojito.StatusCode;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.StatsRequest;
import org.limewire.mojito.messages.StoreResponse;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.SecurityToken;

public class MessageOutputStream
extends DataOutputStream {
    public MessageOutputStream(OutputStream out) {
        super(out);
    }

    public void writeKUID(KUID kuid) throws IOException {
        if (kuid == null) {
            throw new NullPointerException("KUID cannot be null");
        }
        kuid.write(this);
    }

    public void writeMessageID(MessageID messageId) throws IOException {
        if (messageId == null) {
            throw new NullPointerException("MessageID cannot be null");
        }
        messageId.write(this);
    }

    public void writeDHTSize(BigInteger estimatedSize) throws IOException {
        byte[] data = estimatedSize.toByteArray();
        if (data.length > 20) {
            throw new IOException("Illegal length: " + data.length + "/" + estimatedSize);
        }
        this.writeByte(data.length);
        this.write(data, 0, data.length);
    }

    public void writeDHTValueEntity(DHTValueEntity entity) throws IOException {
        this.writeContact(entity.getCreator());
        entity.getPrimaryKey().write(this);
        this.writeDHTValue(entity.getValue());
    }

    private void writeDHTValue(DHTValue value) throws IOException {
        this.writeDHTValueType(value.getValueType());
        this.writeVersion(value.getVersion());
        byte[] data = value.getValue();
        this.writeShort(data.length);
        this.write(data, 0, data.length);
    }

    public void writeKUIDs(Collection<KUID> keys) throws IOException {
        this.writeCollectionSize(keys);
        for (KUID k : keys) {
            k.write(this);
        }
    }

    public void writeDHTValueEntities(Collection<? extends DHTValueEntity> values) throws IOException {
        this.writeCollectionSize(values);
        for (DHTValueEntity dHTValueEntity : values) {
            this.writeDHTValueEntity(dHTValueEntity);
        }
    }

    public void writeSignature(byte[] signature) throws IOException {
        if (signature != null && signature.length > 0) {
            this.writeByte(signature.length);
            this.write(signature, 0, signature.length);
        } else {
            this.writeByte(0);
        }
    }

    public void writeContact(Contact node) throws IOException {
        this.writeVendor(node.getVendor());
        this.writeVersion(node.getVersion());
        this.writeKUID(node.getNodeID());
        this.writeSocketAddress(node.getContactAddress());
    }

    public void writeContacts(Collection<? extends Contact> nodes) throws IOException {
        this.writeCollectionSize(nodes);
        for (Contact contact : nodes) {
            this.writeContact(contact);
        }
    }

    public void writeInetAddress(InetAddress addr) throws IOException {
        byte[] address = addr.getAddress();
        this.writeByte(address.length);
        this.write(address, 0, address.length);
    }

    public void writePort(int port) throws IOException {
        this.writeShort(port);
    }

    public void writeSocketAddress(SocketAddress addr) throws IOException {
        if (addr instanceof InetSocketAddress && !((InetSocketAddress)addr).isUnresolved()) {
            InetSocketAddress iaddr = (InetSocketAddress)addr;
            this.writeInetAddress(iaddr.getAddress());
            this.writePort(iaddr.getPort());
        } else {
            this.writeByte(0);
        }
    }

    public void writeSecurityToken(SecurityToken securityToken) throws IOException {
        if (securityToken != null) {
            assert (securityToken instanceof AddressSecurityToken);
            byte[] qk = securityToken.getBytes();
            this.writeByte(qk.length);
            this.write(qk, 0, qk.length);
        } else {
            this.writeByte(0);
        }
    }

    public void writeStatistics(byte[] statistics) throws IOException {
        if (statistics != null) {
            this.writeShort(statistics.length);
            this.write(statistics);
        } else {
            this.writeShort(0);
        }
    }

    public void writeOpCode(DHTMessage.OpCode opcode) throws IOException {
        this.writeByte(opcode.toByte());
    }

    public void writeStatisticType(StatsRequest.StatisticType type) throws IOException {
        this.writeByte(type.toByte());
    }

    public void writeStatusCode(StatusCode statusCode) throws IOException {
        this.writeShort(statusCode.shortValue());
        this.writeDHTString(statusCode.getDescription());
    }

    void writeDHTString(String str) throws IOException {
        byte[] b = str.getBytes("UTF-8");
        if (b.length > 65535) {
            throw new IOException("String is too big");
        }
        this.writeShort(b.length);
        this.write(b);
    }

    public void writeStoreStatusCodes(Collection<StoreResponse.StoreStatusCode> statusCodes) throws IOException {
        this.writeCollectionSize(statusCodes);
        for (StoreResponse.StoreStatusCode statusCode : statusCodes) {
            this.writeKUID(statusCode.getPrimaryKey());
            this.writeKUID(statusCode.getSecondaryKey());
            this.writeStatusCode(statusCode.getStatusCode());
        }
    }

    private void writeCollectionSize(Collection c) throws IOException {
        int size = c.size();
        if (size > 255) {
            throw new IOException("Too many elements: " + size);
        }
        this.writeByte(size);
    }

    public void writeDHTValueType(DHTValueType type) throws IOException {
        this.writeInt(type.toInt());
    }

    public void writeVendor(Vendor vendor) throws IOException {
        this.writeInt(vendor.intValue());
    }

    public void writeVersion(Version version) throws IOException {
        this.writeShort(version.shortValue());
    }
}

