/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.manager;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureTask;
import org.limewire.mojito.concurrent.DHTTask;
import org.limewire.mojito.handler.response.FindNodeResponseHandler;
import org.limewire.mojito.manager.AbstractManager;
import org.limewire.mojito.result.FindNodeResult;

public class FindNodeManager
extends AbstractManager<FindNodeResult> {
    private final Map<KUID, FindNodeFuture> futureMap = Collections.synchronizedMap(new HashMap());

    public FindNodeManager(Context context) {
        super(context);
    }

    public void init() {
        this.futureMap.clear();
    }

    public DHTFuture<FindNodeResult> lookup(KUID lookupId) {
        return this.lookup(lookupId, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DHTFuture<FindNodeResult> lookup(KUID lookupId, int count) {
        FindNodeFuture future = null;
        Map<KUID, FindNodeFuture> map = this.futureMap;
        synchronized (map) {
            future = this.futureMap.get(lookupId);
            if (future == null) {
                FindNodeResponseHandler handler = this.createFindNodeResponseHandler(this.context, lookupId, count);
                future = new FindNodeFuture(lookupId, handler);
                this.futureMap.put(lookupId, future);
                this.context.getDHTExecutorService().execute(future);
            }
        }
        return future;
    }

    protected FindNodeResponseHandler createFindNodeResponseHandler(Context context, KUID lookupId, int count) {
        return new FindNodeResponseHandler(context, lookupId, count);
    }

    private class FindNodeFuture
    extends DHTFutureTask<FindNodeResult> {
        private final KUID lookupId;
        private final DHTTask<FindNodeResult> handler;

        public FindNodeFuture(KUID lookupId, DHTTask<FindNodeResult> handler) {
            super(FindNodeManager.this.context, handler);
            this.lookupId = lookupId;
            this.handler = handler;
        }

        @Override
        protected void done() {
            FindNodeManager.this.futureMap.remove(this.lookupId);
        }

        public String toString() {
            return "FindNodeFuture: " + this.lookupId + ", " + this.handler;
        }
    }
}

