/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.manager;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.handler.response.PingResponseHandler;
import org.limewire.mojito.messages.PingRequest;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.ContextSettings;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.mojito.util.EntryImpl;

class PingIteratorFactory {
    private PingIteratorFactory() {
    }

    static class EntryPinger
    implements PingResponseHandler.PingIterator {
        private final Collection<? extends Map.Entry<KUID, ? extends SocketAddress>> entries;
        private final Iterator<? extends Map.Entry<KUID, ? extends SocketAddress>> it;

        public EntryPinger(KUID nodeId, SocketAddress address) {
            this(Collections.singleton(new EntryImpl<KUID, SocketAddress>(nodeId, address)));
        }

        public EntryPinger(Map.Entry<KUID, ? extends SocketAddress> entry) {
            this(Collections.singleton(entry));
        }

        public EntryPinger(Set<? extends Map.Entry<KUID, ? extends SocketAddress>> entries) {
            if (entries == null) {
                throw new NullPointerException("Set<Entry<KUID, SocketAddress>> is null");
            }
            for (Map.Entry<KUID, ? extends SocketAddress> entry : entries) {
                if (entry == null) {
                    throw new NullPointerException("Entry<KUID, SocketAddress> is null");
                }
                if (entry.getValue() != null) continue;
                throw new NullPointerException("SocketAddress is null");
            }
            this.entries = entries;
            this.it = entries.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public boolean pingNext(Context context, PingResponseHandler responseHandler) throws IOException {
            Map.Entry<KUID, ? extends SocketAddress> entry = this.it.next();
            KUID nodeId = entry.getKey();
            SocketAddress dst = entry.getValue();
            PingRequest request = context.getMessageHelper().createPingRequest(dst);
            return context.getMessageDispatcher().send(nodeId, dst, request, responseHandler);
        }

        public String toString() {
            return "EntryPinger: " + this.entries.toString();
        }
    }

    static class SocketAddressPinger
    implements PingResponseHandler.PingIterator {
        private final Set<? extends SocketAddress> hosts;
        private final Iterator<? extends SocketAddress> it;

        public SocketAddressPinger(SocketAddress host) {
            this(Collections.singleton(host));
        }

        public SocketAddressPinger(Set<? extends SocketAddress> hosts) {
            if (hosts == null) {
                throw new NullPointerException("Set<SocketAddress> is null");
            }
            for (SocketAddress socketAddress : hosts) {
                if (socketAddress != null) continue;
                throw new NullPointerException("SocketAddress is null");
            }
            this.hosts = hosts;
            this.it = hosts.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public boolean pingNext(Context context, PingResponseHandler responseHandler) throws IOException {
            SocketAddress dst = this.it.next();
            PingRequest request = context.getMessageHelper().createPingRequest(dst);
            return context.getMessageDispatcher().send(null, dst, request, responseHandler);
        }

        public String toString() {
            return "SocketAddressPinger: " + this.hosts.toString();
        }
    }

    static class CollisionPinger
    extends ContactPinger {
        private final Contact sender;

        public CollisionPinger(Context context, Contact sender, Contact node) {
            this(context, sender, Collections.singleton(node));
        }

        public CollisionPinger(Context context, Contact sender, Set<? extends Contact> nodes) {
            super(nodes);
            if (ContextSettings.ASSERT_COLLISION_PING.getValue()) {
                this.assertCollisionPing(context, sender, nodes);
            }
            this.sender = sender;
        }

        private void assertCollisionPing(Context context, Contact sender, Set<? extends Contact> nodes) {
            KUID localId = context.getLocalNodeID();
            if (!ContactUtils.isCollisionPingSender(localId, sender)) {
                throw new IllegalArgumentException(sender + " is not a valid collision ping Contact");
            }
            for (Contact contact : nodes) {
                if (localId.equals(contact.getNodeID())) continue;
                throw new IllegalArgumentException(contact + " must have the same ID as the local Node ID: " + localId);
            }
        }

        @Override
        public boolean pingNext(Context context, PingResponseHandler responseHandler) throws IOException {
            Contact node = (Contact)this.it.next();
            KUID nodeId = node.getNodeID();
            SocketAddress dst = node.getContactAddress();
            PingRequest request = context.getMessageFactory().createPingRequest(this.sender, dst);
            return context.getMessageDispatcher().send(nodeId, dst, request, responseHandler);
        }

        @Override
        public String toString() {
            return "CollisionPinger: " + this.sender;
        }
    }

    static class ContactPinger
    implements PingResponseHandler.PingIterator {
        final Collection<? extends Contact> nodes;
        final Iterator<? extends Contact> it;

        public ContactPinger(Contact node) {
            this(Collections.singleton(node));
        }

        public ContactPinger(Set<? extends Contact> nodes) {
            if (nodes == null) {
                throw new NullPointerException("Set<Contact> is null");
            }
            for (Contact contact : nodes) {
                if (contact != null) continue;
                throw new NullPointerException("Contact is null");
            }
            this.nodes = nodes;
            this.it = nodes.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public boolean pingNext(Context context, PingResponseHandler responseHandler) throws IOException {
            Contact node = this.it.next();
            KUID nodeId = node.getNodeID();
            SocketAddress dst = node.getContactAddress();
            PingRequest request = context.getMessageHelper().createPingRequest(dst);
            return context.getMessageDispatcher().send(nodeId, dst, request, responseHandler);
        }

        public String toString() {
            return "ContactPinger: " + this.nodes;
        }
    }
}

