/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.IOException;
import java.net.SocketAddress;
import java.security.Signature;
import java.security.SignatureException;
import org.limewire.mojito.Context;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.io.MessageOutputStream;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.StatsRequest;
import org.limewire.mojito.messages.impl.AbstractRequestMessage;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Version;
import org.limewire.security.SecureMessage;

public class StatsRequestImpl
extends AbstractRequestMessage
implements StatsRequest {
    private final StatsRequest.StatisticType request;
    private final byte[] signature;
    private SecureMessage.Status secureStatus = SecureMessage.Status.INSECURE;

    public StatsRequestImpl(Context context, Contact contact, MessageID messageId, StatsRequest.StatisticType request) {
        super(context, DHTMessage.OpCode.STATS_REQUEST, contact, messageId, Version.ZERO);
        this.request = request;
        this.signature = null;
    }

    public StatsRequestImpl(Context context, SocketAddress src, MessageID messageId, Version msgVersion, MessageInputStream in) throws IOException {
        super(context, DHTMessage.OpCode.STATS_REQUEST, src, messageId, msgVersion, in);
        this.request = in.readStatisticType();
        this.signature = in.readSignature();
    }

    @Override
    public StatsRequest.StatisticType getType() {
        return this.request;
    }

    @Override
    public void setSecureStatus(SecureMessage.Status secureStatus) {
        this.secureStatus = secureStatus;
    }

    @Override
    public SecureMessage.Status getSecureStatus() {
        return this.secureStatus;
    }

    @Override
    public boolean isSecure() {
        return this.secureStatus == SecureMessage.Status.SECURE;
    }

    @Override
    public byte[] getSecureSignature() {
        return this.signature;
    }

    @Override
    public void updateSignatureWithSecuredBytes(Signature signature) throws SignatureException {
        this.initSignature(signature);
    }

    @Override
    protected void writeBody(MessageOutputStream out) throws IOException {
        out.writeStatisticType(this.request);
        out.writeSignature(this.signature);
    }

    public String toString() {
        return "StatsRequest: " + (Object)((Object)this.request);
    }
}

