/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.routing;

import java.io.Serializable;
import org.limewire.mojito.util.ArrayUtils;

public class Vendor
implements Serializable,
Comparable<Vendor> {
    private static final long serialVersionUID = 1607453128714814318L;
    private static final Vendor[] VENDORS = new Vendor[10];
    public static final Vendor UNKNOWN = new Vendor(0);
    public static final int LENGTH = 4;
    private final int vendorId;

    private Vendor(int vendorId) {
        this.vendorId = vendorId;
    }

    public int intValue() {
        return this.vendorId;
    }

    public int hashCode() {
        return this.vendorId;
    }

    @Override
    public int compareTo(Vendor o) {
        return this.vendorId - o.vendorId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vendor)) {
            return false;
        }
        return this.vendorId == ((Vendor)o).vendorId;
    }

    public String toString() {
        return ArrayUtils.toString(this.vendorId);
    }

    public static synchronized Vendor valueOf(int vendorId) {
        int index = (vendorId & Integer.MAX_VALUE) % VENDORS.length;
        Vendor vendor = VENDORS[index];
        if (vendor == null || vendor.vendorId != vendorId) {
            Vendor.VENDORS[index] = vendor = new Vendor(vendorId);
        }
        return vendor;
    }

    public static Vendor valueOf(String vendorId) {
        return Vendor.valueOf(ArrayUtils.toInteger(vendorId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            int index = (this.vendorId & Integer.MAX_VALUE) % VENDORS.length;
            Vendor vendor = VENDORS[index];
            if (vendor == null || vendor.vendorId != this.vendorId) {
                Vendor.VENDORS[index] = vendor = this;
            }
            return vendor;
        }
    }
}

