/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.util;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class FixedSizeHashMap<K, V>
extends LinkedHashMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 8502617259787609782L;
    protected final int maxSize;

    public FixedSizeHashMap(int maxSize) {
        this.maxSize = maxSize;
    }

    public FixedSizeHashMap(int initialCapacity, float loadFactor, boolean accessOrder, int maxSize) {
        super(initialCapacity, loadFactor, accessOrder);
        this.maxSize = maxSize;
    }

    public FixedSizeHashMap(int initialCapacity, float loadFactor, int maxSize) {
        super(initialCapacity, loadFactor);
        this.maxSize = maxSize;
    }

    public FixedSizeHashMap(int initialCapacity, int maxSize) {
        super(initialCapacity);
        this.maxSize = maxSize;
    }

    public FixedSizeHashMap(Map<? extends K, ? extends V> m, int maxSize) {
        super(m);
        this.maxSize = maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean isFull() {
        return this.size() >= this.maxSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxSize;
    }
}

