/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net.address;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.limewire.concurrent.OnewayExchanger;
import org.limewire.io.Address;
import org.limewire.net.address.AddressResolutionObserver;

public class BlockingAddressResolutionObserver
implements AddressResolutionObserver {
    private final OnewayExchanger<Address, IOException> exchanger = new OnewayExchanger();

    @Override
    public void resolved(Address address) {
        this.exchanger.setValue(address);
    }

    @Override
    public void handleIOException(IOException iox) {
        this.exchanger.setException(iox);
    }

    @Override
    public void shutdown() {
        this.exchanger.setException(new IOException("shut down"));
    }

    public Address getAddress() throws IOException {
        try {
            return this.exchanger.get();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public Address getAddress(long timeout, TimeUnit timeUnit) throws IOException, TimeoutException {
        try {
            return this.exchanger.get(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

