/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestScatteringByteChannel;
import org.limewire.util.BufferUtils;

public abstract class AbstractChannelInterestReader
implements ChannelReadObserver,
InterestScatteringByteChannel {
    protected ByteBuffer buffer;
    protected InterestReadableByteChannel source;
    protected boolean shutdown;

    public AbstractChannelInterestReader(int bufferSize) {
        this.buffer = ByteBuffer.allocate(bufferSize);
    }

    @Override
    public int read(ByteBuffer dst) {
        return BufferUtils.transfer(this.buffer, dst);
    }

    @Override
    public long read(ByteBuffer[] dst) {
        return this.read(dst, 0, dst.length);
    }

    @Override
    public long read(ByteBuffer[] dst, int offset, int length) {
        return BufferUtils.transfer(this.buffer, dst, offset, length, true);
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
    }

    @Override
    public InterestReadableByteChannel getReadChannel() {
        return this.source;
    }

    @Override
    public void setReadChannel(InterestReadableByteChannel newChannel) {
        this.source = newChannel;
    }

    @Override
    public void interestRead(boolean status) {
        this.source.interestRead(status);
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public boolean isOpen() {
        return this.source.isOpen();
    }

    @Override
    public void handleIOException(IOException iox) {
    }
}

