/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.promotion.containers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.GGEP;
import org.limewire.promotion.LatitudeLongitude;
import org.limewire.promotion.containers.MessageContainer;
import org.limewire.promotion.exceptions.PromotionException;
import org.limewire.util.ByteUtils;
import org.limewire.util.StringUtils;

public class PromotionMessageContainer
implements MessageContainer,
Serializable {
    public static final long MAX_DATE_IN_SECONDS = Integer.MAX_VALUE;
    private static final String KEY_HEADER = "H";
    private static final String KEY_TERRITORIES = "T";
    private static final String KEY_DESCRIPTION = "D";
    private static final String KEY_TITLE = "t";
    private static final String KEY_DISPLAY_URL = "u";
    private static final String KEY_URL = "U";
    private static final String KEY_KEYWORDS = "K";
    private static final String KEY_GEO_RESTRICT = "G";
    private static final String KEY_DATE_RANGE = "d";
    private static final String KEY_PROPERTIES = "P";
    private static final String KEY_IMPRESS_ONLY = "I";
    private GGEP payload = new GGEP();
    private static final String[] PROPERTY_ENCODING_ARRAY = new String[]{"artist", "album", "url", "genre", "license", "size", "creation_time", "vendor", "name", "audio", "video", "document"};

    @Override
    public byte[] getType() {
        return StringUtils.toUTF8Bytes(KEY_PROPERTIES);
    }

    @Override
    public byte[] encode() {
        this.payload.put(KEY_TERRITORIES, this.getType());
        if (!this.payload.hasKey(KEY_HEADER)) {
            throw new RuntimeException("Missing header");
        }
        if (!this.payload.hasKey(KEY_TERRITORIES)) {
            throw new RuntimeException("Missing territories");
        }
        if (!this.payload.hasKey(KEY_DESCRIPTION)) {
            throw new RuntimeException("Missing description");
        }
        if (!this.payload.hasKey(KEY_URL)) {
            throw new RuntimeException("Missing URL");
        }
        if (!this.payload.hasKey(KEY_KEYWORDS)) {
            throw new RuntimeException("Missing keywords");
        }
        return this.payload.toByteArray();
    }

    public void setUniqueID(long id) {
        byte[] header = this.getHeader();
        ByteUtils.long2beb(id, header, 0);
        this.setHeader(header);
    }

    public long getUniqueID() {
        byte[] header = this.getHeader();
        return ByteUtils.beb2long(header, 0, 8);
    }

    public void setProbability(float probability) {
        if (probability < 0.0f) {
            probability = 0.0f;
        }
        if (probability > 1.0f) {
            probability = 1.0f;
        }
        byte probByte = (byte)(probability * 255.0f - 128.0f);
        byte[] header = this.getHeader();
        header[9] = probByte;
        this.setHeader(header);
    }

    public float getProbability() {
        byte[] header = this.getHeader();
        byte probByte = header[9];
        return (float)(probByte + 128) / 255.0f;
    }

    public PromotionMediaType getMediaType() {
        byte[] header = this.getHeader();
        byte typeByte = header[8];
        return PromotionMediaType.getInstance(typeByte);
    }

    public void setMediaType(PromotionMediaType type) {
        byte[] header = this.getHeader();
        header[8] = type.getValue();
        this.setHeader(header);
    }

    public boolean isImpressionOnly() {
        return this.payload.hasKey(KEY_IMPRESS_ONLY);
    }

    public void setImpressionOnly(boolean impressOnly) {
        if (impressOnly) {
            this.payload.put(KEY_IMPRESS_ONLY);
        } else {
            this.payload.getHeaders().remove(KEY_IMPRESS_ONLY);
        }
    }

    public void setOptions(PromotionOptions options) {
        byte[] header = this.getHeader();
        int bitmaskLength = header.length - 10;
        byte[] mask = new byte[bitmaskLength];
        if (mask.length > 0) {
            if (options.isMatchAllWords()) {
                mask[0] = (byte)(mask[0] | 1);
            }
            if (options.isOpenInNewTab()) {
                mask[0] = (byte)(mask[0] | 2);
            }
            if (options.isOpenInHomeTab()) {
                mask[0] = (byte)(mask[0] | 4);
            }
            if (options.isOpenInStoreTab()) {
                mask[0] = (byte)(mask[0] | 8);
            }
            if (options.isOpenInUnknownTab()) {
                mask[0] = (byte)(mask[0] | 0x10);
            }
        }
        System.arraycopy(mask, 0, header, 10, bitmaskLength);
        this.setHeader(header);
    }

    public PromotionOptions getOptions() {
        byte[] header = this.getHeader();
        PromotionOptions options = new PromotionOptions();
        if (header.length > 10) {
            byte mask = header[10];
            options.setMatchAllWords((mask & 1) > 0);
            options.setOpenInNewTab((mask & 2) > 0);
            options.setOpenInHomeTab((mask & 4) > 0);
            options.setOpenInStoreTab((mask & 8) > 0);
            options.setOpenInUnknownTab((mask & 0x10) > 0);
        }
        return options;
    }

    private void setHeader(byte[] header) {
        if (header == null || header.length < 11) {
            throw new IllegalArgumentException("header must be at least 11 bytes long.");
        }
        this.payload.put(KEY_HEADER, header);
    }

    private byte[] getHeader() {
        byte[] header = null;
        try {
            if (this.payload.hasKey(KEY_HEADER)) {
                header = this.payload.getBytes(KEY_HEADER);
            }
        }
        catch (BadGGEPPropertyException badGGEPPropertyException) {
            // empty catch block
        }
        if (header == null || header.length < 11) {
            header = new byte[11];
        }
        return header;
    }

    public void setTerritories(Locale ... locales) {
        StringBuilder countries = new StringBuilder();
        for (Locale locale : locales) {
            countries.append(locale.getCountry());
        }
        this.payload.put(KEY_TERRITORIES, StringUtils.toUTF8Bytes(countries.toString()));
    }

    public Locale[] getTerritories() {
        String territories;
        ArrayList<Locale> territoryList = new ArrayList<Locale>();
        try {
            territories = StringUtils.toUTF8String(this.payload.getBytes(KEY_TERRITORIES));
        }
        catch (BadGGEPPropertyException ex) {
            throw new RuntimeException("GGEP exception parsing territories.", ex);
        }
        for (int i = 0; i < territories.length() - 1; i += 2) {
            territoryList.add(new Locale("", territories.substring(i, i + 2)));
        }
        return territoryList.toArray(new Locale[territoryList.size()]);
    }

    public void setDescription(String description) {
        this.set(KEY_DESCRIPTION, description);
    }

    public String getDescription() {
        return this.get(KEY_DESCRIPTION);
    }

    public void setTitle(String title) {
        this.set(KEY_TITLE, title);
    }

    public String getTitle() {
        return this.get(KEY_TITLE);
    }

    public void setDisplayUrl(String displayUrl) {
        this.set(KEY_DISPLAY_URL, displayUrl);
    }

    public String getDisplayUrl() {
        return this.get(KEY_DISPLAY_URL);
    }

    public void setKeywords(String keywords) {
        this.set(KEY_KEYWORDS, keywords);
    }

    public String getKeywords() {
        return this.get(KEY_KEYWORDS);
    }

    public void setURL(String url) {
        this.set(KEY_URL, url);
    }

    public String getURL() {
        return this.get(KEY_URL);
    }

    public void setProperties(Map<String, String> properties) {
        StringBuilder builder = new StringBuilder();
        for (String key : properties.keySet()) {
            String value = properties.get(key);
            if (value == null) continue;
            builder.append(this.encodePropertyKey(key)).append('=').append(value).append('\t');
        }
        if (builder.length() == 0) {
            this.payload.put(KEY_PROPERTIES, new byte[0]);
            return;
        }
        byte[] encodedProperties = StringUtils.toUTF8Bytes(builder.substring(0, builder.length() - 1));
        this.payload.put(KEY_PROPERTIES, encodedProperties);
    }

    String encodePropertyKey(String key) {
        if (key != null && key.indexOf(".") != -1 && !key.equals(".")) {
            return this.encodeDottedPropertyKey(key);
        }
        for (int i = 0; i < PROPERTY_ENCODING_ARRAY.length; ++i) {
            if (!PROPERTY_ENCODING_ARRAY[i].equals(key)) continue;
            return new String((char)(i + 128) + "");
        }
        return key;
    }

    private String encodeDottedPropertyKey(String key) {
        StringTokenizer tokens = new StringTokenizer(key, ".", true);
        StringBuilder builder = new StringBuilder();
        boolean lastTokenWasCompressed = false;
        while (tokens.hasMoreTokens()) {
            String token = this.encodePropertyKey(tokens.nextToken());
            if (!token.equals(".") || !lastTokenWasCompressed) {
                builder.append(token);
            }
            lastTokenWasCompressed = token.length() == 1 && token.charAt(0) >= '\u0080';
        }
        return this.trimTrailingPeriods(builder);
    }

    private String trimTrailingPeriods(StringBuilder builder) {
        if (builder.charAt(builder.length() - 1) == '.') {
            builder.deleteCharAt(builder.length() - 1);
            return this.trimTrailingPeriods(builder);
        }
        return builder.toString();
    }

    String decodePropertyKey(String key) {
        if (key == null || key.length() == 0) {
            return key;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < key.length(); ++i) {
            int index = key.charAt(i);
            if (index >= 128) {
                if ((index -= 128) >= PROPERTY_ENCODING_ARRAY.length) continue;
                builder.append(PROPERTY_ENCODING_ARRAY[index]);
                builder.append(".");
                continue;
            }
            builder.append((char)index);
        }
        if (builder.charAt(builder.length() - 1) == '.' && !key.endsWith(".")) {
            return builder.substring(0, builder.length() - 1);
        }
        return builder.toString();
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            String encoded = StringUtils.toUTF8String(this.payload.getBytes(KEY_PROPERTIES));
            StringTokenizer tokens = new StringTokenizer(encoded, "\t");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (token.indexOf(61) <= 0) continue;
                String key = token.substring(0, token.indexOf(61));
                String value = token.substring(key.length() + 1);
                properties.put(this.decodePropertyKey(key), value);
            }
        }
        catch (BadGGEPPropertyException badGGEPPropertyException) {
            // empty catch block
        }
        return properties;
    }

    public void setGeoRestrictions(List<GeoRestriction> restrictions) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (GeoRestriction restriction : restrictions) {
            try {
                out.write(restriction.toBytes());
            }
            catch (IOException ignored) {}
        }
        this.payload.put(KEY_GEO_RESTRICT, out.toByteArray());
    }

    public List<GeoRestriction> getGeoRestrictions() {
        ArrayList<GeoRestriction> list = new ArrayList<GeoRestriction>();
        if (this.payload.hasValueFor(KEY_GEO_RESTRICT)) {
            byte[] encoded = this.payload.get(KEY_GEO_RESTRICT);
            for (int i = 0; i < encoded.length - 6; i += 7) {
                byte[] geoBytes = new byte[7];
                System.arraycopy(encoded, i, geoBytes, 0, 7);
                try {
                    list.add(new GeoRestriction(geoBytes));
                    continue;
                }
                catch (PromotionException ex) {
                    throw new RuntimeException("PromotionException while parsing geo restrictions.", ex);
                }
            }
        }
        return list;
    }

    public void setValidStart(Date start) {
        this.setValidRange(start, this.getValidEnd());
    }

    public void setValidEnd(Date end) {
        this.setValidRange(this.getValidStart(), end);
    }

    private void setValidRange(Date start, Date end) {
        if (start == null) {
            start = new Date();
        }
        if (end == null) {
            end = new Date(2147483647000L);
        }
        byte[] range = new byte[8];
        byte[] startBytes = ByteUtils.long2bytes(start.getTime() / 1000L, 4);
        byte[] endBytes = ByteUtils.long2bytes(end.getTime() / 1000L, 4);
        System.arraycopy(startBytes, 0, range, 0, 4);
        System.arraycopy(endBytes, 0, range, 4, 4);
        this.payload.put(KEY_DATE_RANGE, range);
    }

    public Date getValidStart() {
        try {
            byte[] range = this.payload.getBytes(KEY_DATE_RANGE);
            byte[] start = new byte[4];
            System.arraycopy(range, 0, start, 0, 4);
            long startLong = ByteUtils.beb2long(start, 0, 4);
            return new Date(startLong * 1000L);
        }
        catch (BadGGEPPropertyException ex) {
            return new Date(0L);
        }
    }

    public Date getValidEnd() {
        try {
            byte[] range = this.payload.getBytes(KEY_DATE_RANGE);
            byte[] end = new byte[4];
            System.arraycopy(range, 4, end, 0, 4);
            long endLong = ByteUtils.beb2long(end, 0, 4);
            return new Date(endLong * 1000L);
        }
        catch (BadGGEPPropertyException ex) {
            return new Date(2147483647000L);
        }
    }

    private String get(String key) {
        try {
            if (!this.payload.hasValueFor(key)) {
                return "";
            }
            return StringUtils.toUTF8String(this.payload.getBytes(key));
        }
        catch (BadGGEPPropertyException ex) {
            throw new RuntimeException("GGEP exception parsing value.", ex);
        }
    }

    private void set(String key, String value) {
        this.payload.put(key, StringUtils.toUTF8Bytes(value));
    }

    @Override
    public void decode(GGEP rawGGEP) throws BadGGEPBlockException {
        if (!Arrays.equals(this.getType(), rawGGEP.get(KEY_TERRITORIES))) {
            throw new BadGGEPBlockException("Incorrect type.");
        }
        if (!rawGGEP.hasKey(KEY_HEADER)) {
            throw new BadGGEPBlockException("Missing header");
        }
        if (!rawGGEP.hasKey(KEY_TERRITORIES)) {
            throw new BadGGEPBlockException("Missing territories");
        }
        if (!rawGGEP.hasKey(KEY_DESCRIPTION)) {
            throw new BadGGEPBlockException("Missing description");
        }
        if (!rawGGEP.hasKey(KEY_URL)) {
            throw new BadGGEPBlockException("Missing URL");
        }
        if (!rawGGEP.hasKey(KEY_KEYWORDS)) {
            throw new BadGGEPBlockException("Missing keywords");
        }
        this.payload = rawGGEP;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PromotionMessageContainer)) {
            return false;
        }
        PromotionMessageContainer compare = (PromotionMessageContainer)obj;
        if (this.getUniqueID() != compare.getUniqueID()) {
            return false;
        }
        if (!this.getKeywords().equals(compare.getKeywords())) {
            return false;
        }
        return this.getURL().equals(compare.getURL());
    }

    public int hashCode() {
        return (int)this.getUniqueID();
    }

    public static class PromotionOptions {
        private boolean matchAllWords = false;
        private boolean openInNewTab = false;
        private boolean openInHomeTab = false;
        private boolean openInStoreTab = false;
        private boolean openInUnknownTab = false;

        public boolean isMatchAllWords() {
            return this.matchAllWords;
        }

        public void setMatchAllWords(boolean matchAllWords) {
            this.matchAllWords = matchAllWords;
        }

        public boolean isOpenInNewWindow() {
            return !this.openInStoreTab && !this.openInNewTab && !this.openInHomeTab && !this.openInUnknownTab;
        }

        public boolean isOpenInNewTab() {
            return this.openInNewTab;
        }

        public void setOpenInNewTab(boolean openInNewTab) {
            this.openInNewTab = openInNewTab;
        }

        public boolean isOpenInStoreTab() {
            return this.openInStoreTab;
        }

        public void setOpenInStoreTab(boolean openInStoreTab) {
            this.openInStoreTab = openInStoreTab;
        }

        public boolean isOpenInUnknownTab() {
            return this.openInUnknownTab;
        }

        public void setOpenInUnknownTab(boolean openInUnknownTab) {
            this.openInUnknownTab = openInUnknownTab;
        }

        public boolean isOpenInHomeTab() {
            return this.openInHomeTab;
        }

        public void setOpenInHomeTab(boolean openInHomeTab) {
            this.openInHomeTab = openInHomeTab;
        }
    }

    public static class GeoRestriction {
        private LatitudeLongitude center;
        private int radiusInMeters;

        public GeoRestriction(LatitudeLongitude center, int radiusInMeters) {
            this.center = center;
            this.radiusInMeters = radiusInMeters;
        }

        GeoRestriction(byte[] bytes) throws PromotionException {
            if (bytes == null || bytes.length != 7) {
                throw new PromotionException("expected exactly 7 bytes for construction.");
            }
            byte[] lat = new byte[3];
            byte[] lon = new byte[3];
            System.arraycopy(bytes, 0, lat, 0, 3);
            System.arraycopy(bytes, 3, lon, 0, 3);
            this.center = new LatitudeLongitude(lat, lon);
            this.radiusInMeters = GeoRestriction.decodeRadius(bytes[6]);
        }

        public boolean contains(LatitudeLongitude point) {
            return this.center.distanceFrom(point) <= (double)this.radiusInMeters / 1000.0;
        }

        public byte[] toBytes() {
            byte[] bytes = new byte[7];
            System.arraycopy(this.center.toBytes(), 0, bytes, 0, 6);
            bytes[6] = this.getEncodedRadius();
            return bytes;
        }

        byte getEncodedRadius() {
            long value = (long)(Math.sqrt(this.radiusInMeters) / 13.0);
            return ByteUtils.long2bytes(value - 1L, 1)[0];
        }

        static int decodeRadius(byte radiusByte) {
            long radius = ByteUtils.beb2long(new byte[]{radiusByte}, 0, 1) + 1L;
            return (int)Math.pow(13L * radius, 2.0);
        }
    }

    public static enum PromotionMediaType {
        AUDIO(1),
        VIDEO(2),
        STORE(3),
        SPOT(4),
        GENERIC_LINK(5),
        UNKNOWN(0);

        private byte value;

        public byte getValue() {
            return this.value;
        }

        private PromotionMediaType(int value) {
            this.value = (byte)value;
        }

        static PromotionMediaType getInstance(byte value) {
            for (PromotionMediaType type : PromotionMediaType.values()) {
                if (type.value != value) continue;
                return type;
            }
            return UNKNOWN;
        }
    }
}

