/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.ByteBufferOutputStream;
import org.limewire.io.NetworkUtils;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.observer.ReadWriteObserver;
import org.limewire.rudp.MessageDispatcher;
import org.limewire.rudp.UDPService;
import org.limewire.rudp.messages.MessageFormatException;
import org.limewire.rudp.messages.RUDPMessage;
import org.limewire.rudp.messages.RUDPMessageFactory;
import org.limewire.rudp.messages.impl.DefaultMessageFactory;
import org.limewire.service.ErrorService;

public class DefaultUDPService
implements UDPService,
ReadWriteObserver {
    private static final Log LOG = LogFactory.getLog(DefaultUDPService.class);
    private RUDPMessageFactory factory = new DefaultMessageFactory();
    private DatagramChannel channel;
    private final List<SendBundle> OUTGOING_MSGS = new LinkedList<SendBundle>();
    private final ByteBuffer BUFFER;
    private final int BUFFER_SIZE = 2048;
    private final MessageDispatcher DISPATCHER;

    public DefaultUDPService(MessageDispatcher dispatcher) {
        byte[] backing = new byte[2048];
        this.BUFFER = ByteBuffer.wrap(backing);
        this.DISPATCHER = dispatcher;
    }

    @Override
    public int getStableListeningPort() {
        if (this.channel != null) {
            return this.channel.socket().getLocalPort();
        }
        return 0;
    }

    @Override
    public InetAddress getStableListeningAddress() {
        if (this.channel != null) {
            return this.channel.socket().getLocalAddress();
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException bad) {
            return null;
        }
    }

    @Override
    public boolean isListening() {
        return this.channel != null;
    }

    @Override
    public boolean isNATTraversalCapable() {
        return true;
    }

    public void start(int port) throws IOException {
        this.channel = this.getChannel(port);
        NIODispatcher.instance().registerReadWrite(this.channel, this);
    }

    @Override
    public void shutdown() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private DatagramChannel getChannel(int port) throws IOException {
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        DatagramSocket s = channel.socket();
        s.setReceiveBufferSize(65536);
        s.setSendBufferSize(65536);
        s.setReuseAddress(true);
        s.bind(new InetSocketAddress(port));
        return channel;
    }

    @Override
    public void handleIOException(IOException iox) {
        if (!(iox instanceof ClosedChannelException)) {
            ErrorService.error(iox, "UDP Error.");
        } else {
            LOG.trace("Swallowing a UDPService ClosedChannelException", iox);
        }
    }

    @Override
    public void handleRead() throws IOException {
        while (true) {
            SocketAddress from;
            this.BUFFER.clear();
            try {
                from = this.channel.receive(this.BUFFER);
            }
            catch (IOException iox) {
                break;
            }
            if (from == null) break;
            if (!(from instanceof InetSocketAddress)) {
                ErrorService.error(new IllegalStateException("non inet address"), "from: " + from);
                continue;
            }
            InetSocketAddress addr = (InetSocketAddress)from;
            if (!NetworkUtils.isValidAddress(addr.getAddress()) || !NetworkUtils.isValidPort(addr.getPort())) continue;
            this.BUFFER.flip();
            ByteBuffer clone = ByteBuffer.allocate(this.BUFFER.remaining());
            clone.put(this.BUFFER);
            clone.flip();
            RUDPMessage message = null;
            try {
                message = this.factory.createMessage(clone);
            }
            catch (MessageFormatException ignored) {
                // empty catch block
            }
            if (message == null) continue;
            this.processMessage(message, addr);
        }
    }

    protected void processMessage(RUDPMessage message, InetSocketAddress addr) {
        this.DISPATCHER.dispatch(message, addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(RUDPMessage msg, SocketAddress host) {
        if (msg == null) {
            throw new IllegalArgumentException("Null Message");
        }
        if (host == null) {
            throw new IllegalArgumentException("Null InetAddress");
        }
        if (!NetworkUtils.isValidSocketAddress(host)) {
            throw new IllegalArgumentException("Invalid Port: " + host);
        }
        if (this.channel == null || this.channel.socket().isClosed()) {
            return;
        }
        ByteBufferOutputStream baos = new ByteBufferOutputStream();
        try {
            msg.write(baos);
        }
        catch (IOException impossible) {
            ErrorService.error(impossible);
            return;
        }
        ByteBuffer buffer = baos.getBuffer();
        buffer.flip();
        List<SendBundle> list = this.OUTGOING_MSGS;
        synchronized (list) {
            this.OUTGOING_MSGS.add(new SendBundle(buffer, host));
            if (this.channel != null) {
                NIODispatcher.instance().interestWrite(this.channel, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleWrite() throws IOException {
        List<SendBundle> list = this.OUTGOING_MSGS;
        synchronized (list) {
            while (true) {
                if (this.OUTGOING_MSGS.isEmpty()) {
                    NIODispatcher.instance().interestWrite(this.channel, false);
                    return false;
                }
                SendBundle bundle = this.OUTGOING_MSGS.remove(0);
                try {
                    if (this.channel.send(bundle.buffer, bundle.addr) != 0) continue;
                    this.OUTGOING_MSGS.add(0, bundle);
                    return true;
                }
                catch (IOException ignored) {
                    LOG.warn("Ignoring exception on socket", ignored);
                    continue;
                }
                break;
            }
        }
    }

    private static class SendBundle {
        private final ByteBuffer buffer;
        private final SocketAddress addr;

        SendBundle(ByteBuffer b, SocketAddress addr) {
            this.buffer = b;
            this.addr = addr;
        }
    }
}

