/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.SelectorProvider;
import org.limewire.listener.AsynchronousEventBroadcaster;
import org.limewire.rudp.AbstractNBSocketChannel;
import org.limewire.rudp.RUDPContext;
import org.limewire.rudp.UDPMultiplexor;
import org.limewire.rudp.UDPSocketChannel;
import org.limewire.rudp.UDPSocketChannelConnectionEvent;
import org.limewire.rudp.messages.SynMessage;

@Singleton
public class UDPSelectorProvider
extends SelectorProvider {
    private final RUDPContext context;
    private final AsynchronousEventBroadcaster<UDPSocketChannelConnectionEvent> connectionStateEventBroadcaster;

    @Inject
    public UDPSelectorProvider(RUDPContext context, AsynchronousEventBroadcaster<UDPSocketChannelConnectionEvent> connectionStateEventBroadcaster) {
        this.context = context;
        this.connectionStateEventBroadcaster = connectionStateEventBroadcaster;
    }

    @Override
    public DatagramChannel openDatagramChannel() throws IOException {
        throw new IOException("not supported");
    }

    @Override
    public Pipe openPipe() throws IOException {
        throw new IOException("not supported");
    }

    @Override
    public UDPMultiplexor openSelector() {
        UDPMultiplexor plexor = new UDPMultiplexor(this, this.context);
        return plexor;
    }

    public AbstractNBSocketChannel openAcceptorSocketChannel() {
        return new UDPSocketChannel(this, this.context, SynMessage.Role.ACCEPTOR, this.connectionStateEventBroadcaster);
    }

    @Override
    public AbstractNBSocketChannel openSocketChannel() {
        return new UDPSocketChannel(this, this.context, SynMessage.Role.REQUESTOR, this.connectionStateEventBroadcaster);
    }

    public Class<UDPSocketChannel> getUDPSocketChannelClass() {
        return UDPSocketChannel.class;
    }

    public RUDPContext getContext() {
        return this.context;
    }

    @Override
    public ServerSocketChannel openServerSocketChannel() throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }
}

