/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.limewire.security.InvalidSecurityTokenException;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;

public abstract class AbstractSecurityToken
implements SecurityToken {
    private final MACCalculatorRepositoryManager mgr;
    private final byte[] _securityToken;

    protected AbstractSecurityToken(SecurityToken.TokenData data, MACCalculatorRepositoryManager mgr) {
        this.mgr = mgr;
        this._securityToken = this.getFromMAC(mgr.getMACBytes(data), data);
    }

    protected AbstractSecurityToken(byte[] network, MACCalculatorRepositoryManager mgr) throws InvalidSecurityTokenException {
        this.mgr = mgr;
        if (!this.isValidBytes(network)) {
            throw new InvalidSecurityTokenException("invalid data: " + Arrays.toString(network));
        }
        this._securityToken = network;
    }

    @Override
    public final boolean isFor(SecurityToken.TokenData data) {
        if (!this.isValidTokenData(data)) {
            return false;
        }
        Iterable<byte[]> tokens = this.mgr.getAllBytes(data);
        for (byte[] token : tokens) {
            if (!Arrays.equals(this._securityToken, this.getFromMAC(token, data))) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidTokenData(SecurityToken.TokenData data) {
        return true;
    }

    @Override
    public final void write(OutputStream os) throws IOException {
        os.write(this._securityToken);
    }

    @Override
    public final byte[] getBytes() {
        byte[] copy = new byte[this._securityToken.length];
        System.arraycopy(this._securityToken, 0, copy, 0, this._securityToken.length);
        return copy;
    }

    protected abstract byte[] getFromMAC(byte[] var1, SecurityToken.TokenData var2);

    protected boolean isValidBytes(byte[] network) {
        return network != null && network.length > 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SecurityToken) {
            SecurityToken t = (SecurityToken)obj;
            return Arrays.equals(this._securityToken, t.getBytes());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this._securityToken);
    }
}

