/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security;

import java.security.DigestException;
import java.security.MessageDigest;

public final class SHA1
extends MessageDigest
implements Cloneable {
    public static final int HASH_LENGTH = 20;
    private byte[] pad = new byte[64];
    private int padding;
    private long bytes;
    private int hA;
    private int hB;
    private int hC;
    private int hD;
    private int hE;

    public SHA1() {
        super("SHA-1");
        this.init();
    }

    @Override
    public SHA1 clone() throws CloneNotSupportedException {
        SHA1 that = (SHA1)super.clone();
        that.pad = (byte[])this.pad.clone();
        return that;
    }

    @Override
    public int engineGetDigestLength() {
        return 20;
    }

    @Override
    protected void engineReset() {
        int i = 60;
        do {
            this.pad[i] = 0;
            this.pad[i + 1] = 0;
            this.pad[i + 2] = 0;
            this.pad[i + 3] = 0;
        } while ((i -= 4) >= 0);
        this.padding = 0;
        this.bytes = 0L;
        this.init();
    }

    protected void init() {
        this.hA = 1732584193;
        this.hB = -271733879;
        this.hC = -1732584194;
        this.hD = 271733878;
        this.hE = -1009589776;
    }

    @Override
    public void engineUpdate(byte input) {
        ++this.bytes;
        if (this.padding < 63) {
            this.pad[this.padding++] = input;
            return;
        }
        this.pad[63] = input;
        this.computeBlock(this.pad, 0);
        this.padding = 0;
    }

    @Override
    public void engineUpdate(byte[] input, int offset, int len) {
        if (offset >= 0 && len >= 0 && offset + len <= input.length) {
            this.bytes += (long)len;
            int padlen = 64 - this.padding;
            if (this.padding > 0 && len >= padlen) {
                System.arraycopy(input, offset, this.pad, this.padding, padlen);
                this.computeBlock(this.pad, 0);
                this.padding = 0;
                offset += padlen;
                len -= padlen;
            }
            while (len >= 512) {
                this.computeBlock(input, offset);
                this.computeBlock(input, offset + 64);
                this.computeBlock(input, offset + 128);
                this.computeBlock(input, offset + 192);
                this.computeBlock(input, offset + 256);
                this.computeBlock(input, offset + 320);
                this.computeBlock(input, offset + 384);
                this.computeBlock(input, offset + 448);
                offset += 512;
                len -= 512;
            }
            while (len >= 64) {
                this.computeBlock(input, offset);
                offset += 64;
                len -= 64;
            }
            if (len > 0) {
                System.arraycopy(input, offset, this.pad, this.padding, len);
                this.padding += len;
            }
            return;
        }
        throw new ArrayIndexOutOfBoundsException(offset);
    }

    @Override
    public byte[] engineDigest() {
        try {
            byte[] hashvalue = new byte[20];
            this.engineDigest(hashvalue, 0, 20);
            return hashvalue;
        }
        catch (DigestException e) {
            return null;
        }
    }

    @Override
    public int engineDigest(byte[] hashvalue, int offset, int len) throws DigestException {
        if (len >= 20) {
            if (hashvalue.length - offset >= 20) {
                int i = this.padding;
                this.pad[i] = -128;
                switch (i) {
                    case 52: {
                        this.pad[53] = 0;
                    }
                    case 53: {
                        this.pad[54] = 0;
                    }
                    case 54: {
                        this.pad[55] = 0;
                    }
                    case 55: {
                        break;
                    }
                    case 56: {
                        this.pad[57] = 0;
                    }
                    case 57: {
                        this.pad[58] = 0;
                    }
                    case 58: {
                        this.pad[59] = 0;
                    }
                    case 59: {
                        this.pad[60] = 0;
                    }
                    case 60: {
                        this.pad[61] = 0;
                    }
                    case 61: {
                        this.pad[62] = 0;
                    }
                    case 62: {
                        this.pad[63] = 0;
                    }
                    case 63: {
                        this.computeBlock(this.pad, 0);
                        i = 52;
                        do {
                            this.pad[i] = 0;
                            this.pad[i + 1] = 0;
                            this.pad[i + 2] = 0;
                            this.pad[i + 3] = 0;
                        } while ((i -= 4) >= 0);
                        break;
                    }
                    default: {
                        switch (i & 3) {
                            case 3: {
                                ++i;
                                break;
                            }
                            case 2: {
                                this.pad[(i += 2) - 1] = 0;
                                break;
                            }
                            case 1: {
                                this.pad[(i += 3) - 2] = 0;
                                this.pad[i - 1] = 0;
                                break;
                            }
                            case 0: {
                                this.pad[(i += 4) - 3] = 0;
                                this.pad[i - 2] = 0;
                                this.pad[i - 1] = 0;
                            }
                        }
                        do {
                            this.pad[i] = 0;
                            this.pad[i + 1] = 0;
                            this.pad[i + 2] = 0;
                            this.pad[i + 3] = 0;
                        } while ((i += 4) < 56);
                    }
                }
                i = (int)(this.bytes >>> 29);
                this.pad[56] = (byte)(i >> 24);
                this.pad[57] = (byte)(i >>> 16);
                this.pad[58] = (byte)(i >>> 8);
                this.pad[59] = (byte)i;
                i = (int)this.bytes << 3;
                this.pad[60] = (byte)(i >> 24);
                this.pad[61] = (byte)(i >>> 16);
                this.pad[62] = (byte)(i >>> 8);
                this.pad[63] = (byte)i;
                this.computeBlock(this.pad, 0);
                i = this.hA;
                hashvalue[offset] = (byte)(i >>> 24);
                hashvalue[offset + 1] = (byte)(i >>> 16);
                hashvalue[offset + 2] = (byte)(i >>> 8);
                hashvalue[offset + 3] = (byte)i;
                i = this.hB;
                hashvalue[offset + 4] = (byte)(i >>> 24);
                hashvalue[offset += 5] = (byte)(i >>> 16);
                hashvalue[offset + 1] = (byte)(i >>> 8);
                hashvalue[offset + 2] = (byte)i;
                i = this.hC;
                hashvalue[offset + 3] = (byte)(i >>> 24);
                hashvalue[offset + 4] = (byte)(i >>> 16);
                hashvalue[offset += 5] = (byte)(i >>> 8);
                hashvalue[offset + 1] = (byte)i;
                i = this.hD;
                hashvalue[offset + 2] = (byte)(i >>> 24);
                hashvalue[offset + 3] = (byte)(i >>> 16);
                hashvalue[offset + 4] = (byte)(i >>> 8);
                hashvalue[offset += 5] = (byte)i;
                i = this.hE;
                hashvalue[offset + 1] = (byte)(i >>> 24);
                hashvalue[offset + 2] = (byte)(i >>> 16);
                hashvalue[offset + 3] = (byte)(i >>> 8);
                hashvalue[offset + 4] = (byte)i;
                this.engineReset();
                return 20;
            }
            throw new DigestException("insufficient space in output buffer to store the digest");
        }
        throw new DigestException("partial digests not returned");
    }

    private void computeBlock(byte[] input, int offset) {
        int a = this.hA;
        int b = this.hB;
        int c = this.hC;
        int d = this.hD;
        int i00 = input[offset] << 24 | (input[offset + 1] & 0xFF) << 16 | (input[offset + 2] & 0xFF) << 8 | input[offset + 3] & 0xFF;
        int e = this.hE + (a << 5 | a >>> 27) + 1518500249 + (b & (c ^ d) ^ d) + i00;
        b = b << 30 | b >>> 2;
        int i01 = input[offset + 4] << 24 | (input[offset += 5] & 0xFF) << 16 | (input[offset + 1] & 0xFF) << 8 | input[offset + 2] & 0xFF;
        d += (e << 5 | e >>> 27) + 1518500249 + (a & (b ^ c) ^ c) + i01;
        a = a << 30 | a >>> 2;
        int i02 = input[offset + 3] << 24 | (input[offset + 4] & 0xFF) << 16 | (input[offset += 5] & 0xFF) << 8 | input[offset + 1] & 0xFF;
        c += (d << 5 | d >>> 27) + 1518500249 + (e & (a ^ b) ^ b) + i02;
        e = e << 30 | e >>> 2;
        int i03 = input[offset + 2] << 24 | (input[offset + 3] & 0xFF) << 16 | (input[offset + 4] & 0xFF) << 8 | input[offset += 5] & 0xFF;
        b += (c << 5 | c >>> 27) + 1518500249 + (d & (e ^ a) ^ a) + i03;
        d = d << 30 | d >>> 2;
        int i04 = input[offset + 1] << 24 | (input[offset + 2] & 0xFF) << 16 | (input[offset + 3] & 0xFF) << 8 | input[offset + 4] & 0xFF;
        a += (b << 5 | b >>> 27) + 1518500249 + (c & (d ^ e) ^ e) + i04;
        c = c << 30 | c >>> 2;
        int i05 = input[offset += 5] << 24 | (input[offset + 1] & 0xFF) << 16 | (input[offset + 2] & 0xFF) << 8 | input[offset + 3] & 0xFF;
        e += (a << 5 | a >>> 27) + 1518500249 + (b & (c ^ d) ^ d) + i05;
        b = b << 30 | b >>> 2;
        int i06 = input[offset + 4] << 24 | (input[offset += 5] & 0xFF) << 16 | (input[offset + 1] & 0xFF) << 8 | input[offset + 2] & 0xFF;
        d += (e << 5 | e >>> 27) + 1518500249 + (a & (b ^ c) ^ c) + i06;
        a = a << 30 | a >>> 2;
        int i07 = input[offset + 3] << 24 | (input[offset + 4] & 0xFF) << 16 | (input[offset += 5] & 0xFF) << 8 | input[offset + 1] & 0xFF;
        c += (d << 5 | d >>> 27) + 1518500249 + (e & (a ^ b) ^ b) + i07;
        e = e << 30 | e >>> 2;
        int i08 = input[offset + 2] << 24 | (input[offset + 3] & 0xFF) << 16 | (input[offset + 4] & 0xFF) << 8 | input[offset += 5] & 0xFF;
        b += (c << 5 | c >>> 27) + 1518500249 + (d & (e ^ a) ^ a) + i08;
        d = d << 30 | d >>> 2;
        int i09 = input[offset + 1] << 24 | (input[offset + 2] & 0xFF) << 16 | (input[offset + 3] & 0xFF) << 8 | input[offset + 4] & 0xFF;
        a += (b << 5 | b >>> 27) + 1518500249 + (c & (d ^ e) ^ e) + i09;
        c = c << 30 | c >>> 2;
        int i10 = input[offset += 5] << 24 | (input[offset + 1] & 0xFF) << 16 | (input[offset + 2] & 0xFF) << 8 | input[offset + 3] & 0xFF;
        e += (a << 5 | a >>> 27) + 1518500249 + (b & (c ^ d) ^ d) + i10;
        b = b << 30 | b >>> 2;
        int i11 = input[offset + 4] << 24 | (input[offset += 5] & 0xFF) << 16 | (input[offset + 1] & 0xFF) << 8 | input[offset + 2] & 0xFF;
        d += (e << 5 | e >>> 27) + 1518500249 + (a & (b ^ c) ^ c) + i11;
        a = a << 30 | a >>> 2;
        int i12 = input[offset + 3] << 24 | (input[offset + 4] & 0xFF) << 16 | (input[offset += 5] & 0xFF) << 8 | input[offset + 1] & 0xFF;
        c += (d << 5 | d >>> 27) + 1518500249 + (e & (a ^ b) ^ b) + i12;
        e = e << 30 | e >>> 2;
        int i13 = input[offset + 2] << 24 | (input[offset + 3] & 0xFF) << 16 | (input[offset + 4] & 0xFF) << 8 | input[offset += 5] & 0xFF;
        b += (c << 5 | c >>> 27) + 1518500249 + (d & (e ^ a) ^ a) + i13;
        d = d << 30 | d >>> 2;
        int i14 = input[offset + 1] << 24 | (input[offset + 2] & 0xFF) << 16 | (input[offset + 3] & 0xFF) << 8 | input[offset + 4] & 0xFF;
        a += (b << 5 | b >>> 27) + 1518500249 + (c & (d ^ e) ^ e) + i14;
        c = c << 30 | c >>> 2;
        int i15 = input[offset += 5] << 24 | (input[offset + 1] & 0xFF) << 16 | (input[offset + 2] & 0xFF) << 8 | input[offset + 3] & 0xFF;
        e += (a << 5 | a >>> 27) + 1518500249 + (b & (c ^ d) ^ d) + i15;
        b = b << 30 | b >>> 2;
        i00 ^= i02 ^ i08 ^ i13;
        i00 = i00 << 1 | i00 >>> 31;
        d += (e << 5 | e >>> 27) + 1518500249 + (a & (b ^ c) ^ c) + i00;
        a = a << 30 | a >>> 2;
        i01 ^= i03 ^ i09 ^ i14;
        i01 = i01 << 1 | i01 >>> 31;
        c += (d << 5 | d >>> 27) + 1518500249 + (e & (a ^ b) ^ b) + i01;
        e = e << 30 | e >>> 2;
        i02 ^= i04 ^ i10 ^ i15;
        i02 = i02 << 1 | i02 >>> 31;
        b += (c << 5 | c >>> 27) + 1518500249 + (d & (e ^ a) ^ a) + i02;
        d = d << 30 | d >>> 2;
        i03 ^= i05 ^ i11 ^ i00;
        i03 = i03 << 1 | i03 >>> 31;
        a += (b << 5 | b >>> 27) + 1518500249 + (c & (d ^ e) ^ e) + i03;
        c = c << 30 | c >>> 2;
        i04 ^= i06 ^ i12 ^ i01;
        i04 = i04 << 1 | i04 >>> 31;
        e += (a << 5 | a >>> 27) + 1859775393 + (b ^ c ^ d) + i04;
        b = b << 30 | b >>> 2;
        i05 ^= i07 ^ i13 ^ i02;
        i05 = i05 << 1 | i05 >>> 31;
        d += (e << 5 | e >>> 27) + 1859775393 + (a ^ b ^ c) + i05;
        a = a << 30 | a >>> 2;
        i06 ^= i08 ^ i14 ^ i03;
        i06 = i06 << 1 | i06 >>> 31;
        c += (d << 5 | d >>> 27) + 1859775393 + (e ^ a ^ b) + i06;
        e = e << 30 | e >>> 2;
        i07 ^= i09 ^ i15 ^ i04;
        i07 = i07 << 1 | i07 >>> 31;
        b += (c << 5 | c >>> 27) + 1859775393 + (d ^ e ^ a) + i07;
        d = d << 30 | d >>> 2;
        i08 ^= i10 ^ i00 ^ i05;
        i08 = i08 << 1 | i08 >>> 31;
        a += (b << 5 | b >>> 27) + 1859775393 + (c ^ d ^ e) + i08;
        c = c << 30 | c >>> 2;
        i09 ^= i11 ^ i01 ^ i06;
        i09 = i09 << 1 | i09 >>> 31;
        e += (a << 5 | a >>> 27) + 1859775393 + (b ^ c ^ d) + i09;
        b = b << 30 | b >>> 2;
        i10 ^= i12 ^ i02 ^ i07;
        i10 = i10 << 1 | i10 >>> 31;
        d += (e << 5 | e >>> 27) + 1859775393 + (a ^ b ^ c) + i10;
        a = a << 30 | a >>> 2;
        i11 ^= i13 ^ i03 ^ i08;
        i11 = i11 << 1 | i11 >>> 31;
        c += (d << 5 | d >>> 27) + 1859775393 + (e ^ a ^ b) + i11;
        e = e << 30 | e >>> 2;
        i12 ^= i14 ^ i04 ^ i09;
        i12 = i12 << 1 | i12 >>> 31;
        b += (c << 5 | c >>> 27) + 1859775393 + (d ^ e ^ a) + i12;
        d = d << 30 | d >>> 2;
        i13 ^= i15 ^ i05 ^ i10;
        i13 = i13 << 1 | i13 >>> 31;
        a += (b << 5 | b >>> 27) + 1859775393 + (c ^ d ^ e) + i13;
        c = c << 30 | c >>> 2;
        i14 ^= i00 ^ i06 ^ i11;
        i14 = i14 << 1 | i14 >>> 31;
        e += (a << 5 | a >>> 27) + 1859775393 + (b ^ c ^ d) + i14;
        b = b << 30 | b >>> 2;
        i15 ^= i01 ^ i07 ^ i12;
        i15 = i15 << 1 | i15 >>> 31;
        d += (e << 5 | e >>> 27) + 1859775393 + (a ^ b ^ c) + i15;
        a = a << 30 | a >>> 2;
        i00 ^= i02 ^ i08 ^ i13;
        i00 = i00 << 1 | i00 >>> 31;
        c += (d << 5 | d >>> 27) + 1859775393 + (e ^ a ^ b) + i00;
        e = e << 30 | e >>> 2;
        i01 ^= i03 ^ i09 ^ i14;
        i01 = i01 << 1 | i01 >>> 31;
        b += (c << 5 | c >>> 27) + 1859775393 + (d ^ e ^ a) + i01;
        d = d << 30 | d >>> 2;
        i02 ^= i04 ^ i10 ^ i15;
        i02 = i02 << 1 | i02 >>> 31;
        a += (b << 5 | b >>> 27) + 1859775393 + (c ^ d ^ e) + i02;
        c = c << 30 | c >>> 2;
        i03 ^= i05 ^ i11 ^ i00;
        i03 = i03 << 1 | i03 >>> 31;
        e += (a << 5 | a >>> 27) + 1859775393 + (b ^ c ^ d) + i03;
        b = b << 30 | b >>> 2;
        i04 ^= i06 ^ i12 ^ i01;
        i04 = i04 << 1 | i04 >>> 31;
        d += (e << 5 | e >>> 27) + 1859775393 + (a ^ b ^ c) + i04;
        a = a << 30 | a >>> 2;
        i05 ^= i07 ^ i13 ^ i02;
        i05 = i05 << 1 | i05 >>> 31;
        c += (d << 5 | d >>> 27) + 1859775393 + (e ^ a ^ b) + i05;
        e = e << 30 | e >>> 2;
        i06 ^= i08 ^ i14 ^ i03;
        i06 = i06 << 1 | i06 >>> 31;
        b += (c << 5 | c >>> 27) + 1859775393 + (d ^ e ^ a) + i06;
        d = d << 30 | d >>> 2;
        i07 ^= i09 ^ i15 ^ i04;
        i07 = i07 << 1 | i07 >>> 31;
        a += (b << 5 | b >>> 27) + 1859775393 + (c ^ d ^ e) + i07;
        c = c << 30 | c >>> 2;
        i08 ^= i10 ^ i00 ^ i05;
        i08 = i08 << 1 | i08 >>> 31;
        e += (a << 5 | a >>> 27) + -1894007588 + (b & c | (b | c) & d) + i08;
        b = b << 30 | b >>> 2;
        i09 ^= i11 ^ i01 ^ i06;
        i09 = i09 << 1 | i09 >>> 31;
        d += (e << 5 | e >>> 27) + -1894007588 + (a & b | (a | b) & c) + i09;
        a = a << 30 | a >>> 2;
        i10 ^= i12 ^ i02 ^ i07;
        i10 = i10 << 1 | i10 >>> 31;
        c += (d << 5 | d >>> 27) + -1894007588 + (e & a | (e | a) & b) + i10;
        e = e << 30 | e >>> 2;
        i11 ^= i13 ^ i03 ^ i08;
        i11 = i11 << 1 | i11 >>> 31;
        b += (c << 5 | c >>> 27) + -1894007588 + (d & e | (d | e) & a) + i11;
        d = d << 30 | d >>> 2;
        i12 ^= i14 ^ i04 ^ i09;
        i12 = i12 << 1 | i12 >>> 31;
        a += (b << 5 | b >>> 27) + -1894007588 + (c & d | (c | d) & e) + i12;
        c = c << 30 | c >>> 2;
        i13 ^= i15 ^ i05 ^ i10;
        i13 = i13 << 1 | i13 >>> 31;
        e += (a << 5 | a >>> 27) + -1894007588 + (b & c | (b | c) & d) + i13;
        b = b << 30 | b >>> 2;
        i14 ^= i00 ^ i06 ^ i11;
        i14 = i14 << 1 | i14 >>> 31;
        d += (e << 5 | e >>> 27) + -1894007588 + (a & b | (a | b) & c) + i14;
        a = a << 30 | a >>> 2;
        i15 ^= i01 ^ i07 ^ i12;
        i15 = i15 << 1 | i15 >>> 31;
        c += (d << 5 | d >>> 27) + -1894007588 + (e & a | (e | a) & b) + i15;
        e = e << 30 | e >>> 2;
        i00 ^= i02 ^ i08 ^ i13;
        i00 = i00 << 1 | i00 >>> 31;
        b += (c << 5 | c >>> 27) + -1894007588 + (d & e | (d | e) & a) + i00;
        d = d << 30 | d >>> 2;
        i01 ^= i03 ^ i09 ^ i14;
        i01 = i01 << 1 | i01 >>> 31;
        a += (b << 5 | b >>> 27) + -1894007588 + (c & d | (c | d) & e) + i01;
        c = c << 30 | c >>> 2;
        i02 ^= i04 ^ i10 ^ i15;
        i02 = i02 << 1 | i02 >>> 31;
        e += (a << 5 | a >>> 27) + -1894007588 + (b & c | (b | c) & d) + i02;
        b = b << 30 | b >>> 2;
        i03 ^= i05 ^ i11 ^ i00;
        i03 = i03 << 1 | i03 >>> 31;
        d += (e << 5 | e >>> 27) + -1894007588 + (a & b | (a | b) & c) + i03;
        a = a << 30 | a >>> 2;
        i04 ^= i06 ^ i12 ^ i01;
        i04 = i04 << 1 | i04 >>> 31;
        c += (d << 5 | d >>> 27) + -1894007588 + (e & a | (e | a) & b) + i04;
        e = e << 30 | e >>> 2;
        i05 ^= i07 ^ i13 ^ i02;
        i05 = i05 << 1 | i05 >>> 31;
        b += (c << 5 | c >>> 27) + -1894007588 + (d & e | (d | e) & a) + i05;
        d = d << 30 | d >>> 2;
        i06 ^= i08 ^ i14 ^ i03;
        i06 = i06 << 1 | i06 >>> 31;
        a += (b << 5 | b >>> 27) + -1894007588 + (c & d | (c | d) & e) + i06;
        c = c << 30 | c >>> 2;
        i07 ^= i09 ^ i15 ^ i04;
        i07 = i07 << 1 | i07 >>> 31;
        e += (a << 5 | a >>> 27) + -1894007588 + (b & c | (b | c) & d) + i07;
        b = b << 30 | b >>> 2;
        i08 ^= i10 ^ i00 ^ i05;
        i08 = i08 << 1 | i08 >>> 31;
        d += (e << 5 | e >>> 27) + -1894007588 + (a & b | (a | b) & c) + i08;
        a = a << 30 | a >>> 2;
        i09 ^= i11 ^ i01 ^ i06;
        i09 = i09 << 1 | i09 >>> 31;
        c += (d << 5 | d >>> 27) + -1894007588 + (e & a | (e | a) & b) + i09;
        e = e << 30 | e >>> 2;
        i10 ^= i12 ^ i02 ^ i07;
        i10 = i10 << 1 | i10 >>> 31;
        b += (c << 5 | c >>> 27) + -1894007588 + (d & e | (d | e) & a) + i10;
        d = d << 30 | d >>> 2;
        i11 ^= i13 ^ i03 ^ i08;
        i11 = i11 << 1 | i11 >>> 31;
        a += (b << 5 | b >>> 27) + -1894007588 + (c & d | (c | d) & e) + i11;
        c = c << 30 | c >>> 2;
        i12 ^= i14 ^ i04 ^ i09;
        i12 = i12 << 1 | i12 >>> 31;
        e += (a << 5 | a >>> 27) + -899497514 + (b ^ c ^ d) + i12;
        b = b << 30 | b >>> 2;
        i13 ^= i15 ^ i05 ^ i10;
        i13 = i13 << 1 | i13 >>> 31;
        d += (e << 5 | e >>> 27) + -899497514 + (a ^ b ^ c) + i13;
        a = a << 30 | a >>> 2;
        i14 ^= i00 ^ i06 ^ i11;
        i14 = i14 << 1 | i14 >>> 31;
        c += (d << 5 | d >>> 27) + -899497514 + (e ^ a ^ b) + i14;
        e = e << 30 | e >>> 2;
        i15 ^= i01 ^ i07 ^ i12;
        i15 = i15 << 1 | i15 >>> 31;
        b += (c << 5 | c >>> 27) + -899497514 + (d ^ e ^ a) + i15;
        d = d << 30 | d >>> 2;
        i00 ^= i02 ^ i08 ^ i13;
        i00 = i00 << 1 | i00 >>> 31;
        a += (b << 5 | b >>> 27) + -899497514 + (c ^ d ^ e) + i00;
        c = c << 30 | c >>> 2;
        i01 ^= i03 ^ i09 ^ i14;
        i01 = i01 << 1 | i01 >>> 31;
        e += (a << 5 | a >>> 27) + -899497514 + (b ^ c ^ d) + i01;
        b = b << 30 | b >>> 2;
        i02 ^= i04 ^ i10 ^ i15;
        i02 = i02 << 1 | i02 >>> 31;
        d += (e << 5 | e >>> 27) + -899497514 + (a ^ b ^ c) + i02;
        a = a << 30 | a >>> 2;
        i03 ^= i05 ^ i11 ^ i00;
        i03 = i03 << 1 | i03 >>> 31;
        c += (d << 5 | d >>> 27) + -899497514 + (e ^ a ^ b) + i03;
        e = e << 30 | e >>> 2;
        i04 ^= i06 ^ i12 ^ i01;
        i04 = i04 << 1 | i04 >>> 31;
        b += (c << 5 | c >>> 27) + -899497514 + (d ^ e ^ a) + i04;
        d = d << 30 | d >>> 2;
        i05 ^= i07 ^ i13 ^ i02;
        i05 = i05 << 1 | i05 >>> 31;
        a += (b << 5 | b >>> 27) + -899497514 + (c ^ d ^ e) + i05;
        c = c << 30 | c >>> 2;
        i06 ^= i08 ^ i14 ^ i03;
        i06 = i06 << 1 | i06 >>> 31;
        e += (a << 5 | a >>> 27) + -899497514 + (b ^ c ^ d) + i06;
        b = b << 30 | b >>> 2;
        i07 ^= i09 ^ i15 ^ i04;
        i07 = i07 << 1 | i07 >>> 31;
        d += (e << 5 | e >>> 27) + -899497514 + (a ^ b ^ c) + i07;
        a = a << 30 | a >>> 2;
        i08 ^= i10 ^ i00 ^ i05;
        i08 = i08 << 1 | i08 >>> 31;
        c += (d << 5 | d >>> 27) + -899497514 + (e ^ a ^ b) + i08;
        e = e << 30 | e >>> 2;
        i09 ^= i11 ^ i01 ^ i06;
        i09 = i09 << 1 | i09 >>> 31;
        b += (c << 5 | c >>> 27) + -899497514 + (d ^ e ^ a) + i09;
        d = d << 30 | d >>> 2;
        i10 ^= i12 ^ i02 ^ i07;
        i10 = i10 << 1 | i10 >>> 31;
        a += (b << 5 | b >>> 27) + -899497514 + (c ^ d ^ e) + i10;
        c = c << 30 | c >>> 2;
        i11 ^= i13 ^ i03 ^ i08;
        i11 = i11 << 1 | i11 >>> 31;
        e += (a << 5 | a >>> 27) + -899497514 + (b ^ c ^ d) + i11;
        b = b << 30 | b >>> 2;
        i12 ^= i14 ^ i04 ^ i09;
        i12 = i12 << 1 | i12 >>> 31;
        d += (e << 5 | e >>> 27) + -899497514 + (a ^ b ^ c) + i12;
        a = a << 30 | a >>> 2;
        i13 ^= i15 ^ i05 ^ i10;
        i13 = i13 << 1 | i13 >>> 31;
        c += (d << 5 | d >>> 27) + -899497514 + (e ^ a ^ b) + i13;
        e = e << 30 | e >>> 2;
        i14 ^= i00 ^ i06 ^ i11;
        i14 = i14 << 1 | i14 >>> 31;
        this.hB += (b += (c << 5 | c >>> 27) + -899497514 + (d ^ e ^ a) + i14);
        d = d << 30 | d >>> 2;
        i15 ^= i01 ^ i07 ^ i12;
        i15 = i15 << 1 | i15 >>> 31;
        this.hA += (a += (b << 5 | b >>> 27) + -899497514 + (c ^ d ^ e) + i15);
        this.hE += e;
        this.hD += d;
        this.hC += c << 30 | c >>> 2;
    }
}

